/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.naturalselection.control;

import edu.colorado.phet.naturalselection.NaturalSelectionConstants;
import edu.colorado.phet.naturalselection.NaturalSelectionResources;
import edu.colorado.phet.naturalselection.NaturalSelectionStrings;
import edu.colorado.phet.naturalselection.model.ColorGene;
import edu.colorado.phet.naturalselection.model.Gene;
import edu.colorado.phet.naturalselection.model.GeneListener;
import edu.colorado.phet.naturalselection.model.TailGene;
import edu.colorado.phet.naturalselection.model.TeethGene;
import edu.colorado.phet.naturalselection.util.ImagePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

public class MutationPanel
extends JPanel {
    private JButton colorButton;
    private JButton tailButton;
    private JButton teethButton;
    private ImagePanel colorMutationIndicator;
    private ImagePanel tailMutationIndicator;
    private ImagePanel teethMutationIndicator;
    private static final Insets BUTTON_INSETS = new Insets(2, 0, 2, 10);
    private static final Insets INDICATOR_INSETS = new Insets(0, 0, 0, 0);

    public MutationPanel() {
        this.setLayout(new GridBagLayout());
        this.colorMutationIndicator = new ImagePanel("mutation_small.png");
        this.tailMutationIndicator = new ImagePanel("mutation_small.png");
        this.teethMutationIndicator = new ImagePanel("mutation_small.png");
        this.colorMutationIndicator.setVisible(false);
        this.tailMutationIndicator.setVisible(false);
        this.teethMutationIndicator.setVisible(false);
        this.colorButton = new JButton(NaturalSelectionStrings.GENE_COLOR_BROWN, new ImageIcon(NaturalSelectionResources.getImage("bunny_color_brown.png")));
        this.colorButton.setHorizontalTextPosition(2);
        this.tailButton = new JButton(NaturalSelectionStrings.GENE_TAIL_LONG, new ImageIcon(NaturalSelectionResources.getImage("bunny_tail_short.png")));
        this.tailButton.setHorizontalTextPosition(2);
        this.teethButton = new JButton(NaturalSelectionStrings.GENE_TEETH_LONG, new ImageIcon(NaturalSelectionResources.getImage("bunny_teeth_long.png")));
        this.teethButton.setHorizontalTextPosition(2);
        this.initButtons();
        this.initIndicators();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, this.colorMutationIndicator.getPreferredSize().width, 0, 0);
        this.add(Box.createRigidArea(new Dimension(0, 0)), gridBagConstraints);
        this.colorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ColorGene.getInstance().setMutatable(true);
                MutationPanel.this.colorMutationIndicator.setVisible(true);
                MutationPanel.this.setButtonsEnabled(false);
            }
        });
        this.tailButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TailGene.getInstance().setMutatable(true);
                MutationPanel.this.tailMutationIndicator.setVisible(true);
                MutationPanel.this.setButtonsEnabled(false);
            }
        });
        this.teethButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TeethGene.getInstance().setMutatable(true);
                MutationPanel.this.teethMutationIndicator.setVisible(true);
                MutationPanel.this.setButtonsEnabled(false);
            }
        });
        GeneListener geneListener = new GeneListener(){

            public void onChangeDominantAllele(Gene gene, boolean bl) {
            }

            public void onChangeDistribution(Gene gene, int n, int n2) {
            }

            public void onChangeMutatable(Gene gene, boolean bl) {
                if (!bl) {
                    MutationPanel.this.setButtonsEnabled(true);
                    MutationPanel.this.colorMutationIndicator.setVisible(false);
                    MutationPanel.this.tailMutationIndicator.setVisible(false);
                    MutationPanel.this.teethMutationIndicator.setVisible(false);
                }
            }
        };
        ColorGene.getInstance().addListener(geneListener);
        TailGene.getInstance().addListener(geneListener);
        TeethGene.getInstance().addListener(geneListener);
        this.setBackground(NaturalSelectionConstants.COLOR_ACCESSIBLE_CONTROL_PANEL);
        this.colorMutationIndicator.setBackground(NaturalSelectionConstants.COLOR_ACCESSIBLE_CONTROL_PANEL);
        this.tailMutationIndicator.setBackground(NaturalSelectionConstants.COLOR_ACCESSIBLE_CONTROL_PANEL);
        this.teethMutationIndicator.setBackground(NaturalSelectionConstants.COLOR_ACCESSIBLE_CONTROL_PANEL);
    }

    private void setButtonsEnabled(boolean bl) {
        this.colorButton.setEnabled(bl);
        this.tailButton.setEnabled(bl);
        this.teethButton.setEnabled(bl);
    }

    private void initButtons() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = BUTTON_INSETS;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.colorButton, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.add((Component)this.tailButton, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.add((Component)this.teethButton, gridBagConstraints);
    }

    private void initIndicators() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = INDICATOR_INSETS;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.colorMutationIndicator, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.add((Component)this.tailMutationIndicator, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.add((Component)this.teethMutationIndicator, gridBagConstraints);
    }

    public void reset() {
        this.colorButton.setEnabled(true);
        this.tailButton.setEnabled(true);
        this.teethButton.setEnabled(true);
        this.colorMutationIndicator.setVisible(false);
        this.tailMutationIndicator.setVisible(false);
        this.teethMutationIndicator.setVisible(false);
    }

    public JButton getColorButton() {
        return this.colorButton;
    }

    public JButton getTailButton() {
        return this.tailButton;
    }

    public JButton getTeethButton() {
        return this.teethButton;
    }
}

