/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.mvcexample.view;

import edu.colorado.phet.mvcexample.model.AModelElement;
import edu.colorado.phet.mvcexample.view.PointerNode;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Observable;
import java.util.Observer;

public class ANode
extends PointerNode {
    private AModelElement _modelElement;
    private ModelObserver _modelObserver = new ModelObserver();
    private ViewObserver _viewObserver = new ViewObserver();

    public ANode(AModelElement aModelElement) {
        super(aModelElement.getSize(), aModelElement.getColor());
        this._modelElement = aModelElement;
        this._modelElement.addObserver(this._modelObserver);
        this.addInputEventListener(new PDragEventHandler());
        this.addPropertyChangeListener(this._viewObserver);
        this.updateViewPosition();
        this.updateViewOrientation();
    }

    private void updateViewPosition() {
        this.removePropertyChangeListener(this._viewObserver);
        this.setOffset(this._modelElement.getPosition());
        this.addPropertyChangeListener(this._viewObserver);
    }

    private void updateViewOrientation() {
        this.removePropertyChangeListener(this._viewObserver);
        this.setRotation(this._modelElement.getOrientation());
        this.addPropertyChangeListener(this._viewObserver);
    }

    private void updateModelPosition() {
        this._modelElement.deleteObserver(this._modelObserver);
        this._modelElement.setPosition(this.getOffset());
        this._modelElement.addObserver(this._modelObserver);
    }

    private class ModelObserver
    implements Observer {
        private ModelObserver() {
        }

        public void update(Observable observable, Object object) {
            if (object == "position") {
                ANode.this.updateViewPosition();
            } else if (object == "orientation") {
                ANode.this.updateViewOrientation();
            }
        }
    }

    private class ViewObserver
    implements PropertyChangeListener {
        private ViewObserver() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("transform")) {
                ANode.this.updateModelPosition();
            }
        }
    }
}

