/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.mvcexample.model;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.mvcexample.model.AModelElement;
import edu.colorado.phet.mvcexample.model.BModelElement;
import edu.colorado.phet.mvcexample.model.CModelElement;
import edu.colorado.phet.mvcexample.model.MVCClock;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;

public class MVCModel {
    public static final Color A_COLOR = Color.RED;
    public static final Point2D A_POSITION = new Point2D.Double(400.0, 400.0);
    public static final Dimension A_SIZE = new Dimension(200, 100);
    public static final Color B_COLOR = Color.BLUE;
    public static final Point2D B_POSITION = new Point2D.Double(400.0, 600.0);
    public static final Dimension B_SIZE = new Dimension(200, 100);
    public static final Color C_COLOR = Color.GREEN;
    public static final Point2D C_POSITION = new Point2D.Double(400.0, 800.0);
    public static final Dimension C_SIZE = new Dimension(200, 100);
    private final MVCClock _clock;
    private final ArrayList _modelElements;
    private final AModelElement _aModelElement;
    private final BModelElement _bModelElement;
    private final CModelElement _cModelElement;

    public MVCModel(MVCClock mVCClock) {
        this._clock = mVCClock;
        this._clock.addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                MVCModel.this.stepModelElements(clockEvent.getSimulationTimeChange());
            }
        });
        this._modelElements = new ArrayList();
        this._aModelElement = new AModelElement(A_POSITION, 0.0, A_SIZE, A_COLOR);
        this.addModelElement(this._aModelElement);
        this._bModelElement = new BModelElement(B_POSITION, 0.0, B_SIZE, B_COLOR);
        this.addModelElement(this._bModelElement);
        this._cModelElement = new CModelElement(C_POSITION, 0.0, C_SIZE, C_COLOR);
        this.addModelElement(this._cModelElement);
    }

    public MVCClock getClock() {
        return this._clock;
    }

    protected void addModelElement(ModelElement modelElement) {
        this._modelElements.add(modelElement);
    }

    public AModelElement getAModelElement() {
        return this._aModelElement;
    }

    public BModelElement getBModelElement() {
        return this._bModelElement;
    }

    public CModelElement getCModelElement() {
        return this._cModelElement;
    }

    private void stepModelElements(double d) {
        Iterator iterator = this._modelElements.iterator();
        while (iterator.hasNext()) {
            ModelElement modelElement = (ModelElement)iterator.next();
            modelElement.stepInTime(d);
        }
    }
}

