/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.mvcexample.control;

import edu.colorado.phet.mvcexample.control.BControlPanel;
import edu.colorado.phet.mvcexample.model.BModelElement;
import edu.colorado.phet.mvcexample.view.BNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.geom.Point2D;

public class BConnectionsManager {
    private boolean _connected = false;
    private BModelElement _modelElement;
    private BNode _node;
    private BControlPanel _controlPanel;
    private PInputEventListener _dragHandler;

    public BConnectionsManager(BModelElement bModelElement, BNode bNode, BControlPanel bControlPanel) {
        this._modelElement = bModelElement;
        this._node = bNode;
        this._controlPanel = bControlPanel;
        this._dragHandler = new BNodeDragHandler(bNode, bModelElement);
    }

    public void connect() {
        if (!this._connected) {
            this._modelElement.addListener(this._node);
            this._modelElement.addListener(this._controlPanel);
            this._node.addInputEventListener(this._dragHandler);
            this._connected = true;
        }
    }

    private static class BNodeDragHandler
    extends PBasicInputEventHandler {
        private PNode _node;
        private BModelElement _modelElement;

        public BNodeDragHandler(PNode pNode, BModelElement bModelElement) {
            this._node = pNode;
            this._modelElement = bModelElement;
        }

        public void mouseDragged(PInputEvent pInputEvent) {
            PDimension pDimension = pInputEvent.getDeltaRelativeTo(this._node.getParent());
            Point2D point2D = this._modelElement.getPosition();
            Point2D.Double double_ = new Point2D.Double(point2D.getX() + pDimension.getWidth(), point2D.getY() + pDimension.getHeight());
            this._modelElement.setPosition(double_);
        }
    }
}

