/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.mvcexample.control;

import edu.colorado.phet.mvcexample.MVCExampleApplication;
import edu.colorado.phet.mvcexample.control.PointerControlPanel;
import edu.colorado.phet.mvcexample.model.AModelElement;
import java.util.Observable;
import java.util.Observer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AControlPanel
extends PointerControlPanel {
    private static final String TITLE = MVCExampleApplication.RESOURCE_LOADER.getLocalizedString("AControlPanel.title");
    private AModelElement _modelElement;
    private ModelObserver _modelObserver = new ModelObserver();
    private ControlObserver _controlObserver = new ControlObserver();

    public AControlPanel(AModelElement aModelElement) {
        super(TITLE, aModelElement.getColor());
        this._modelElement = aModelElement;
        this._modelElement.addObserver(this._modelObserver);
        this.getPositionControl().setValue(this._modelElement.getPosition());
        this.getOrientationControl().setValue(this._modelElement.getOrientation());
        this.getOrientationControl().addChangeListener(this._controlObserver);
    }

    public void modelPositionChanged() {
        this.getPositionControl().setValue(this._modelElement.getPosition());
    }

    public void modelOrientationChanged() {
        double d = Math.toDegrees(this._modelElement.getOrientation());
        this.getOrientationControl().removeChangeListener(this._controlObserver);
        this.getOrientationControl().setValue(d);
        this.getOrientationControl().addChangeListener(this._controlObserver);
    }

    private void controlOrientationChanged() {
        double d = Math.toRadians(this.getOrientationControl().getValue());
        this._modelElement.deleteObserver(this._modelObserver);
        this._modelElement.setOrientation(d);
        this._modelElement.addObserver(this._modelObserver);
    }

    private class ControlObserver
    implements ChangeListener {
        private ControlObserver() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            if (object == AControlPanel.this.getOrientationControl()) {
                AControlPanel.this.controlOrientationChanged();
            }
        }
    }

    private class ModelObserver
    implements Observer {
        private ModelObserver() {
        }

        public void update(Observable observable, Object object) {
            if (object == "position") {
                AControlPanel.this.modelPositionChanged();
            } else if (object == "orientation") {
                AControlPanel.this.modelOrientationChanged();
            }
        }
    }
}

