/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.mvcexample;

import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.mvcexample.MVCExampleApplication;
import edu.colorado.phet.mvcexample.control.BConnectionsManager;
import edu.colorado.phet.mvcexample.control.BControlPanel;
import edu.colorado.phet.mvcexample.control.MVCControlPanel;
import edu.colorado.phet.mvcexample.model.AModelElement;
import edu.colorado.phet.mvcexample.model.BModelElement;
import edu.colorado.phet.mvcexample.model.CModelElement;
import edu.colorado.phet.mvcexample.model.MVCClock;
import edu.colorado.phet.mvcexample.model.MVCModel;
import edu.colorado.phet.mvcexample.view.BNode;
import edu.colorado.phet.mvcexample.view.MVCCanvas;
import java.awt.Dimension;
import java.awt.Frame;

public class MVCModule
extends Module {
    private static final Dimension VIEW_SIZE = new Dimension(1500, 1500);
    private static final String TITLE = MVCExampleApplication.RESOURCE_LOADER.getLocalizedString("MVCModule.title");
    private MVCModel _model;
    private MVCCanvas _canvas;
    private MVCControlPanel _controlPanel;

    public MVCModule(Frame frame) {
        super(TITLE, new MVCClock(25, 1.0, true));
        this.setLogoPanel(null);
        MVCClock mVCClock = (MVCClock)this.getClock();
        this._model = new MVCModel(mVCClock);
        this._canvas = new MVCCanvas(VIEW_SIZE, this._model);
        this.setSimulationPanel(this._canvas);
        this._controlPanel = new MVCControlPanel(this, this._model, frame);
        this.setControlPanel(this._controlPanel);
        BModelElement bModelElement = this._model.getBModelElement();
        BNode bNode = this._canvas.getBNode();
        BControlPanel bControlPanel = this._controlPanel.getBControlPanel();
        BConnectionsManager bConnectionsManager = new BConnectionsManager(bModelElement, bNode, bControlPanel);
        bConnectionsManager.connect();
        this.reset();
    }

    public void reset() {
        MVCClock mVCClock = this._model.getClock();
        mVCClock.setDt(1.0);
        this.setClockRunningWhenActive(true);
        AModelElement aModelElement = this._model.getAModelElement();
        aModelElement.setPosition(MVCModel.A_POSITION);
        aModelElement.setOrientation(0.0);
        BModelElement bModelElement = this._model.getBModelElement();
        bModelElement.setPosition(MVCModel.B_POSITION);
        bModelElement.setOrientation(0.0);
        CModelElement cModelElement = this._model.getCModelElement();
        cModelElement.setPosition(MVCModel.C_POSITION);
        cModelElement.setOrientation(0.0);
    }
}

