/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view;

import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;

public class HelpPanel
extends JPanel {
    private boolean miniHelpShowing = false;
    private String showHelpStr = PhetCommonResources.getInstance().getLocalizedString("Common.HelpPanel.ShowHelp");
    private String hideHelpStr = PhetCommonResources.getInstance().getLocalizedString("Common.HelpPanel.HideHelp");
    private String megaHelpStr = PhetCommonResources.getInstance().getLocalizedString("Common.HelpPanel.MegaHelp");
    private JButton miniHelpBtn;
    private JButton megaHelpBtn;
    private int padY = 2;
    private Module module;

    public HelpPanel(final Module module) {
        this.module = module;
        this.miniHelpBtn = new JButton(this.showHelpStr);
        this.megaHelpBtn = new JButton(this.megaHelpStr);
        SwingUtils.fixButtonOpacity(this.miniHelpBtn);
        SwingUtils.fixButtonOpacity(this.megaHelpBtn);
        this.miniHelpBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HelpPanel.this.miniHelpShowing = !HelpPanel.this.miniHelpShowing;
                if (HelpPanel.this.miniHelpShowing) {
                    HelpPanel.this.setTwoButtonMode();
                } else {
                    HelpPanel.this.setOneButtonMode();
                }
                module.setHelpEnabled(HelpPanel.this.miniHelpShowing);
                PhetApplication.instance().getPhetFrame().getHelpMenu().setHelpSelected(HelpPanel.this.miniHelpShowing);
            }
        });
        this.megaHelpBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                module.showMegaHelp();
            }
        });
        this.add(this.miniHelpBtn);
        this.add(this.megaHelpBtn);
        this.layoutPanel();
        this.setOneButtonMode();
    }

    private void layoutPanel() {
        this.setPreferredSize(new Dimension((int)Math.max(this.miniHelpBtn.getPreferredSize().getWidth(), this.megaHelpBtn.getPreferredSize().getWidth()), (int)(this.miniHelpBtn.getPreferredSize().getHeight() + this.megaHelpBtn.getPreferredSize().getHeight() + (double)(this.padY * 2))));
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.miniHelpBtn, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.add((Component)this.megaHelpBtn, gridBagConstraints);
    }

    private void setOneButtonMode() {
        this.megaHelpBtn.setVisible(false);
        this.miniHelpBtn.setText(this.showHelpStr);
        this.layoutPanel();
    }

    private void setTwoButtonMode() {
        this.megaHelpBtn.setVisible(this.module.hasMegaHelp());
        this.miniHelpBtn.setText(this.hideHelpStr);
        this.layoutPanel();
    }

    public void setHelpEnabled(boolean bl) {
        this.miniHelpShowing = bl;
        if (bl) {
            this.miniHelpBtn.setText(this.hideHelpStr);
        } else {
            this.miniHelpBtn.setText(this.showHelpStr);
        }
    }

    public boolean isHelpEnabled() {
        return this.miniHelpShowing;
    }
}

