/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view;

import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.view.ResetAllButton;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.Scrollable;

public class ControlPanel
extends JPanel {
    private ContentPanel contentPanel;
    private JScrollPane scrollPane;
    private Scrollable scrollPolicy;

    public ControlPanel() {
        this.setLayout(new BorderLayout());
        this.contentPanel = new ContentPanel();
        this.contentPanel.setFillNone();
        this.scrollPolicy = new DefaultScrollPolicy(this.contentPanel);
        this.scrollPane = new JScrollPane(this.contentPanel, 20, 31);
        this.add((Component)this.scrollPane, "Center");
        this.scrollPane.setOpaque(false);
        this.scrollPane.getViewport().setOpaque(false);
    }

    public Component addControl(Component component) {
        return this.contentPanel.add(component);
    }

    public void addControlFullWidth(Component component) {
        this.contentPanel.addFullWidth(component);
    }

    public Component add(Component component) {
        return this.addControl(component);
    }

    public void addSeparator() {
        this.addControlFullWidth(new JSeparator());
    }

    public void addVerticalSpace(int n) {
        if (n > 0) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.add(Box.createVerticalStrut(n));
            this.addControlFullWidth(jPanel);
        }
    }

    private int getVisibleScrollBarWidth() {
        return this.isScrollBarVisible() ? this.getScrollBarWidth() : 0;
    }

    private int getScrollBarWidth() {
        return this.scrollPane.getVerticalScrollBar().getPreferredSize().width;
    }

    private boolean isScrollBarVisible() {
        return this.scrollPane.getVerticalScrollBar().isVisible();
    }

    public JButton addResetAllButton(Resettable resettable) {
        return this.addResetAllButton(new Resettable[]{resettable});
    }

    public JButton addResetAllButton(Resettable[] resettableArray) {
        ResetAllButton resetAllButton = new ResetAllButton(resettableArray, PhetApplication.instance().getPhetFrame());
        this.addControl(resetAllButton);
        return resetAllButton;
    }

    public class ContentPanel
    extends VerticalLayoutPanel
    implements Scrollable {
        public boolean getScrollableTracksViewportHeight() {
            return ControlPanel.this.scrollPolicy.getScrollableTracksViewportHeight();
        }

        public boolean getScrollableTracksViewportWidth() {
            return ControlPanel.this.scrollPolicy.getScrollableTracksViewportWidth();
        }

        public Dimension getPreferredScrollableViewportSize() {
            return ControlPanel.this.scrollPolicy.getPreferredScrollableViewportSize();
        }

        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            return ControlPanel.this.scrollPolicy.getScrollableBlockIncrement(rectangle, n, n2);
        }

        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            return ControlPanel.this.scrollPolicy.getScrollableUnitIncrement(rectangle, n, n2);
        }
    }

    public class DefaultScrollPolicy
    implements Scrollable {
        JComponent component;

        public DefaultScrollPolicy(JComponent jComponent) {
            this.component = jComponent;
        }

        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        public Dimension getPreferredScrollableViewportSize() {
            return new Dimension(this.component.getPreferredSize().width + ControlPanel.this.getVisibleScrollBarWidth(), this.component.getPreferredSize().height);
        }

        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            return 10;
        }

        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            return 10;
        }
    }
}

