/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.mri.view;

import edu.colorado.phet.common.phetcommon.util.PhysicsUtil;
import edu.colorado.phet.common.phetcommon.view.ModelSlider;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.util.PImageFactory;
import edu.colorado.phet.common.quantum.model.PhotonSource;
import edu.colorado.phet.mri.MriResources;
import edu.colorado.phet.mri.controller.AbstractMriModule;
import edu.colorado.phet.mri.controller.EmRepSelector;
import edu.colorado.phet.mri.model.MriModel;
import edu.colorado.phet.mri.model.RadiowaveSource;
import edu.colorado.phet.mri.util.GraphicPSwing;
import edu.colorado.phet.mri.view.EnergySquiggle;
import edu.colorado.phet.mri.view.EnergySquiggleUpdater;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;

public class RadiowaveSourceGraphic
extends PNode {
    private double SQUIGGLE_LENGTH_CALIBRATION_FACTOR = 2.07515E8;
    private Font font = new PhetFont(1, 16);
    private double panelDepth = 93.0;
    private EnergySquiggle energySquiggle;
    private MriModel model;
    private RadiowaveSource radiowaveSource;
    private ModelSlider frequencySlider;

    public RadiowaveSourceGraphic(final RadiowaveSource radiowaveSource, final AbstractMriModule abstractMriModule) {
        this.model = (MriModel)abstractMriModule.getModel();
        this.radiowaveSource = radiowaveSource;
        double d = 700.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        if (radiowaveSource.getOrientation() == RadiowaveSource.HORIZONTAL) {
            d2 = d;
            d3 = this.panelDepth;
            d4 = radiowaveSource.getPosition().getX() - d2 / 2.0;
            d5 = radiowaveSource.getPosition().getY();
        } else if (radiowaveSource.getOrientation() == RadiowaveSource.VERTICAL) {
            d2 = this.panelDepth;
            d3 = d;
            d4 = radiowaveSource.getPosition().getX();
            d5 = radiowaveSource.getPosition().getY() + d3 / 2.0;
        }
        this.setOffset(d4, d5);
        PImage pImage = PImageFactory.create("mri/images/radiowave-control-background.png", new Dimension((int)d, (int)d3));
        this.addChild(pImage);
        Insets insets = new Insets(5, 5, 5, 5);
        this.frequencySlider = new ModelSlider(MriResources.getString("Misc.Frequency"), MriResources.getString("Misc.Frequency.Units"), 10.0, 110.0, 60.0, new DecimalFormat("0.0"), new DecimalFormat("0"));
        this.frequencySlider.setNumMajorTicks(5);
        this.frequencySlider.setFont(this.font);
        Serializable serializable = this.frequencySlider.getUnitsReadout();
        Serializable serializable2 = ((Component)serializable).getFont();
        Serializable serializable3 = new Font(((Font)serializable2).getName(), 0, ((Font)serializable2).getSize());
        ((JTextField)serializable).setFont((Font)serializable3);
        this.frequencySlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                radiowaveSource.setFrequency(RadiowaveSourceGraphic.this.frequencySlider.getValue() * 1000000.0);
            }
        });
        this.frequencySlider.getSlider().addMouseListener(new MouseInputAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                if (abstractMriModule.getMriModel().isTransitionMatch()) {
                    double d = abstractMriModule.getMriModel().getMatchingFrequency();
                    radiowaveSource.setFrequency(d);
                    RadiowaveSourceGraphic.this.updateFrequencySliderValue();
                }
            }
        });
        radiowaveSource.setFrequency(this.frequencySlider.getValue() * 1000000.0);
        serializable = new GraphicPSwing(new PSwing(this.frequencySlider), "mri/images/control-background.png");
        ((PNode)serializable).setOffset(d - (double)insets.right - ((PNode)serializable).getBounds().getWidth(), insets.top);
        this.frequencySlider.getTextField().setOpaque(true);
        this.addChild((PNode)serializable);
        this.frequencySlider.addChangeListener(new ChangeListener((PNode)serializable){
            final /* synthetic */ PNode val$freqPSwing;
            {
                this.val$freqPSwing = pNode;
            }

            public void stateChanged(ChangeEvent changeEvent) {
                this.val$freqPSwing.repaint();
            }
        });
        if (abstractMriModule.auxiliarySquiggleVisible()) {
            this.addAuxiliarySquiggle(d, insets, (PNode)serializable, radiowaveSource);
        }
        serializable2 = new ModelSlider(MriResources.getString("Misc.Power"), MriResources.getString("percent"), 0.0, 100.0, 0.0, new DecimalFormat("0"));
        serializable3 = ((ModelSlider)serializable2).getUnitsReadout();
        Serializable serializable4 = ((Component)serializable3).getFont();
        Serializable serializable5 = new Font(serializable4.getName(), 0, serializable4.getSize());
        ((JTextField)serializable3).setFont((Font)serializable5);
        ((ModelSlider)serializable2).addChangeListener(new ChangeListener((ModelSlider)serializable2){
            final /* synthetic */ ModelSlider val$powerCtrl;
            {
                this.val$powerCtrl = modelSlider;
            }

            public void stateChanged(ChangeEvent changeEvent) {
                radiowaveSource.setPower(this.val$powerCtrl.getValue());
            }
        });
        ((ModelSlider)serializable2).setValue(((ModelSlider)serializable2).getValue());
        serializable3 = new GraphicPSwing(new PSwing((JComponent)serializable2), "mri/images/control-background.png");
        ((ModelSlider)serializable2).getTextField().setOpaque(true);
        ((PNode)serializable3).setOffset(insets.left, insets.top);
        this.addChild((PNode)serializable3);
        serializable4 = new EmRepSelector(abstractMriModule);
        serializable5 = new GraphicPSwing(new PSwing((JComponent)serializable4), "mri/images/radio-button-background.png");
        ((PNode)serializable5).setOffset((d - ((PNode)serializable5).getBounds().getWidth()) / 2.0, this.panelDepth - (double)insets.bottom - ((PNode)serializable5).getBounds().getHeight());
        this.addChild((PNode)serializable5);
        PText pText = new PText(MriResources.getString("Misc.RadiowaveSourceLabel"));
        pText.setPaint(new Color(0, 0, 0, 0));
        pText.setTextPaint(Color.white);
        pText.setFont(this.font);
        pText.setJustification(0.5f);
        pText.setOffset(d / 2.0 - pText.getBounds().getWidth() / 2.0, 10.0);
        this.addChild(pText);
        radiowaveSource.addRateChangeListener(new PhotonSource.RateChangeListener((ModelSlider)serializable2){
            final /* synthetic */ ModelSlider val$powerCtrl;
            {
                this.val$powerCtrl = modelSlider;
            }

            public void rateChangeOccurred(PhotonSource.RateChangeEvent rateChangeEvent) {
                this.val$powerCtrl.setValue(((RadiowaveSource)rateChangeEvent.getSource()).getPower());
            }
        });
        radiowaveSource.addWavelengthChangeListener(new PhotonSource.WavelengthChangeListener(){

            public void wavelengthChanged(PhotonSource.WavelengthChangeEvent wavelengthChangeEvent) {
                RadiowaveSourceGraphic.this.updateFrequencySliderValue();
            }
        });
    }

    private void updateFrequencySliderValue() {
        this.frequencySlider.setValue(PhysicsUtil.wavelengthToFrequency(this.radiowaveSource.getWavelength()) / 1000000.0);
    }

    private void addAuxiliarySquiggle(double d, Insets insets, PNode pNode, RadiowaveSource radiowaveSource) {
        this.energySquiggle = new EnergySquiggle(EnergySquiggle.VERTICAL);
        final PPath pPath = new PPath(new Rectangle2D.Double(0.0, 0.0, 15.0, 80.0));
        pPath.setPaint(Color.white);
        pPath.setStrokePaint(Color.black);
        PNode pNode2 = new PNode();
        pNode2.addChild(pPath);
        pNode2.addChild(this.energySquiggle);
        pNode2.setOffset(d - (double)(insets.right * 2) - pNode.getWidth() - pPath.getWidth(), insets.top);
        this.addChild(pNode2);
        final EnergySquiggleUpdater energySquiggleUpdater = new EnergySquiggleUpdater(this.energySquiggle, this.model);
        radiowaveSource.addRateChangeListener(new PhotonSource.RateChangeListener(){

            public void rateChangeOccurred(PhotonSource.RateChangeEvent rateChangeEvent) {
                double d = (pPath.getBounds().getWidth() - RadiowaveSourceGraphic.this.energySquiggle.getFullBounds().getWidth()) / 2.0;
                double d2 = pPath.getBounds().getHeight();
                energySquiggleUpdater.updateSquiggle(d, d2, RadiowaveSourceGraphic.this.SQUIGGLE_LENGTH_CALIBRATION_FACTOR);
            }
        });
        radiowaveSource.addWavelengthChangeListener(new PhotonSource.WavelengthChangeListener(){

            public void wavelengthChanged(PhotonSource.WavelengthChangeEvent wavelengthChangeEvent) {
                double d = (pPath.getBounds().getWidth() - RadiowaveSourceGraphic.this.energySquiggle.getFullBounds().getWidth()) / 2.0;
                double d2 = pPath.getBounds().getHeight();
                energySquiggleUpdater.updateSquiggle(d, d2, RadiowaveSourceGraphic.this.SQUIGGLE_LENGTH_CALIBRATION_FACTOR);
            }
        });
        this.model.addListener(new MriModel.ChangeAdapter(){

            public void fieldChanged(MriModel mriModel) {
                double d = (pPath.getBounds().getWidth() - RadiowaveSourceGraphic.this.energySquiggle.getFullBounds().getWidth()) / 2.0;
                double d2 = pPath.getBounds().getHeight();
                energySquiggleUpdater.updateSquiggle(d, d2, RadiowaveSourceGraphic.this.SQUIGGLE_LENGTH_CALIBRATION_FACTOR);
            }
        });
    }
}

