/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.mri.view;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.common.phetcommon.view.util.MakeDuotoneImageOp;
import edu.colorado.phet.common.phetcommon.view.util.VisibleColor;
import edu.colorado.phet.common.quantum.model.Photon;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.Color;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class PhotonGraphic
extends PImage
implements SimpleObserver,
Photon.LeftSystemEventListener,
Photon.VelocityChangedListener {
    public static final int s_imgHeight = (int)Photon.RADIUS;
    private static ArrayList s_inactiveInstances = new ArrayList();
    private static ArrayList s_instances = new ArrayList();
    private static HashMap s_colorToImage = new HashMap();
    static String s_imageName = "images/photon-comet.png";
    static BufferedImage s_baseImage;
    static BufferedImage s_IRphotonGraphic;
    static HashMap colorMap;
    static HashMap s_animationMap;
    private double xOffset;
    private double yOffset;
    private double theta;
    private Vector2D velocity;
    private Photon photon;
    private Color color;
    double baseImageHeight;
    double baseImageWidth;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PhotonGraphic getInstance(Photon photon) {
        PhotonGraphic photonGraphic = null;
        ArrayList arrayList = s_inactiveInstances;
        synchronized (arrayList) {
            if (s_inactiveInstances.size() > 0) {
                int n = s_inactiveInstances.size() - 1;
                photonGraphic = (PhotonGraphic)s_inactiveInstances.get(n);
                s_inactiveInstances.remove(n);
                photonGraphic.init(photon);
            } else {
                photonGraphic = new PhotonGraphic(photon);
            }
        }
        return photonGraphic;
    }

    private PhotonGraphic(Photon photon) {
        super(s_baseImage);
        this.init(photon);
        photon.addLeftSystemListener(this);
        s_instances.add(this);
    }

    private void init(Photon photon) {
        this.photon = photon;
        this.color = VisibleColor.wavelengthToColor(photon.getWavelength());
        photon.addObserver(this);
        photon.addVelocityChangedListener(this);
        this.velocity = new Vector2D(photon.getVelocity());
        this.createImage(photon);
        this.computeOffsets(this.velocity.getAngle());
        this.setOffset((int)(photon.getPosition().getX() - this.xOffset), (int)(photon.getPosition().getY() - this.yOffset));
    }

    private void createImage(Photon photon) {
        Object object;
        Double d = new Double(photon.getWavelength());
        BufferedImage bufferedImage = null;
        if (photon.getWavelength() > 780.0) {
            bufferedImage = s_IRphotonGraphic;
        } else {
            bufferedImage = (BufferedImage)s_colorToImage.get(d);
            if (bufferedImage == null) {
                object = new MakeDuotoneImageOp(VisibleColor.wavelengthToColor(photon.getWavelength()));
                bufferedImage = new BufferedImage(s_baseImage.getWidth(), s_baseImage.getHeight(), 2);
            } else {
                System.out.println("PhotonGraphic.createImage");
            }
        }
        this.baseImageHeight = bufferedImage.getHeight();
        this.baseImageWidth = bufferedImage.getWidth();
        this.theta = photon.getVelocity().getAngle();
        object = BufferedImageUtils.getRotatedImage(bufferedImage, this.theta);
        this.setImage((Image)object);
    }

    public void update() {
        this.setOffset((int)(this.photon.getPosition().getX() - this.xOffset), (int)(this.photon.getPosition().getY() - this.yOffset));
    }

    public void velocityChanged(Photon.VelocityChangedEvent velocityChangedEvent) {
        this.createImage((Photon)velocityChangedEvent.getSource());
        this.computeOffsets(this.photon.getVelocity().getAngle());
        this.setOffset((int)(this.photon.getPosition().getX() - this.xOffset), (int)(this.photon.getPosition().getY() - this.yOffset));
    }

    private void computeOffsets(double d) {
        this.theta = d = (d % (Math.PI * 2) + Math.PI * 2) % (Math.PI * 2);
        this.xOffset = 0.0;
        this.yOffset = 0.0;
        double d2 = 0.0;
        double d3 = this.baseImageWidth;
        double d4 = this.baseImageHeight;
        if (d >= 0.0 && d <= 1.5707963267948966) {
            this.xOffset = d3 * Math.cos(d) + d4 / 2.0 * Math.sin(d);
            this.yOffset = d3 * Math.sin(d) + d4 / 2.0 * Math.cos(d);
        }
        if (d > 1.5707963267948966 && d <= Math.PI) {
            d2 = d - 1.5707963267948966;
            this.xOffset = d4 / 2.0 * Math.cos(d2);
            this.yOffset = d3 * Math.cos(d2) + d4 / 2.0 * Math.sin(d2);
        }
        if (d > Math.PI && d <= 4.71238898038469) {
            d2 = d - Math.PI;
            this.xOffset = d4 / 2.0 * Math.sin(d2);
            this.yOffset = d4 / 2.0 * Math.cos(d2);
        }
        if (d > 4.71238898038469 && d <= Math.PI * 2) {
            d2 = Math.PI * 2 - d;
            this.xOffset = d3 * Math.cos(d2) + d4 / 2.0 * Math.sin(d2);
            this.yOffset = d4 / 2.0 * Math.cos(d2);
        }
    }

    public void leftSystemEventOccurred(Photon.LeftSystemEvent leftSystemEvent) {
        s_instances.remove(this);
        this.photon = null;
    }

    static {
        try {
            s_baseImage = ImageLoader.loadBufferedImage(s_imageName);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        double d = (double)s_imgHeight / (double)s_baseImage.getHeight();
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d, d);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
        s_baseImage = affineTransformOp.filter(s_baseImage, null);
        int n = 180;
        s_IRphotonGraphic = new BufferedImage(s_baseImage.getWidth(), s_baseImage.getHeight(), 2);
        ColorModel colorModel = s_baseImage.getColorModel();
        for (int i = 0; i < s_baseImage.getWidth(); ++i) {
            for (int j = 0; j < s_baseImage.getHeight(); ++j) {
                int n2 = s_baseImage.getRGB(i, j);
                int n3 = colorModel.getAlpha(n2);
                int n4 = colorModel.getRed(n2);
                int n5 = colorModel.getGreen(n2);
                int n6 = colorModel.getBlue(n2);
                int n7 = 0;
                if (n3 > 0) {
                    if (n4 + n5 + n6 > n) {
                        n3 = 0;
                    } else {
                        n6 = 0;
                        n5 = 0;
                        n4 = 0;
                        n3 = 255;
                    }
                }
                n7 = n3 * 0x1000000 + 0 + 0 + 0;
                s_IRphotonGraphic.setRGB(i, j, n7);
            }
        }
        colorMap = new HashMap();
        colorMap.put(new Double(Photon.RED), Color.red);
        colorMap.put(new Double(Photon.BLUE), Color.blue);
        colorMap.put(new Double(Photon.DEEP_RED), new Color(100, 0, 0));
        s_animationMap = new HashMap();
    }
}

