/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.mri.view;

import edu.colorado.phet.common.piccolophet.nodes.RegisterablePNode;
import edu.colorado.phet.common.piccolophet.util.PImageFactory;
import edu.colorado.phet.mri.MriResources;
import edu.colorado.phet.mri.model.Electromagnet;
import edu.colorado.phet.mri.model.GradientElectromagnet;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Dimension;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class ElectromagnetGraphic
extends RegisterablePNode
implements Electromagnet.ChangeListener {
    private PNode coilGraphic;
    private PNode upperLead;
    private PNode lowerLead;
    private GradientElectromagnet magnet;
    private double scale;

    public ElectromagnetGraphic(GradientElectromagnet gradientElectromagnet) {
        this(gradientElectromagnet, 1.0);
    }

    public ElectromagnetGraphic(GradientElectromagnet gradientElectromagnet, double d) {
        this.scale = d;
        this.magnet = gradientElectromagnet;
        gradientElectromagnet.addChangeListener(this);
        Rectangle2D rectangle2D = gradientElectromagnet.getBounds();
        this.setRegistrationPoint(rectangle2D.getWidth() / 2.0, rectangle2D.getHeight() / 2.0);
        this.createLeadWires(rectangle2D);
        this.update();
    }

    private void createLeadWires(Rectangle2D rectangle2D) {
        Line2D.Double double_ = new Line2D.Double(-300.0, 10.0, 0.0, 10.0);
        Line2D.Double double_2 = new Line2D.Double(-300.0, rectangle2D.getHeight() - 10.0, 0.0, rectangle2D.getHeight() - 10.0);
        this.upperLead = new PPath(double_);
        this.lowerLead = new PPath(double_2);
        this.addChild(this.upperLead);
        this.addChild(this.lowerLead);
        if (this.magnet.getOrientation() == GradientElectromagnet.HORIZONTAL) {
            this.coilGraphic = PImageFactory.create(MriResources.getImage("coil-1.png"), new Dimension((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight()));
        } else {
            this.coilGraphic = PImageFactory.create(MriResources.getImage("coil-1.png"), new Dimension((int)rectangle2D.getHeight(), (int)rectangle2D.getWidth()));
            this.coilGraphic.rotate(1.5707963267948966);
            this.coilGraphic.translate(0.0, -rectangle2D.getWidth());
        }
        this.addChild(this.coilGraphic);
    }

    public void update() {
        this.setOffset(this.magnet.getPosition());
    }

    public void stateChanged(Electromagnet.ChangeEvent changeEvent) {
        this.update();
    }
}

