/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.mri.util;

import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Hashtable;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class SliderControl
extends JPanel {
    private double _value;
    private double _min;
    private double _max;
    private double _tickSpacing;
    private JSlider _slider;
    private JFormattedTextField _valueTextField;
    private JLabel _valueLabel;
    private JLabel _unitsLabel;
    private double _multiplier;
    private DecimalFormat _tickNumberFormat;
    private DecimalFormat _valueNumberFormat;
    private EventListenerList _listenerList;
    private boolean _notifyWhileDragging;
    private boolean _isDragging;

    public SliderControl(double d, double d2, double d3, double d4, int n, int n2, String string, String string2, int n3, Insets insets) {
        if (d < d2 || d > d3) {
            throw new IllegalArgumentException("value is out of range: " + d);
        }
        if (d2 > d3) {
            throw new IllegalArgumentException("min > max");
        }
        if (n < 0) {
            throw new IllegalArgumentException("tickPrecision must be >= 0");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("valuePrecision must be >= 0");
        }
        this._value = d;
        this._min = d2;
        this._max = d3;
        this._tickSpacing = d4;
        this._multiplier = Math.pow(10.0, n2);
        this._tickNumberFormat = this.createFormat(n);
        this._valueNumberFormat = this.createFormat(n2);
        this._notifyWhileDragging = true;
        this._isDragging = false;
        this._listenerList = new EventListenerList();
        JPanel jPanel = new JPanel();
        this._valueLabel = new JLabel(string, 4);
        this._unitsLabel = new JLabel(string2, 2);
        this._valueTextField = new JFormattedTextField(this._valueNumberFormat);
        this._valueTextField.setValue(new Double(d));
        this._valueTextField.setHorizontalAlignment(4);
        this._valueTextField.setEditable(false);
        this._valueTextField.setColumns(n3);
        jPanel.setLayout(new GridBagLayout());
        Object object = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 3, 0, 2), 0, 0);
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).anchor = 13;
        jPanel.add((Component)this._valueLabel, object);
        ++((GridBagConstraints)object).gridx;
        ((GridBagConstraints)object).anchor = 10;
        jPanel.add((Component)this._valueTextField, object);
        ++((GridBagConstraints)object).gridx;
        ((GridBagConstraints)object).anchor = 17;
        ((GridBagConstraints)object).fill = 2;
        jPanel.add((Component)this._unitsLabel, object);
        this._slider = new JSlider();
        this._slider.setMinimum((int)(this._min * this._multiplier));
        this._slider.setMaximum((int)(this._max * this._multiplier));
        this._slider.setValue((int)(d * this._multiplier));
        this._slider.setMajorTickSpacing((int)((this._max - this._min) * this._multiplier));
        this._slider.setMinorTickSpacing((int)(this._tickSpacing * this._multiplier));
        this._slider.setPaintTicks(true);
        this._slider.setPaintLabels(true);
        this.updateTickLabels();
        object = new EasyGridBagLayout(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0);
        if (insets != null) {
            ((EasyGridBagLayout)object).setInsets(insets);
            gridBagConstraints.insets = insets;
        }
        this.setLayout(new GridBagLayout());
        this.add((Component)jPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this._slider, gridBagConstraints);
        object = new EventDispatcher();
        this._valueTextField.addActionListener((ActionListener)object);
        this._valueTextField.addFocusListener((FocusListener)object);
        this._valueTextField.addKeyListener((KeyListener)object);
        this._slider.addChangeListener((ChangeListener)object);
        this.setValue(d);
    }

    public void setValue(double d) {
        this.setValue(d, true);
    }

    private void setValue(double d, boolean bl) {
        if (this.isValid(d)) {
            this._value = d;
            this.updateView();
            if (bl) {
                this.fireChangeEvent(new ChangeEvent(this));
            }
        } else {
            this.warnUser();
            System.out.println("SliderControl.setValue: invalid value for slider labeled \"" + this._valueLabel.getText() + "\", " + "range is " + this._min + " to " + this._max + ", tried to set " + d);
            this.updateView();
        }
    }

    public double getValue() {
        return this._value;
    }

    public void setEnabled(boolean bl) {
        this._valueLabel.setEnabled(bl);
        this._valueTextField.setEnabled(bl);
        this._unitsLabel.setEnabled(bl);
        this._slider.setEnabled(bl);
    }

    public boolean isEnabled() {
        return this._slider.isEnabled();
    }

    public boolean isInverted() {
        return this._slider.getInverted();
    }

    public JSlider getSlider() {
        return this._slider;
    }

    public void setTextEditable(boolean bl) {
        this._valueTextField.setEditable(bl);
        if (bl) {
            this._valueTextField.setBackground(Color.white);
        }
    }

    private double getSliderValue() {
        int n = this.getSlider().getValue();
        double d = 0.0;
        if (this.isInverted()) {
            d = ((this._max + this._min) * this._multiplier - (double)n) / this._multiplier;
            if (d > this._max) {
                d = this._max;
            }
        } else {
            d = (double)n / this._multiplier;
        }
        return d;
    }

    private double getTextFieldValue() {
        return ((Number)this._valueTextField.getValue()).doubleValue();
    }

    private void updateView() {
        this.updateTextField();
        this.updateSlider();
    }

    private void updateTextField() {
        String string = this._valueNumberFormat.format(this._value);
        this._valueTextField.setText(string);
    }

    private void updateSlider() {
        int n = 0;
        n = this.isInverted() ? (int)((this._max + this._min) * this._multiplier - this._value * this._multiplier) : (int)(this._value * this._multiplier);
        this._slider.setValue(n);
    }

    private boolean isValid(double d) {
        return d >= this._min && d <= this._max;
    }

    private void updateTickLabels() {
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        if (this.isInverted()) {
            hashtable.put(new Integer((int)(this._max * this._multiplier)), new JLabel(this._tickNumberFormat.format(this._min)));
            hashtable.put(new Integer((int)(this._min * this._multiplier)), new JLabel(this._tickNumberFormat.format(this._max)));
            double d = this._max - this._tickSpacing;
            double d2 = this._min + this._tickSpacing;
            while (d > this._min) {
                hashtable.put(new Integer((int)(d2 * this._multiplier)), new JLabel(this._tickNumberFormat.format(d)));
                d -= this._tickSpacing;
                d2 += this._tickSpacing;
            }
        } else {
            hashtable.put(new Integer((int)(this._max * this._multiplier)), new JLabel(this._tickNumberFormat.format(this._max)));
            hashtable.put(new Integer((int)(this._min * this._multiplier)), new JLabel(this._tickNumberFormat.format(this._min)));
            for (double d = this._min + this._tickSpacing; d < this._max; d += this._tickSpacing) {
                hashtable.put(new Integer((int)(d * this._multiplier)), new JLabel(this._tickNumberFormat.format(d)));
            }
        }
        this.getSlider().setLabelTable(hashtable);
    }

    private DecimalFormat createFormat(int n) {
        String string = "0";
        for (int i = 0; i < n; ++i) {
            if (i == 0) {
                string = string + ".";
            }
            string = string + "0";
        }
        return new DecimalFormat(string);
    }

    private void warnUser() {
        Toolkit.getDefaultToolkit().beep();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._listenerList.add(ChangeListener.class, changeListener);
    }

    private void fireChangeEvent(ChangeEvent changeEvent) {
        Object[] objectArray = this._listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    private class EventDispatcher
    extends KeyAdapter
    implements ActionListener,
    FocusListener,
    ChangeListener {
        private EventDispatcher() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getSource() == SliderControl.this._valueTextField) {
                if (keyEvent.getKeyCode() == 38) {
                    double d = SliderControl.this.getValue() + 1.0 / SliderControl.this._multiplier;
                    SliderControl.this.setValue(d);
                } else if (keyEvent.getKeyCode() == 40) {
                    double d = SliderControl.this.getValue() - 1.0 / SliderControl.this._multiplier;
                    SliderControl.this.setValue(d);
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == SliderControl.this._valueTextField) {
                SliderControl.this.setValue(SliderControl.this.getTextFieldValue());
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() == SliderControl.this._slider) {
                SliderControl.this._isDragging = SliderControl.this._slider.getValueIsAdjusting();
                boolean bl = SliderControl.this._notifyWhileDragging || !SliderControl.this._isDragging;
                SliderControl.this.setValue(SliderControl.this.getSliderValue(), bl);
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            if (focusEvent.getSource() == SliderControl.this._valueTextField) {
                SliderControl.this._valueTextField.selectAll();
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            if (focusEvent.getSource() == SliderControl.this._valueTextField) {
                try {
                    SliderControl.this._valueTextField.commitEdit();
                    SliderControl.this.setValue(SliderControl.this.getTextFieldValue());
                }
                catch (ParseException parseException) {
                    SliderControl.this.warnUser();
                    SliderControl.this.updateView();
                }
            }
        }
    }
}

