/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.mri.util;

import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class RoundGradientPaint
implements Paint {
    protected Point2D mPoint;
    protected Point2D mRadius;
    protected Color mPointColor;
    protected Color mBackgroundColor;

    public RoundGradientPaint(double d, double d2, Color color, Point2D point2D, Color color2) {
        if (point2D.distance(0.0, 0.0) <= 0.0) {
            throw new IllegalArgumentException("Radius must be greater than 0.");
        }
        this.mPoint = new Point2D.Double(d, d2);
        this.mPointColor = color;
        this.mRadius = point2D;
        this.mBackgroundColor = color2;
    }

    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        Point2D point2D = affineTransform.transform(this.mPoint, null);
        Point2D point2D2 = affineTransform.deltaTransform(this.mRadius, null);
        return new RoundGradientContext(point2D, this.mPointColor, point2D2, this.mBackgroundColor);
    }

    public int getTransparency() {
        int n;
        int n2 = this.mPointColor.getAlpha();
        return (n2 & (n = this.mBackgroundColor.getAlpha())) == 255 ? 1 : 3;
    }

    public class RoundGradientContext
    implements PaintContext {
        protected Point2D mPoint;
        protected Point2D mRadius;
        protected Color mC1;
        protected Color mC2;

        public RoundGradientContext(Point2D point2D, Color color, Point2D point2D2, Color color2) {
            this.mPoint = point2D;
            this.mC1 = color;
            this.mRadius = point2D2;
            this.mC2 = color2;
        }

        public void dispose() {
        }

        public ColorModel getColorModel() {
            return ColorModel.getRGBdefault();
        }

        public Raster getRaster(int n, int n2, int n3, int n4) {
            WritableRaster writableRaster = this.getColorModel().createCompatibleWritableRaster(n3, n4);
            int[] nArray = new int[n3 * n4 * 4];
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    double d;
                    double d2 = this.mPoint.distance(n + j, n2 + i);
                    double d3 = d2 / (d = this.mRadius.distance(0.0, 0.0));
                    if (d3 > 1.0) {
                        d3 = 1.0;
                    }
                    int n5 = (i * n3 + j) * 4;
                    nArray[n5 + 0] = (int)((double)this.mC1.getRed() + d3 * (double)(this.mC2.getRed() - this.mC1.getRed()));
                    nArray[n5 + 1] = (int)((double)this.mC1.getGreen() + d3 * (double)(this.mC2.getGreen() - this.mC1.getGreen()));
                    nArray[n5 + 2] = (int)((double)this.mC1.getBlue() + d3 * (double)(this.mC2.getBlue() - this.mC1.getBlue()));
                    nArray[n5 + 3] = (int)((double)this.mC1.getAlpha() + d3 * (double)(this.mC2.getAlpha() - this.mC1.getAlpha()));
                }
            }
            writableRaster.setPixels(0, 0, n3, n4, nArray);
            return writableRaster;
        }
    }
}

