/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.mri.model;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.mri.model.Dipole;
import edu.colorado.phet.mri.model.Electromagnet;
import edu.colorado.phet.mri.model.MriModel;
import java.awt.geom.Point2D;
import java.util.Random;

public class ThermalNoise
implements ModelElement {
    private Random random = new Random();
    private double minMeanInjectionTime;
    private double meanInjectionTime;
    private double timeToInjection = 0.0;
    private double elapsedTime = 0.0;
    private MriModel model;

    public ThermalNoise(double d, MriModel mriModel) {
        this.minMeanInjectionTime = d;
        this.meanInjectionTime = d;
        this.model = mriModel;
        this.setInjectionTime();
        this.setMeanInjectionTime();
        mriModel.getLowerMagnet().addChangeListener(new Electromagnet.ChangeListener(){

            public void stateChanged(Electromagnet.ChangeEvent changeEvent) {
                ThermalNoise.this.setMeanInjectionTime();
            }
        });
    }

    private void setMeanInjectionTime() {
        double d = this.model.getTotalFieldStrengthAt(new Point2D.Double(0.0, 0.0));
        this.meanInjectionTime = this.minMeanInjectionTime * (1.0 + 5.0 * d / 3.0);
        this.setInjectionTime();
    }

    private void setInjectionTime() {
        double d = 0.5;
        this.timeToInjection = this.meanInjectionTime * (1.0 + this.random.nextGaussian() * d);
    }

    public void stepInTime(double d) {
        this.elapsedTime += d;
        if (this.elapsedTime >= this.timeToInjection) {
            this.elapsedTime = 0.0;
            this.setInjectionTime();
            double d2 = this.model.determineDesiredFractionDown();
            double d3 = (double)this.model.getDownDipoles().size() / (double)this.model.getDipoles().size();
            Dipole dipole = null;
            if (d3 > d2 && this.model.getDownDipoles().size() > 0) {
                dipole = (Dipole)this.model.getDownDipoles().get(this.random.nextInt(this.model.getDownDipoles().size()));
            } else if (this.model.getUpDipoles().size() > 0) {
                dipole = (Dipole)this.model.getUpDipoles().get(this.random.nextInt(this.model.getUpDipoles().size()));
            }
            if (dipole != null) {
                dipole.flip();
            }
        }
    }
}

