/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.mri.model;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.common.phetcommon.util.SimpleObservable;
import edu.colorado.phet.mri.util.IScalar;
import java.awt.geom.Point2D;
import java.util.EventListener;

public class PlaneWaveMedium
extends SimpleObservable
implements ModelElement {
    public static Direction NORTH = new Direction(0.0, -1.0);
    public static Direction SOUTH = new Direction(0.0, 1.0);
    public static Direction EAST = new Direction(1.0, 0.0);
    public static Direction WEST = new Direction(0.0, -1.0);
    private IScalar source;
    private Point2D origin;
    private double lateralExtent;
    private Direction direction;
    private double speed;
    private double[] values;
    private double longitudinalExtent;
    private EventChannel eventChannel = new EventChannel(Listener.class);
    private Listener listenerProxy = (Listener)this.eventChannel.getListenerProxy();

    public PlaneWaveMedium(IScalar iScalar, Point2D point2D, double d, double d2, Direction direction, double d3) {
        this.source = iScalar;
        this.origin = point2D;
        this.lateralExtent = d;
        this.direction = direction;
        this.speed = d3;
        this.longitudinalExtent = d2;
        this.values = new double[(int)(d2 / d3)];
    }

    public IScalar getSource() {
        return this.source;
    }

    public Point2D getOrigin() {
        return this.origin;
    }

    public double getLateralExtent() {
        return this.lateralExtent;
    }

    public double getLongitudinalExtent() {
        return this.longitudinalExtent;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void stepInTime(double d) {
        double d2 = this.source.getValue();
        for (int i = this.values.length - 1; i > 0; --i) {
            this.values[i] = this.values[i - 1];
        }
        this.values[0] = d2;
        this.notifyObservers();
    }

    public double getAmplitudeAt(double d) {
        return this.values[(int)(d / this.speed)];
    }

    public double getSpeed() {
        return this.speed;
    }

    public void leaveSystem() {
        this.listenerProxy.leftSystem(this);
        this.eventChannel.removeAllListeners();
        this.removeAllObservers();
    }

    public static class Direction
    extends Vector2D {
        private Direction(double d, double d2) {
            super(d, d2);
        }
    }

    public static interface Listener
    extends EventListener {
        public void leftSystem(PlaneWaveMedium var1);
    }
}

