/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.mri.model;

import edu.colorado.phet.common.collision.Collidable;
import edu.colorado.phet.common.collision.CollisionUtil;
import edu.colorado.phet.common.phetcommon.util.PhysicsUtil;
import edu.colorado.phet.common.quantum.model.Photon;
import edu.colorado.phet.mri.MriConfig;
import edu.colorado.phet.mri.model.Dipole;
import edu.colorado.phet.mri.model.DipoleFlipper;
import edu.colorado.phet.mri.model.MriEmittedPhoton;
import edu.colorado.phet.mri.model.MriModel;
import edu.colorado.phet.mri.model.Spin;
import edu.colorado.phet.mri.model.TumorDipole;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class PhotonDipoleCollisionAgent {
    private static Random random = new Random();
    private Object[] bodies = new Object[2];
    private Map classifiedBodies = new HashMap();
    private MriModel model;
    private CollisionProbablilityStrategy collisionProbablilityStrategy;

    public PhotonDipoleCollisionAgent(MriModel mriModel) {
        this.model = mriModel;
        this.classifiedBodies.put(Photon.class, null);
        this.classifiedBodies.put(Dipole.class, null);
        this.collisionProbablilityStrategy = new LinearCollisionProbability(0.0, 1.0);
    }

    public boolean detectAndDoCollision(Collidable collidable, Collidable collidable2) {
        if (CollisionUtil.areConformantToClasses(collidable, collidable2, Photon.class, Dipole.class)) {
            this.bodies[0] = collidable;
            this.bodies[1] = collidable2;
            CollisionUtil.classifyBodies(this.bodies, this.classifiedBodies);
            Dipole dipole = (Dipole)this.classifiedBodies.get(Dipole.class);
            Photon photon = (Photon)this.classifiedBodies.get(Photon.class);
            if (this.collisionShouldOccur(photon, dipole)) {
                dipole.collideWithPhoton(photon);
                if (!(dipole instanceof TumorDipole)) {
                    photon.removeFromSystem();
                    this.model.removeModelElement(photon);
                }
                double d = (double)MriConfig.SPIN_DOWN_TIMEOUT * (1.0 + random.nextGaussian());
                this.model.addModelElement(new DipoleFlipper(dipole, Spin.DOWN, d, this.model, true));
            }
        }
        return false;
    }

    private boolean applyProbabilityStrategy(Dipole dipole) {
        return random.nextDouble() <= this.collisionProbablilityStrategy.getProbability(dipole);
    }

    private boolean collisionShouldOccur(Photon photon, Dipole dipole) {
        boolean bl = true;
        bl &= dipole.getSpin() == Spin.DOWN;
        bl &= !(photon instanceof MriEmittedPhoton);
        bl &= photon.getPosition().distanceSq(dipole.getPosition()) < dipole.getRadius() * dipole.getRadius();
        bl &= this.applyProbabilityStrategy(dipole);
        double d = PhysicsUtil.frequencyToEnergy(this.model.getTotalFieldStrengthAt(dipole.getPosition()) * this.model.getSampleMaterial().getMu());
        return bl &= Math.abs(d - photon.getEnergy()) < MriConfig.ENERGY_EPS;
    }

    public static interface CollisionProbablilityStrategy {
        public double getProbability(Dipole var1);
    }

    public class LinearCollisionProbability
    implements CollisionProbablilityStrategy {
        private double m;
        private double minProbability;
        private double maxProbability;

        public LinearCollisionProbability(double d, double d2) {
            this.minProbability = d;
            this.maxProbability = d2;
            double d3 = PhotonDipoleCollisionAgent.this.model.getRadiowaveSource().getPosition().getY() - MriConfig.SAMPLE_CHAMBER_LOCATION.getY();
            this.m = (d2 - d) / d3;
        }

        public double getProbability(Dipole dipole) {
            double d = PhotonDipoleCollisionAgent.this.model.getRadiowaveSource().getPosition().getY() - MriConfig.SAMPLE_CHAMBER_LOCATION.getY() - dipole.getPosition().getY();
            double d2 = this.minProbability + this.m * d;
            return d2;
        }
    }
}

