/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.mri.model;

import edu.colorado.phet.common.phetcommon.model.BaseModel;
import edu.colorado.phet.mri.model.Dipole;
import edu.colorado.phet.mri.model.MriModel;
import edu.colorado.phet.mri.model.Sample;
import edu.colorado.phet.mri.model.Tumor;
import edu.colorado.phet.mri.util.MriUtil;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.List;

public class Head
extends Sample {
    private Ellipse2D skull;
    private Ellipse2D[] ears;
    private Shape shape;

    public Head(Ellipse2D ellipse2D, Ellipse2D[] ellipse2DArray) {
        this.skull = ellipse2D;
        this.ears = ellipse2DArray;
        Area area = new Area(ellipse2D);
        area.add(new Area(ellipse2DArray[0]));
        area.add(new Area(ellipse2DArray[1]));
        this.shape = area;
    }

    public Rectangle2D getBounds() {
        return this.shape.getBounds();
    }

    public void addTumor(Tumor tumor, BaseModel baseModel) {
        List list = tumor.getDipoles();
        for (int i = 0; i < list.size(); ++i) {
            Dipole dipole = (Dipole)list.get(i);
            baseModel.addModelElement(dipole);
        }
    }

    public void removeTumor(Tumor tumor, BaseModel baseModel) {
        List list = tumor.getDipoles();
        for (int i = list.size() - 1; i >= 0; --i) {
            Dipole dipole = (Dipole)list.get(i);
            baseModel.removeModelElement(dipole);
        }
    }

    public void createDipoles(MriModel mriModel, double d) {
        Dipole dipole;
        List list = MriUtil.createDipolesForEllipse(this.skull, d);
        for (int i = 0; i < list.size(); ++i) {
            dipole = (Dipole)list.get(i);
            mriModel.addModelElement(dipole);
        }
        Dipole dipole2 = new Dipole();
        dipole2.setPosition(this.ears[1].getCenterX(), this.ears[1].getCenterY());
        mriModel.addModelElement(dipole2);
        dipole = new Dipole();
        dipole.setPosition(this.ears[0].getCenterX(), this.ears[0].getCenterY());
        mriModel.addModelElement(dipole);
    }
}

