/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.mri.model;

import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.mri.model.Electromagnet;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.Set;

public class GradientElectromagnet
extends Electromagnet {
    public static final Orientation HORIZONTAL = new Orientation();
    public static final Orientation VERTICAL = new Orientation();
    private static Set ORIENTATIONS = new HashSet();
    private Orientation orientation;
    private Gradient gradient;
    private double length;

    public GradientElectromagnet(Point2D point2D, double d, double d2, IClock iClock, Gradient gradient, Orientation orientation) {
        super(point2D, d, d2, iClock);
        if (!ORIENTATIONS.contains(orientation)) {
            throw new IllegalArgumentException("invalid orientation");
        }
        this.orientation = orientation;
        this.length = orientation == HORIZONTAL ? d : d2;
        this.gradient = gradient;
    }

    public double getFieldStrengthAtAbsolute(Point2D point2D) {
        double d;
        double d2 = d = this.orientation == HORIZONTAL ? point2D.getX() - (this.getPosition().getX() - this.length / 2.0) : point2D.getY() - (this.getPosition().getY() - this.length / 2.0);
        if (this.orientation == VERTICAL) {
            // empty if block
        }
        return this.getFieldStrength() * this.gradient.getValueAt(d, this.length);
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    static {
        ORIENTATIONS.add(HORIZONTAL);
        ORIENTATIONS.add(VERTICAL);
    }

    public static class Constant
    implements Gradient {
        public double getValueAt(double d, double d2) {
            return 1.0;
        }
    }

    public static interface Gradient {
        public double getValueAt(double var1, double var3);
    }

    public static class LinearGradient
    implements Gradient {
        private double m;
        private double b;

        public LinearGradient(double d, double d2) {
            this.m = d;
            this.b = d2;
        }

        public double getValueAt(double d, double d2) {
            return this.m * ((d - d2 / 2.0) / d2) + this.b;
        }
    }

    public static class Orientation {
    }
}

