/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.mri.model;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.model.Particle;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.util.EventChannel;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.EventListener;
import java.util.EventObject;

public class Electromagnet
extends Particle {
    private double fieldStrength;
    private Rectangle2D bounds;
    private EventChannel changeEventChannel = new EventChannel(ChangeListener.class);
    private ChangeListener changeListenerProxy = (ChangeListener)this.changeEventChannel.getListenerProxy();

    public Electromagnet(Point2D point2D, double d, double d2, IClock iClock) {
        super(point2D, new Vector2D(), new Vector2D());
        this.bounds = new Rectangle2D.Double(point2D.getX() - d / 2.0, point2D.getY() - d2 / 2.0, d, d2);
    }

    public void setFieldStrength(double d) {
        this.fieldStrength = d;
        this.changeListenerProxy.stateChanged(new ChangeEvent(this));
    }

    public double getFieldStrength() {
        return this.fieldStrength;
    }

    public Rectangle2D getBounds() {
        return this.bounds;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeEventChannel.addListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeEventChannel.removeListener(changeListener);
    }

    public class ChangeEvent
    extends EventObject {
        public ChangeEvent(Electromagnet electromagnet2) {
            super(electromagnet2);
        }
    }

    public static interface ChangeListener
    extends EventListener {
        public void stateChanged(ChangeEvent var1);
    }
}

