/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.mri.model;

import edu.colorado.phet.mri.MriConfig;
import edu.colorado.phet.mri.model.Dipole;
import edu.colorado.phet.mri.model.Electromagnet;
import edu.colorado.phet.mri.model.MriModel;
import java.util.List;
import java.util.Random;

public class DipoleOrientationAgent
implements Electromagnet.ChangeListener {
    private MriModel model;
    private SpinDeterminationPolicy spinDeterminationPolicy = MriConfig.InitialConditions.SPIN_DETERMINATION_POLICY;

    public DipoleOrientationAgent(MriModel mriModel) {
        this.model = mriModel;
    }

    private void updateSpins() {
        this.spinDeterminationPolicy.setSpins(this.model);
    }

    public void stateChanged(Electromagnet.ChangeEvent changeEvent) {
        this.updateSpins();
    }

    public static class DeterministicPolicy
    implements SpinDeterminationPolicy {
        Random random = new Random();
        long meanFlipTimout = 100L;

        public void setSpins(MriModel mriModel) {
            List list = mriModel.getDipoles();
            if (list.size() > 0) {
                Dipole dipole;
                double d = 1.0 - mriModel.determineDesiredFractionDown();
                double d2 = (double)list.size() * 0.1;
                int n = (int)Math.round(Math.max(d * (double)list.size(), d2));
                while (mriModel.getUpDipoles().size() > n) {
                    dipole = (Dipole)mriModel.getUpDipoles().get(this.random.nextInt(mriModel.getUpDipoles().size()));
                    dipole.flip();
                }
                while (mriModel.getUpDipoles().size() < n) {
                    dipole = (Dipole)mriModel.getDownDipoles().get(this.random.nextInt(mriModel.getDownDipoles().size()));
                    dipole.flip();
                }
            }
        }
    }

    public static interface SpinDeterminationPolicy {
        public void setSpins(MriModel var1);
    }
}

