/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.mri.model;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.util.SimpleObservable;
import edu.colorado.phet.common.quantum.model.Photon;
import edu.colorado.phet.mri.model.MriModel;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class Detector
extends SimpleObservable
implements ModelElement {
    private Rectangle2D bounds;
    private MriModel model;
    private double detectingPeriod = 200.0;
    private double elapsedTime;
    private int numDetected;
    private List detectedPhotons = new ArrayList();

    public Detector(Rectangle2D rectangle2D, MriModel mriModel) {
        this.bounds = rectangle2D;
        this.model = mriModel;
    }

    public Rectangle2D getBounds() {
        return this.bounds;
    }

    public void stepInTime(double d) {
        ArrayList arrayList = this.model.getPhotons();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            Photon photon = (Photon)arrayList.get(i);
            if (this.detectedPhotons.contains(photon) || !this.bounds.contains(photon.getPosition())) continue;
            ++this.numDetected;
            this.detectedPhotons.add(photon);
        }
        this.elapsedTime += d;
        if (this.elapsedTime >= this.detectingPeriod) {
            this.elapsedTime = 0.0;
            this.detectedPhotons.clear();
            this.numDetected = 0;
        }
        this.notifyObservers();
    }

    public int getNumDetected() {
        return this.numDetected;
    }
}

