/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.mri.controller;

import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.model.clock.SwingClock;
import edu.colorado.phet.mri.MriConfig;
import edu.colorado.phet.mri.MriResources;
import edu.colorado.phet.mri.controller.AbstractMriModule;
import edu.colorado.phet.mri.controller.HeadModuleControlPanel;
import edu.colorado.phet.mri.model.Detector;
import edu.colorado.phet.mri.model.Electromagnet;
import edu.colorado.phet.mri.model.GradientElectromagnet;
import edu.colorado.phet.mri.model.Head;
import edu.colorado.phet.mri.model.LinearGradientMagnet;
import edu.colorado.phet.mri.model.MriModel;
import edu.colorado.phet.mri.view.BFieldIndicatorB;
import edu.colorado.phet.mri.view.DipoleGraphic;
import edu.colorado.phet.mri.view.HeadGraphic;
import edu.umd.cs.piccolo.PNode;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class HeadModule
extends AbstractMriModule {
    private static String name = MriResources.getString("Module.MriTitle");
    static double earOffsetX = 70.0 * MriConfig.SCALE_FOR_ORG;
    static double headOffsetY = 35.0 * MriConfig.SCALE_FOR_ORG;
    static Head head = new Head(new Ellipse2D.Double(MriConfig.SAMPLE_CHAMBER_LOCATION.getX() + earOffsetX, MriConfig.SAMPLE_CHAMBER_LOCATION.getY(), MriConfig.SAMPLE_CHAMBER_WIDTH - earOffsetX * 2.0, MriConfig.SAMPLE_CHAMBER_HEIGHT + 0.0 * MriConfig.SCALE_FOR_ORG), new Ellipse2D[]{new Ellipse2D.Double(MriConfig.SAMPLE_CHAMBER_LOCATION.getX(), MriConfig.SAMPLE_CHAMBER_LOCATION.getY() + 120.0, earOffsetX, 50.0), new Ellipse2D.Double(MriConfig.SAMPLE_CHAMBER_BOUNDS.getMaxX() - earOffsetX, MriConfig.SAMPLE_CHAMBER_LOCATION.getY() + 120.0, earOffsetX, 50.0)});
    private Detector detector;
    private GradientElectromagnet horizontalGradientMagnet;
    private GradientElectromagnet verticalGradientMagnet;
    private PNode headGraphic;

    public HeadModule() {
        this(name);
    }

    public HeadModule(String string) {
        super(string, (IClock)new SwingClock(delay, dt), head);
        this.setLogoPanelVisible(false);
    }

    public boolean auxiliarySquiggleVisible() {
        return false;
    }

    protected void init() {
        super.init();
        MriModel mriModel = (MriModel)this.getModel();
        Electromagnet electromagnet = mriModel.getLowerMagnet();
        GradientElectromagnet.LinearGradient linearGradient = new GradientElectromagnet.LinearGradient(1.0, 0.0);
        Point2D.Double double_ = new Point2D.Double(electromagnet.getPosition().getX(), electromagnet.getPosition().getY() - electromagnet.getBounds().getHeight());
        this.horizontalGradientMagnet = new LinearGradientMagnet((Point2D)double_, electromagnet.getBounds().getWidth(), electromagnet.getBounds().getHeight(), this.getClock(), linearGradient, GradientElectromagnet.HORIZONTAL);
        mriModel.addModelElement(this.horizontalGradientMagnet);
        GradientElectromagnet.LinearGradient linearGradient2 = new GradientElectromagnet.LinearGradient(1.0, 0.0);
        Point2D.Double double_2 = new Point2D.Double(MriConfig.SAMPLE_CHAMBER_LOCATION.getX() - 40.0, MriConfig.SAMPLE_CHAMBER_LOCATION.getY() + MriConfig.SAMPLE_CHAMBER_HEIGHT / 2.0);
        this.verticalGradientMagnet = new LinearGradientMagnet((Point2D)double_2, electromagnet.getBounds().getHeight(), MriConfig.SAMPLE_CHAMBER_HEIGHT, this.getClock(), linearGradient2, GradientElectromagnet.VERTICAL);
        mriModel.addModelElement(this.verticalGradientMagnet);
        HeadModuleControlPanel headModuleControlPanel = new HeadModuleControlPanel(this, this.horizontalGradientMagnet, this.verticalGradientMagnet);
        this.setControlPanel(headModuleControlPanel);
        head.createDipoles((MriModel)this.getModel(), 40.0);
        this.headGraphic = new HeadGraphic(head);
        this.headGraphic.setOffset(MriConfig.SAMPLE_CHAMBER_LOCATION.getX(), MriConfig.SAMPLE_CHAMBER_LOCATION.getY());
        this.getGraphicsManager().addGraphic(this.headGraphic, this.getGraphicsManager().getHeadLayer());
        Rectangle2D.Double double_3 = new Rectangle2D.Double(MriConfig.SAMPLE_CHAMBER_LOCATION.getX() + MriConfig.SAMPLE_CHAMBER_WIDTH + 80.0, MriConfig.SAMPLE_CHAMBER_LOCATION.getY() - 40.0, 25.0, MriConfig.SAMPLE_CHAMBER_HEIGHT + 100.0);
        this.detector = new Detector(double_3, mriModel);
        mriModel.addModelElement(this.detector);
        this.setEmRep(WAVE_VIEW);
    }

    public Head getHead() {
        return head;
    }

    public PNode getHeadGraphic() {
        return this.headGraphic;
    }

    public void setDipolesVisible(boolean bl) {
        this.getGraphicsManager().setAllOfTypeVisible(DipoleGraphic.class, bl);
    }

    public void setFieldArrowsVisible(boolean bl) {
        this.getGraphicsManager().setAllOfTypeVisible(BFieldIndicatorB.class, bl);
    }
}

