/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.mri.controller;

import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.piccolophet.DeferredInitializationModule;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.mri.MriConfig;
import edu.colorado.phet.mri.model.MriModel;
import edu.colorado.phet.mri.model.Sample;
import edu.colorado.phet.mri.model.SampleMaterial;
import edu.colorado.phet.mri.view.BFieldIndicatorB;
import edu.colorado.phet.mri.view.ModelElementGraphicManager;
import edu.colorado.phet.mri.view.PhotonGraphic;
import edu.colorado.phet.mri.view.PlaneWaveGraphic;
import edu.umd.cs.piccolo.PNode;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class AbstractMriModule
extends DeferredInitializationModule {
    protected static int delay = 1000 / MriConfig.FPS;
    protected static double dt = MriConfig.DT;
    protected ModelElementGraphicManager graphicsManager;
    public static EmRep PHOTON_VIEW = new EmRep();
    public static EmRep WAVE_VIEW = new EmRep();
    private PNode worldNode;
    private Sample sample;
    private MriModel mriModel;

    public AbstractMriModule(String string, IClock iClock, Sample sample) {
        super(string, iClock);
        this.sample = sample;
    }

    public abstract boolean auxiliarySquiggleVisible();

    public MriModel getMriModel() {
        return this.mriModel;
    }

    protected void init() {
        this.mriModel = new MriModel(this.getClock(), new Rectangle2D.Double(0.0, 0.0, 1000.0, 768.0), this.sample);
        this.setModel(this.mriModel);
        this.mriModel.setSampleMaterial(SampleMaterial.HYDROGEN);
        Dimension dimension = new Dimension((int)(this.mriModel.getBounds().getWidth() * 1.0), (int)(this.mriModel.getBounds().getHeight() * 1.0));
        PhetPCanvas phetPCanvas = new PhetPCanvas(dimension);
        this.setSimulationPanel(phetPCanvas);
        this.worldNode = new PNode();
        phetPCanvas.addScreenChild(this.worldNode);
        this.graphicsManager = new ModelElementGraphicManager(this, phetPCanvas, this.worldNode);
        this.graphicsManager.scanModel(this.mriModel);
        this.mriModel.addListener(this.graphicsManager);
        this.createFieldStrengthArrows(this.mriModel);
    }

    private void createFieldStrengthArrows(MriModel mriModel) {
        int n = 7;
        int n2 = 7;
        Point2D.Double double_ = new Point2D.Double(mriModel.getUpperMagnet().getBounds().getMinX() - 50.0, mriModel.getUpperMagnet().getBounds().getMaxY() - 25.0);
        Point2D.Double double_2 = new Point2D.Double(mriModel.getLowerMagnet().getBounds().getMaxX() + 50.0, mriModel.getLowerMagnet().getBounds().getMinY() + 25.0);
        double d = (((Point2D)double_2).getX() - ((Point2D)double_).getX()) / (double)n;
        double d2 = (((Point2D)double_2).getY() - ((Point2D)double_).getY()) / (double)n2;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                Point2D.Double double_3 = new Point2D.Double(((Point2D)double_).getX() + d * ((double)i + 0.5), ((Point2D)double_).getY() + d2 * ((double)j + 0.5));
                BFieldIndicatorB bFieldIndicatorB = new BFieldIndicatorB((MriModel)this.getModel(), double_3, 70.0, null);
                bFieldIndicatorB.setOffset(double_3);
                this.getGraphicsManager().addGraphic(bFieldIndicatorB, this.getGraphicsManager().getControlLayer());
            }
        }
    }

    public void setEmRep(EmRep emRep) {
        if (emRep == WAVE_VIEW) {
            this.graphicsManager.setAllOfTypeVisible(PhotonGraphic.class, false);
            this.graphicsManager.setAllOfTypeVisible(PlaneWaveGraphic.class, true);
        } else if (emRep == PHOTON_VIEW) {
            this.graphicsManager.setAllOfTypeVisible(PhotonGraphic.class, true);
            this.graphicsManager.setAllOfTypeVisible(PlaneWaveGraphic.class, false);
        }
    }

    protected ModelElementGraphicManager getGraphicsManager() {
        return this.graphicsManager;
    }

    private static class EmRep {
        private EmRep() {
        }
    }
}

