/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.mri;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.util.PhysicsUtil;
import edu.colorado.phet.mri.model.DipoleOrientationAgent;
import edu.colorado.phet.mri.model.SampleMaterial;
import edu.colorado.phet.mri.view.MonitorPanel;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class MriConfig {
    public static double DT = 12.0;
    public static int FPS = 25;
    public static final double ENERGY_EPS = PhysicsUtil.frequencyToEnergy(SampleMaterial.HYDROGEN.getMu() * 3.0) / 150.0 * 4.0;
    public static long SPIN_DOWN_TIMEOUT = 250L;
    public static double MEAN_THERMAL_NOISE_INJECTION_TIME = 500.0;
    public static final Vector2D EMITTED_PHOTON_DIRECTION = new Vector2D(1.0, 0.0);
    public static Point2D SAMPLE_CHAMBER_LOCATION = new Point2D.Double(170.0, 55.0);
    public static double SCALE_FOR_ORG = 0.6666666666666666;
    public static double SAMPLE_CHAMBER_WIDTH = 400.0;
    public static double SAMPLE_CHAMBER_HEIGHT = 350.0;
    public static Rectangle2D SAMPLE_CHAMBER_BOUNDS = new Rectangle2D.Double(SAMPLE_CHAMBER_LOCATION.getX(), SAMPLE_CHAMBER_LOCATION.getY(), SAMPLE_CHAMBER_WIDTH, SAMPLE_CHAMBER_HEIGHT);

    public static class InitialConditions {
        public static double FADING_MAGNET_FIELD = 0.0;
        public static final double DIPOLE_PRECESSION = Math.toRadians(0.0);
        public static final DipoleOrientationAgent.SpinDeterminationPolicy SPIN_DETERMINATION_POLICY = new DipoleOrientationAgent.DeterministicPolicy();
        public static final MonitorPanel.DipoleRepresentationPolicy MONITOR_PANEL_REP_POLICY_DIPOLE = new MonitorPanel.DiscretePolicy();
    }

    public static class ModelToView {
        public static double FREQUENCY = 1.25E-10;
    }
}

