/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view;

import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;

public class PhetLookAndFeel {
    private static final String[] types = new String[]{"Button", "CheckBox", "CheckBoxMenuItem", "ComboBox", "Dialog", "Label", "Menu", "MenuBar", "MenuItem", "OptionPane", "Panel", "RadioButton", "RadioButtonMenuItem", "Slider", "Spinner", "TabbedPane", "TextArea", "TextField", "TextPane", "FormattedTextField", "ScrollBar", "Viewport"};
    private ArrayList ignoreBackgroundList = new ArrayList<String>(Arrays.asList("TextArea", "TextField", "TextPane", "FormattedTextField", "MenuBar", "Menu", "MenuItem", "CheckBoxMenuItem"));
    private Font font = new PhetFont();
    private Font titledBorderFont = new PhetFont();
    private Font tabFont = new PhetFont();
    private Color foregroundColor;
    private Color backgroundColor;
    private Color buttonBackgroundColor;
    private Color textFieldBackgroundColor = Color.white;
    private Insets insets;
    private Color titledBorderTitleColor;

    public void setFont(Font font) {
        if (font == null) {
            font = new PhetFont();
        }
        this.font = font;
    }

    public void setTitledBorderFont(Font font) {
        if (this.titledBorderFont == null) {
            this.titledBorderFont = new PhetFont();
        }
        this.titledBorderFont = font;
    }

    public void updateDefaults() {
        UIDefaults uIDefaults = UIManager.getDefaults();
        this.putDefaults(uIDefaults);
    }

    public void putDefaults(UIDefaults uIDefaults) {
        Object[] objectArray = this.constructDefaults();
        uIDefaults.putDefaults(objectArray);
    }

    private Object[] constructDefaults() {
        ColorUIResource colorUIResource = null;
        ColorUIResource colorUIResource2 = null;
        ColorUIResource colorUIResource3 = null;
        InsetsUIResource insetsUIResource = null;
        ColorUIResource colorUIResource4 = null;
        if (this.backgroundColor != null) {
            colorUIResource = new ColorUIResource(this.backgroundColor);
        }
        if (this.foregroundColor != null) {
            colorUIResource2 = new ColorUIResource(this.foregroundColor);
        }
        if (this.textFieldBackgroundColor != null) {
            colorUIResource3 = new ColorUIResource(this.textFieldBackgroundColor);
        }
        if (this.insets != null) {
            insetsUIResource = new InsetsUIResource(this.insets.top, this.insets.left, this.insets.bottom, this.insets.right);
        }
        if (this.titledBorderTitleColor != null) {
            colorUIResource4 = new ColorUIResource(this.titledBorderTitleColor);
        }
        PropertyList propertyList = new PropertyList();
        for (int i = 0; i < types.length; ++i) {
            String string = types[i];
            propertyList.add(string, "font", new FontUIResource(this.font));
            if (colorUIResource2 != null) {
                propertyList.add(string, "foreground", colorUIResource2);
            }
            if (colorUIResource != null && !this.ignoreBackgroundList.contains(string)) {
                propertyList.add(string, "background", colorUIResource);
            }
            if (insetsUIResource != null) {
                propertyList.add(string, "margin", insetsUIResource);
            }
            if (colorUIResource4 == null) continue;
            propertyList.add("TitledBorder", "titleColor", colorUIResource4);
        }
        propertyList.add("TitledBorder", "font", new FontUIResource(this.titledBorderFont));
        propertyList.add("OptionPane", "messageFont", new FontUIResource(this.font));
        propertyList.add("OptionPane", "buttonFont", new FontUIResource(this.font));
        if (this.buttonBackgroundColor != null) {
            propertyList.add("Button", "background", new ColorUIResource(this.buttonBackgroundColor));
        }
        if (colorUIResource3 != null) {
            propertyList.add("TextField", "background", colorUIResource3);
        }
        if (this.tabFont != null) {
            propertyList.add("TabbedPane", "font", new FontUIResource(this.tabFont));
        }
        propertyList.addAll(this.getTextValues());
        return propertyList.toArray();
    }

    private PropertyList getTextValues() {
        PropertyList propertyList = new PropertyList();
        propertyList.addAll(this.getOptionPaneStrings());
        propertyList.addAll(this.getFileDialogStrings());
        propertyList.addAll(this.getColorChooserStrings());
        return propertyList;
    }

    private PropertyList getFileDialogStrings() {
        PropertyList propertyList = new PropertyList();
        propertyList.add("FileChooser", "cancelButtonText", this.getCommonString("Common.choice.cancel"));
        propertyList.add("FileChooser", "openDialogTitleText", this.getCommonString("FileChooser.openDialogTitleText"));
        propertyList.add("FileChooser", "saveDialogTitleText", this.getCommonString("FileChooser.saveDialogTitleText"));
        propertyList.add("FileChooser", "lookInLabelText", this.getCommonString("FileChooser.lookInLabelText"));
        propertyList.add("FileChooser", "saveInLabelText", this.getCommonString("FileChooser.saveInLabelText"));
        propertyList.add("FileChooser", "fileNameLabelText", this.getCommonString("FileChooser.fileNameLabelText"));
        propertyList.add("FileChooser", "filesOfTypeLabelText", this.getCommonString("FileChooser.filesOfTypeLabelText"));
        propertyList.add("FileChooser", "saveButtonText", this.getCommonString("FileChooser.saveButtonText"));
        propertyList.add("FileChooser", "openButtonText", this.getCommonString("FileChooser.openButtonText"));
        propertyList.add("FileChooser", "newFolderErrorText", this.getCommonString("FileChooser.newFolderErrorText"));
        propertyList.add("FileChooser", "newFolderErrorSeparator", this.getCommonString("FileChooser.newFolderErrorSeparator"));
        return propertyList;
    }

    private PropertyList getOptionPaneStrings() {
        PropertyList propertyList = new PropertyList();
        propertyList.add("OptionPane", "cancelButtonText", this.getCommonString("Common.choice.cancel"));
        propertyList.add("OptionPane", "noButtonText", this.getCommonString("Common.choice.no"));
        propertyList.add("OptionPane", "yesButtonText", this.getCommonString("Common.choice.yes"));
        propertyList.add("OptionPane", "okButtonText", this.getCommonString("Common.choice.ok"));
        return propertyList;
    }

    private PropertyList getColorChooserStrings() {
        PropertyList propertyList = new PropertyList();
        propertyList.add("ColorChooser", "cancelText", this.getCommonString("Common.choice.cancel"));
        propertyList.add("ColorChooser", "okText", this.getCommonString("Common.choice.ok"));
        propertyList.add("ColorChooser", "resetText", this.getCommonString("ColorChooser.resetText"));
        propertyList.add("ColorChooser", "swatchesNameText", this.getCommonString("ColorChooser.swatchesNameText"));
        propertyList.add("ColorChooser", "previewText", this.getCommonString("ColorChooser.previewText"));
        propertyList.add("ColorChooser", "swatchesRecentText", this.getCommonString("ColorChooser.swatchesRecentText"));
        propertyList.add("ColorChooser", "hsbNameText", this.getCommonString("ColorChooser.hsbNameText"));
        propertyList.add("ColorChooser", "hsbHueText", this.getCommonString("ColorChooser.hsbHueText"));
        propertyList.add("ColorChooser", "hsbSaturationText", this.getCommonString("ColorChooser.hsbSaturationText"));
        propertyList.add("ColorChooser", "hsbBrightnessText", this.getCommonString("ColorChooser.hsbBrightnessText"));
        propertyList.add("ColorChooser", "hsbRedText", this.getCommonString("ColorChooser.hsbRedText"));
        propertyList.add("ColorChooser", "hsbGreenText", this.getCommonString("ColorChooser.hsbGreenText"));
        propertyList.add("ColorChooser", "hsbBlueText", this.getCommonString("ColorChooser.hsbBlueText"));
        propertyList.add("ColorChooser", "rgbNameText", this.getCommonString("ColorChooser.rgbNameText"));
        propertyList.add("ColorChooser", "rgbRedText", this.getCommonString("ColorChooser.rgbRedText"));
        propertyList.add("ColorChooser", "rgbGreenText", this.getCommonString("ColorChooser.rgbGreenText"));
        propertyList.add("ColorChooser", "rgbBlueText", this.getCommonString("ColorChooser.rgbBlueText"));
        propertyList.add("ColorChooser", "sampleText", this.getCommonString("ColorChooser.sampleText"));
        return propertyList;
    }

    private Object getCommonString(String string) {
        return PhetCommonResources.getInstance().getLocalizedString(string);
    }

    public void initLookAndFeel() {
        try {
            UIManager.setLookAndFeel(this.getLookAndFeelClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            unsupportedLookAndFeelException.printStackTrace();
        }
        this.updateDefaults();
        ToolTipManager.sharedInstance().setInitialDelay(375);
        this.refreshApp();
    }

    private void refreshApp() {
        Frame[] frameArray = Frame.getFrames();
        for (int i = 0; i < frameArray.length; ++i) {
            SwingUtilities.updateComponentTreeUI(frameArray[i]);
            Window[] windowArray = frameArray[i].getOwnedWindows();
            for (int j = 0; j < windowArray.length; ++j) {
                SwingUtilities.updateComponentTreeUI(windowArray[j]);
            }
        }
    }

    protected String getLookAndFeelClassName() {
        return UIManager.getSystemLookAndFeelClassName();
    }

    private static class PropertyList {
        private ArrayList list = new ArrayList();

        private PropertyList() {
        }

        public void add(String string, String string2, Object object) {
            this.list.add(string + "." + string2);
            this.list.add(object);
        }

        public Object[] toArray() {
            return this.list.toArray();
        }

        public void addAll(PropertyList propertyList) {
            this.list.addAll(propertyList.list);
        }
    }
}

