/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.math;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;

public class Vector2D
extends ImmutableVector2D {
    public Vector2D() {
    }

    public Vector2D(ImmutableVector2D immutableVector2D) {
        this(immutableVector2D.getX(), immutableVector2D.getY());
    }

    public Vector2D(double d, double d2) {
        super(d, d2);
    }

    public Vector2D normalize() {
        double d = this.getMagnitude();
        if (d == 0.0) {
            throw new UnsupportedOperationException("Cannot normalize a zero-magnitude vector.");
        }
        return this.scale(1.0 / d);
    }

    public Vector2D scale(double d) {
        this.setX(this.getX() * d);
        this.setY(this.getY() * d);
        return this;
    }

    public void setX(double d) {
        super.setX(d);
    }

    public void setY(double d) {
        super.setY(d);
    }

    public void setComponents(double d, double d2) {
        super.setComponents(d, d2);
    }

    public Vector2D rotate(double d) {
        double d2 = this.getMagnitude();
        double d3 = this.getAngle();
        double d4 = d3 + d;
        double d5 = d2 * Math.cos(d4);
        double d6 = d2 * Math.sin(d4);
        this.setComponents(d5, d6);
        return this;
    }
}

