/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.collision;

import edu.colorado.phet.common.collision.Collidable;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.model.Particle;
import java.awt.geom.Point2D;

public class CollidableAdapter
implements Collidable {
    private Vector2D velocityPrev;
    private Point2D positionPrev;
    private Particle particle;
    private boolean init;

    public CollidableAdapter(Particle particle) {
        this.particle = particle;
        this.velocityPrev = new Vector2D(particle.getVelocity());
        this.positionPrev = new Point2D.Double(particle.getPosition().getX(), particle.getPosition().getY());
    }

    private void init() {
        this.stepInTime(0.0);
        this.init = true;
    }

    public void stepInTime(double d) {
        this.positionPrev.setLocation(this.particle.getPosition());
        this.velocityPrev.setComponents(this.particle.getVelocity().getX(), this.particle.getVelocity().getY());
    }

    public void updatePosition() {
        this.positionPrev.setLocation(this.particle.getPosition());
    }

    public void updateVelocity() {
        this.velocityPrev.setComponents(this.particle.getVelocity().getX(), this.particle.getVelocity().getY());
    }

    public Vector2D getVelocityPrev() {
        if (!this.init) {
            this.init();
        }
        return this.velocityPrev;
    }
}

