/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.movingman.view;

import edu.colorado.phet.common.motion.charts.ChartZoomControlNode;
import edu.colorado.phet.common.motion.charts.ControlChart;
import edu.colorado.phet.common.motion.charts.GoButton;
import edu.colorado.phet.common.motion.charts.MinimizableControlChart;
import edu.colorado.phet.common.motion.charts.MotionSliderNode;
import edu.colorado.phet.common.motion.charts.MultiControlChart;
import edu.colorado.phet.common.motion.charts.TemporalChart;
import edu.colorado.phet.common.motion.charts.TemporalChartSliderNode;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.movingman.MovingManColorScheme;
import edu.colorado.phet.movingman.MovingManSimSharing;
import edu.colorado.phet.movingman.MovingManStrings;
import edu.colorado.phet.movingman.model.MovingMan;
import edu.colorado.phet.movingman.model.MovingManModel;
import edu.colorado.phet.movingman.model.MovingManState;
import edu.colorado.phet.movingman.view.MovingManChartControl;
import edu.colorado.phet.movingman.view.MovingManSimulationPanel;
import edu.colorado.phet.movingman.view.ShowVectorCheckBox;
import edu.colorado.phet.movingman.view.TextBoxListener;
import edu.colorado.phet.recordandplayback.model.RecordAndPlaybackModel;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Rectangle2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MovingManSimulationPanelWithCharts
extends MovingManSimulationPanel {
    private final MinimizableControlChart positionMovingManChart;
    private final MinimizableControlChart velocityMovingManChart;
    private final MinimizableControlChart accelerationMovingManChart;

    public MovingManSimulationPanelWithCharts(final MovingManModel movingManModel, RecordAndPlaybackModel<MovingManState> recordAndPlaybackModel, BooleanProperty booleanProperty) {
        super(movingManModel, recordAndPlaybackModel, 100, booleanProperty);
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, -5.0, 2.0, 10.0);
        Rectangle2D.Double double_2 = new Rectangle2D.Double(0.0, -10.0, 20.0, 20.0);
        int n = 10;
        Object object = new TemporalChart(new Rectangle2D.Double(0.0, -n, 20.0, n * 2), double_, double_2, movingManModel.getChartCursor());
        ((TemporalChart)object).addDataSeries(movingManModel.getPositionGraphSeries(), MovingManColorScheme.POSITION_COLOR);
        PNode pNode = new TemporalChartSliderNode((TemporalChart)object, MovingManColorScheme.POSITION_COLOR);
        movingManModel.addListener(new MovingManModel.Listener((MotionSliderNode)pNode, movingManModel){
            final /* synthetic */ MotionSliderNode val$sliderNode;
            final /* synthetic */ MovingManModel val$model;
            {
                this.val$sliderNode = motionSliderNode;
                this.val$model = movingManModel;
            }

            public void mousePositionChanged() {
                this.val$sliderNode.setValue(this.val$model.getMousePosition());
            }
        });
        ((MotionSliderNode)pNode).addListener(new MotionSliderNode.Adapter(){

            public void sliderDragged(Double d) {
                movingManModel.setMousePosition(d);
            }

            public void sliderThumbGrabbed() {
                movingManModel.getMovingMan().setPositionDriven();
            }
        });
        Object object2 = new SimpleObserver((MotionSliderNode)pNode, movingManModel){
            final /* synthetic */ MotionSliderNode val$sliderNode;
            final /* synthetic */ MovingManModel val$model;
            {
                this.val$sliderNode = motionSliderNode;
                this.val$model = movingManModel;
            }

            public void update() {
                this.val$sliderNode.setHighlighted(this.val$model.getMovingMan().isPositionDriven());
            }
        };
        movingManModel.getMovingMan().addListener(new MovingMan.Listener((SimpleObserver)object2){
            final /* synthetic */ SimpleObserver val$updatePositionModeSelected;
            {
                this.val$updatePositionModeSelected = simpleObserver;
            }

            public void changed() {
                this.val$updatePositionModeSelected.update();
            }
        });
        object2.update();
        Object object3 = new MovingManChartControl(MovingManStrings.POSITION, MovingManColorScheme.POSITION_COLOR, new TextBoxListener.Position(movingManModel), "m");
        Object object4 = new GoButton(recordAndPlaybackModel, movingManModel.getPositionMode());
        ((PNode)object3).addChild((PNode)object4);
        ((PNode)object4).setOffset(((PNode)object3).getFullBounds().getMaxX() - ((PNode)object4).getFullBounds().getWidth(), ((PNode)object3).getFullBounds().getMaxY());
        this.positionMovingManChart = new MinimizableControlChart(MovingManSimSharing.UserComponents.minimizePositionChartButton, MovingManSimSharing.UserComponents.maximizePositionChartButton, MovingManStrings.POSITION, new ControlChart((PNode)object3, pNode, (TemporalChart)object, new ChartZoomControlNode((TemporalChart)object)));
        double d = 12.0;
        pNode = new TemporalChart(new Rectangle2D.Double(0.0, -d, 20.0, d * 2.0), double_, double_2, movingManModel.getChartCursor());
        ((TemporalChart)pNode).addDataSeries(movingManModel.getVelocityGraphSeries(), MovingManColorScheme.VELOCITY_COLOR);
        object2 = new MovingManChartControl(MovingManStrings.VELOCITY, MovingManColorScheme.VELOCITY_COLOR, new TextBoxListener.Velocity(movingManModel), MovingManStrings.UNITS_VELOCITY_ABBREVIATION);
        object3 = new PSwing(new ShowVectorCheckBox(MovingManStrings.SHOW_VECTOR, movingManModel.getVelocityVectorVisible()));
        ((PNode)object3).setOffset(0.0, ((PNode)object2).getFullBounds().getHeight());
        ((PNode)object2).addChild((PNode)object3);
        object4 = new GoButton(recordAndPlaybackModel, movingManModel.getVelocityMode());
        ((PNode)object4).setOffset(((PNode)object2).getFullBounds().getMaxX() - ((PNode)object4).getFullBounds().getWidth(), ((PNode)object2).getFullBounds().getMaxY());
        ((PNode)object2).addChild((PNode)object4);
        object3 = new TemporalChartSliderNode((TemporalChart)pNode, MovingManColorScheme.VELOCITY_COLOR);
        movingManModel.getMovingMan().addListener(new MovingMan.Listener((MotionSliderNode)object3, movingManModel){
            final /* synthetic */ MotionSliderNode val$chartSliderNode;
            final /* synthetic */ MovingManModel val$model;
            {
                this.val$chartSliderNode = motionSliderNode;
                this.val$model = movingManModel;
            }

            public void changed() {
                this.val$chartSliderNode.setValue(this.val$model.getMovingMan().getVelocity());
            }
        });
        ((MotionSliderNode)object3).addListener(new MotionSliderNode.Adapter(){

            public void sliderDragged(Double d) {
                movingManModel.getMovingMan().setVelocity(d);
            }

            public void sliderThumbGrabbed() {
                movingManModel.getMovingMan().setVelocityDriven();
            }
        });
        object4 = new SimpleObserver((MotionSliderNode)object3, movingManModel){
            final /* synthetic */ MotionSliderNode val$chartSliderNode;
            final /* synthetic */ MovingManModel val$model;
            {
                this.val$chartSliderNode = motionSliderNode;
                this.val$model = movingManModel;
            }

            public void update() {
                this.val$chartSliderNode.setHighlighted(this.val$model.getMovingMan().isVelocityDriven());
            }
        };
        movingManModel.getMovingMan().addListener(new MovingMan.Listener((SimpleObserver)object4){
            final /* synthetic */ SimpleObserver val$updateVelocityModeSelected;
            {
                this.val$updateVelocityModeSelected = simpleObserver;
            }

            public void changed() {
                this.val$updateVelocityModeSelected.update();
            }
        });
        object4.update();
        this.velocityMovingManChart = new MinimizableControlChart(MovingManSimSharing.UserComponents.minimizeVelocityChartButton, MovingManSimSharing.UserComponents.maximizeVelocityChartButton, MovingManStrings.VELOCITY, new ControlChart((PNode)object2, (PNode)object3, (TemporalChart)pNode, new ChartZoomControlNode((TemporalChart)pNode)));
        d = 60.0;
        pNode = new TemporalChart(new Rectangle2D.Double(0.0, -d, 20.0, d * 2.0), double_, double_2, movingManModel.getChartCursor());
        ((TemporalChart)pNode).addDataSeries(movingManModel.getAccelerationGraphSeries(), MovingManColorScheme.ACCELERATION_COLOR);
        object2 = new TemporalChartSliderNode((TemporalChart)pNode, MovingManColorScheme.ACCELERATION_COLOR);
        movingManModel.getMovingMan().addListener(new MovingMan.Listener((MotionSliderNode)object2, movingManModel){
            final /* synthetic */ MotionSliderNode val$chartSliderNode;
            final /* synthetic */ MovingManModel val$model;
            {
                this.val$chartSliderNode = motionSliderNode;
                this.val$model = movingManModel;
            }

            public void changed() {
                this.val$chartSliderNode.setValue(this.val$model.getMovingMan().getAcceleration());
            }
        });
        ((MotionSliderNode)object2).addListener(new MotionSliderNode.Adapter(){

            public void sliderDragged(Double d) {
                movingManModel.getMovingMan().setAcceleration(d);
            }

            public void sliderThumbGrabbed() {
                movingManModel.getMovingMan().setAccelerationDriven();
            }
        });
        object3 = new SimpleObserver((MotionSliderNode)object2, movingManModel){
            final /* synthetic */ MotionSliderNode val$chartSliderNode;
            final /* synthetic */ MovingManModel val$model;
            {
                this.val$chartSliderNode = motionSliderNode;
                this.val$model = movingManModel;
            }

            public void update() {
                this.val$chartSliderNode.setHighlighted(this.val$model.getMovingMan().isAccelerationDriven());
            }
        };
        movingManModel.getMovingMan().addListener(new MovingMan.Listener((SimpleObserver)object3){
            final /* synthetic */ SimpleObserver val$updateAccelerationModeSelected;
            {
                this.val$updateAccelerationModeSelected = simpleObserver;
            }

            public void changed() {
                this.val$updateAccelerationModeSelected.update();
            }
        });
        object3.update();
        object4 = new MovingManChartControl(MovingManStrings.ACCELERATION, MovingManColorScheme.ACCELERATION_COLOR, new TextBoxListener.Acceleration(movingManModel), MovingManStrings.UNITS_ACCELERATION_ABBREVIATION);
        PNode pNode2 = new PSwing(new ShowVectorCheckBox(MovingManStrings.SHOW_VECTOR, movingManModel.getAccelerationVectorVisible()));
        pNode2.setOffset(0.0, ((PNode)object4).getFullBounds().getHeight());
        ((PNode)object4).addChild(pNode2);
        GoButton goButton = new GoButton(recordAndPlaybackModel, movingManModel.getAccelerationMode());
        goButton.setOffset(((PNode)object4).getFullBounds().getMaxX() - goButton.getFullBounds().getWidth(), ((PNode)object4).getFullBounds().getMaxY());
        ((PNode)object4).addChild(goButton);
        pNode2 = new ControlChart((PNode)object4, (PNode)object2, (TemporalChart)pNode, new ChartZoomControlNode((TemporalChart)pNode));
        this.accelerationMovingManChart = new MinimizableControlChart(MovingManSimSharing.UserComponents.minimizeAccelerationChartButton, MovingManSimSharing.UserComponents.maximizeAccelerationChartButton, MovingManStrings.ACCELERATION, (ControlChart)pNode2);
        final MultiControlChart multiControlChart = new MultiControlChart(new MinimizableControlChart[]{this.positionMovingManChart, this.velocityMovingManChart, this.accelerationMovingManChart});
        this.addScreenChild(multiControlChart);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                double d = MovingManSimulationPanelWithCharts.this.getPlayAreaRulerNode().getFullBounds().getMaxY() + 10.0;
                double d2 = 9.0;
                double d3 = 5.0;
                multiControlChart.setSize((double)MovingManSimulationPanelWithCharts.this.getWidth() - d3 * 2.0, (double)MovingManSimulationPanelWithCharts.this.getHeight() - d - d2);
                multiControlChart.setOffset(d3, d);
            }
        });
        multiControlChart.setSize(this.getWidth(), this.getHeight());
        object = new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                MovingManSimulationPanelWithCharts.this.getLayer().setOffset(0.0, 5.0);
            }
        };
        this.addComponentListener((ComponentListener)object);
        ((ComponentAdapter)object).componentResized(null);
    }

    @Override
    public void resetAll() {
        this.positionMovingManChart.resetAll();
        this.velocityMovingManChart.resetAll();
        this.accelerationMovingManChart.resetAll();
    }
}

