/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.charts;

import edu.colorado.phet.common.motion.charts.MinimizableControlChart;
import edu.umd.cs.piccolo.PNode;
import java.util.ArrayList;
import java.util.Collections;

public interface ControlChartLayout {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AlignedLayout
    implements ControlChartLayout {
        private ArrayList<Double> getValues(MinimizableControlChart[] minimizableControlChartArray, DoubleGetter doubleGetter) {
            ArrayList<Double> arrayList = new ArrayList<Double>();
            for (MinimizableControlChart minimizableControlChart : minimizableControlChartArray) {
                arrayList.add(doubleGetter.getValue(minimizableControlChart));
            }
            return arrayList;
        }

        public double getMax(MinimizableControlChart[] minimizableControlChartArray, DoubleGetter doubleGetter) {
            ArrayList<Double> arrayList = this.getValues(minimizableControlChartArray, doubleGetter);
            Collections.sort(arrayList);
            return arrayList.get(arrayList.size() - 1);
        }

        public void updateLayout(MinimizableControlChart[] minimizableControlChartArray, double d, double d2) {
            double d3 = this.getMax(minimizableControlChartArray, new DoubleGetter(){

                public Double getValue(MinimizableControlChart minimizableControlChart) {
                    return minimizableControlChart.getControlPanel().getFullBounds().getWidth();
                }
            });
            double d4 = this.getMax(minimizableControlChartArray, new DoubleGetter(){

                public Double getValue(MinimizableControlChart minimizableControlChart) {
                    return minimizableControlChart.getSliderNode().getFullBounds().getWidth();
                }
            });
            double d5 = this.getMax(minimizableControlChartArray, new DoubleGetter(){

                public Double getValue(MinimizableControlChart minimizableControlChart) {
                    PNode pNode = minimizableControlChart.getSliderNode();
                    if (pNode.getFullBounds().getWidth() == 0.0) {
                        return 0.0;
                    }
                    return pNode.getXOffset() - pNode.getFullBounds().getX();
                }
            });
            double d6 = this.getMax(minimizableControlChartArray, new DoubleGetter(){

                public Double getValue(MinimizableControlChart minimizableControlChart) {
                    return minimizableControlChart.getZoomButtonNode().getFullBounds().getWidth();
                }
            });
            double d7 = this.getMax(minimizableControlChartArray, new DoubleGetter(){

                public Double getValue(MinimizableControlChart minimizableControlChart) {
                    return minimizableControlChart.getDomainLabelHeight();
                }
            });
            double d8 = this.getMax(minimizableControlChartArray, new DoubleGetter(){

                public Double getValue(MinimizableControlChart minimizableControlChart) {
                    return minimizableControlChart.getMaxRangeAxisLabelWidth();
                }
            });
            int n = 0;
            double d9 = 0.0;
            for (MinimizableControlChart minimizableControlChart : minimizableControlChartArray) {
                if (((Boolean)minimizableControlChart.getMaximized().get()).booleanValue()) {
                    ++n;
                    continue;
                }
                d9 += minimizableControlChart.getMinimizedHeight();
            }
            double d10 = d - d3 - d4 - d8 - d6;
            double d11 = 0.0 + d3 + d5;
            double d12 = d - d6;
            double d13 = d12 - d10;
            int n2 = 8 * (minimizableControlChartArray.length - 1);
            double d14 = n == 0 ? 0.0 : (d2 - d9 - (double)n2) / (double)n - d7;
            double d15 = 0.0;
            for (MinimizableControlChart minimizableControlChart : minimizableControlChartArray) {
                minimizableControlChart.setLayoutLocations(0.0, d11, d13, d12);
                minimizableControlChart.getChartNode().getViewDimension().setDimension(d10, d14);
                minimizableControlChart.setOffset(0.0, d15);
                minimizableControlChart.setMinimizeMaximizeButtonOffset(d13 + d10 - minimizableControlChart.getMinimizeMaximizeButton().getFullBounds().getWidth() - 4.0, 0.0);
                double d16 = (Boolean)minimizableControlChart.getMaximized().get() != false ? d14 + minimizableControlChart.getDomainLabelHeight() : minimizableControlChart.getMinimizedHeight();
                d15 += 8.0 + d16;
            }
        }

        public static interface DoubleGetter {
            public Double getValue(MinimizableControlChart var1);
        }
    }
}

