/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import scala.Function1$class;
import scala.MatchError;
import scala.PartialFunction$class;
import scala.Serializable;
import scala.collection.CustomParallelizable;
import scala.collection.CustomParallelizable$class;
import scala.collection.GenIterable$class;
import scala.collection.GenIterableLike$class;
import scala.collection.GenSeq$class;
import scala.collection.GenSeqLike$class;
import scala.collection.GenTraversable$class;
import scala.collection.GenTraversableLike$class;
import scala.collection.GenTraversableOnce;
import scala.collection.GenTraversableOnce$class;
import scala.collection.IndexedSeqLike;
import scala.collection.IndexedSeqLike$class;
import scala.collection.Iterable$class;
import scala.collection.IterableLike$class;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.Iterator$class;
import scala.collection.Parallelizable$class;
import scala.collection.Seq$class;
import scala.collection.SeqLike$class;
import scala.collection.Traversable$class;
import scala.collection.TraversableLike$class;
import scala.collection.TraversableOnce$class;
import scala.collection.generic.CanBuildFrom;
import scala.collection.generic.GenericCompanion;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.generic.GenericTraversableTemplate$class;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$class;
import scala.collection.immutable.Vector$;
import scala.collection.immutable.VectorIterator;
import scala.collection.immutable.VectorPointer;
import scala.collection.immutable.VectorPointer$class;
import scala.collection.parallel.immutable.ParVector;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Vector<A>
implements Serializable,
CustomParallelizable<A, ParVector<A>>,
IndexedSeqLike<A, Vector<A>>,
GenericTraversableTemplate<A, Vector>,
IndexedSeq<A>,
VectorPointer<A> {
    public final int startIndex;
    public final int endIndex;
    public final int focus;
    private boolean dirty;
    private int depth;
    private Object[] display0;
    private Object[] display1;
    private Object[] display2;
    private Object[] display3;
    private Object[] display4;
    private Object[] display5;

    public int startIndex() {
        return this.startIndex;
    }

    public int endIndex() {
        return this.endIndex;
    }

    @Override
    public GenericCompanion<Vector> companion() {
        return Vector$.MODULE$;
    }

    public boolean dirty() {
        return this.dirty;
    }

    public void dirty_$eq(boolean bl) {
        this.dirty = bl;
    }

    @Override
    public int length() {
        return this.endIndex() - this.startIndex();
    }

    public final <B> void initIterator(VectorIterator<B> s) {
        s.initFrom(this);
        if (this.dirty()) {
            s.stabilize(this.focus);
        }
        if (s.depth() > 1) {
            s.gotoPos(this.startIndex(), this.startIndex() ^ this.focus);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public VectorIterator<A> iterator() {
        void var1_1;
        VectorIterator s = new VectorIterator(this.startIndex(), this.endIndex());
        this.initIterator(s);
        return var1_1;
    }

    @Override
    public Iterator<A> reverseIterator() {
        return new Iterator<A>(this){
            private int i;
            private final Vector $outer;

            private int i() {
                return this.i;
            }

            private void i_$eq(int n) {
                this.i = n;
            }

            public boolean hasNext() {
                return 0 < this.i();
            }

            public A next() {
                A a;
                if (0 < this.i()) {
                    this.i_$eq(this.i() - 1);
                    a = this.$outer.apply(this.i());
                } else {
                    a = Iterator$.MODULE$.empty().next();
                }
                return a;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                GenTraversableOnce$class.$init$(this);
                TraversableOnce$class.$init$(this);
                Iterator$class.$init$(this);
                this.i = $outer.length();
            }
        };
    }

    @Override
    public A apply(int index) {
        int idx = this.checkRangeConvert(index);
        return (A)this.getElem(idx, idx ^ this.focus);
    }

    private int checkRangeConvert(int index) {
        int idx = index + this.startIndex();
        if (0 <= index && idx < this.endIndex()) {
            return idx;
        }
        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger(index)).toString());
    }

    @Override
    public Vector<A> take(int n) {
        return n <= 0 ? Vector$.MODULE$.NIL() : (this.startIndex() + n < this.endIndex() ? this.dropBack0(this.startIndex() + n) : this);
    }

    @Override
    public Vector<A> drop(int n) {
        return n <= 0 ? this : (this.startIndex() + n < this.endIndex() ? super.dropFront0(this.startIndex() + n) : Vector$.MODULE$.NIL());
    }

    @Override
    public A head() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("empty.head");
        }
        return this.apply(0);
    }

    @Override
    public Vector<A> tail() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("empty.tail");
        }
        return this.drop(1);
    }

    @Override
    public <B, That> That $plus$plus(GenTraversableOnce<B> that, CanBuildFrom<Vector<A>, B, That> bf) {
        return (That)TraversableLike$class.$plus$plus(this, that.seq(), bf);
    }

    private void gotoPosWritable(int oldIndex, int newIndex, int xor) {
        if (this.dirty()) {
            this.gotoPosWritable1(oldIndex, newIndex, xor);
        } else {
            this.gotoPosWritable0(newIndex, xor);
            this.dirty_$eq(true);
        }
    }

    private void zeroLeft(Object[] array, int index) {
        for (int i = 0; i < index; ++i) {
            array[i] = null;
        }
    }

    private void zeroRight(Object[] array, int index) {
        for (int i = index; i < array.length; ++i) {
            array[i] = null;
        }
    }

    private Object[] copyLeft(Object[] array, int right) {
        Object[] a2 = new Object[array.length];
        int n = right;
        Object[] objectArray = a2;
        System.arraycopy(array, 0, objectArray, 0, n);
        return a2;
    }

    private Object[] copyRight(Object[] array, int left) {
        Object[] a2 = new Object[array.length];
        System.arraycopy(array, left, a2, left, a2.length - left);
        return a2;
    }

    private void preClean(int depth) {
        this.depth_$eq(depth);
        int n = depth - 1;
        switch (n) {
            default: {
                throw new MatchError(BoxesRunTime.boxToInteger(n));
            }
            case 4: {
                this.display5_$eq(null);
                break;
            }
            case 3: {
                this.display4_$eq(null);
                this.display5_$eq(null);
                break;
            }
            case 2: {
                this.display3_$eq(null);
                this.display4_$eq(null);
                this.display5_$eq(null);
                break;
            }
            case 1: {
                this.display2_$eq(null);
                this.display3_$eq(null);
                this.display4_$eq(null);
                this.display5_$eq(null);
                break;
            }
            case 0: {
                this.display1_$eq(null);
                this.display2_$eq(null);
                this.display3_$eq(null);
                this.display4_$eq(null);
                this.display5_$eq(null);
            }
            case 5: 
        }
    }

    private void cleanLeftEdge(int cutIndex) {
        block8: {
            block3: {
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    if (cutIndex >= 32) break block2;
                                    this.zeroLeft(this.display0(), cutIndex);
                                    break block3;
                                }
                                if (cutIndex >= 1024) break block4;
                                this.zeroLeft(this.display0(), cutIndex & 0x1F);
                                this.display1_$eq(this.copyRight(this.display1(), cutIndex >>> 5));
                                break block3;
                            }
                            if (cutIndex >= 32768) break block5;
                            this.zeroLeft(this.display0(), cutIndex & 0x1F);
                            this.display1_$eq(this.copyRight(this.display1(), cutIndex >>> 5 & 0x1F));
                            this.display2_$eq(this.copyRight(this.display2(), cutIndex >>> 10));
                            break block3;
                        }
                        if (cutIndex >= 0x100000) break block6;
                        this.zeroLeft(this.display0(), cutIndex & 0x1F);
                        this.display1_$eq(this.copyRight(this.display1(), cutIndex >>> 5 & 0x1F));
                        this.display2_$eq(this.copyRight(this.display2(), cutIndex >>> 10 & 0x1F));
                        this.display3_$eq(this.copyRight(this.display3(), cutIndex >>> 15));
                        break block3;
                    }
                    if (cutIndex >= 0x2000000) break block7;
                    this.zeroLeft(this.display0(), cutIndex & 0x1F);
                    this.display1_$eq(this.copyRight(this.display1(), cutIndex >>> 5 & 0x1F));
                    this.display2_$eq(this.copyRight(this.display2(), cutIndex >>> 10 & 0x1F));
                    this.display3_$eq(this.copyRight(this.display3(), cutIndex >>> 15 & 0x1F));
                    this.display4_$eq(this.copyRight(this.display4(), cutIndex >>> 20));
                    break block3;
                }
                if (cutIndex >= 0x40000000) break block8;
                this.zeroLeft(this.display0(), cutIndex & 0x1F);
                this.display1_$eq(this.copyRight(this.display1(), cutIndex >>> 5 & 0x1F));
                this.display2_$eq(this.copyRight(this.display2(), cutIndex >>> 10 & 0x1F));
                this.display3_$eq(this.copyRight(this.display3(), cutIndex >>> 15 & 0x1F));
                this.display4_$eq(this.copyRight(this.display4(), cutIndex >>> 20 & 0x1F));
                this.display5_$eq(this.copyRight(this.display5(), cutIndex >>> 25));
            }
            return;
        }
        throw new IllegalArgumentException();
    }

    private void cleanRightEdge(int cutIndex) {
        block8: {
            block3: {
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    if (cutIndex > 32) break block2;
                                    this.zeroRight(this.display0(), cutIndex);
                                    break block3;
                                }
                                if (cutIndex > 1024) break block4;
                                this.zeroRight(this.display0(), (cutIndex - 1 & 0x1F) + 1);
                                this.display1_$eq(this.copyLeft(this.display1(), cutIndex >>> 5));
                                break block3;
                            }
                            if (cutIndex > 32768) break block5;
                            this.zeroRight(this.display0(), (cutIndex - 1 & 0x1F) + 1);
                            this.display1_$eq(this.copyLeft(this.display1(), (cutIndex - 1 >>> 5 & 0x1F) + 1));
                            this.display2_$eq(this.copyLeft(this.display2(), cutIndex >>> 10));
                            break block3;
                        }
                        if (cutIndex > 0x100000) break block6;
                        this.zeroRight(this.display0(), (cutIndex - 1 & 0x1F) + 1);
                        this.display1_$eq(this.copyLeft(this.display1(), (cutIndex - 1 >>> 5 & 0x1F) + 1));
                        this.display2_$eq(this.copyLeft(this.display2(), (cutIndex - 1 >>> 10 & 0x1F) + 1));
                        this.display3_$eq(this.copyLeft(this.display3(), cutIndex >>> 15));
                        break block3;
                    }
                    if (cutIndex > 0x2000000) break block7;
                    this.zeroRight(this.display0(), (cutIndex - 1 & 0x1F) + 1);
                    this.display1_$eq(this.copyLeft(this.display1(), (cutIndex - 1 >>> 5 & 0x1F) + 1));
                    this.display2_$eq(this.copyLeft(this.display2(), (cutIndex - 1 >>> 10 & 0x1F) + 1));
                    this.display3_$eq(this.copyLeft(this.display3(), (cutIndex - 1 >>> 15 & 0x1F) + 1));
                    this.display4_$eq(this.copyLeft(this.display4(), cutIndex >>> 20));
                    break block3;
                }
                if (cutIndex > 0x40000000) break block8;
                this.zeroRight(this.display0(), (cutIndex - 1 & 0x1F) + 1);
                this.display1_$eq(this.copyLeft(this.display1(), (cutIndex - 1 >>> 5 & 0x1F) + 1));
                this.display2_$eq(this.copyLeft(this.display2(), (cutIndex - 1 >>> 10 & 0x1F) + 1));
                this.display3_$eq(this.copyLeft(this.display3(), (cutIndex - 1 >>> 15 & 0x1F) + 1));
                this.display4_$eq(this.copyLeft(this.display4(), (cutIndex - 1 >>> 20 & 0x1F) + 1));
                this.display5_$eq(this.copyLeft(this.display5(), cutIndex >>> 25));
            }
            return;
        }
        throw new IllegalArgumentException();
    }

    private int requiredDepth(int xor) {
        block8: {
            int n;
            block3: {
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    if (xor >= 32) break block2;
                                    n = 1;
                                    break block3;
                                }
                                if (xor >= 1024) break block4;
                                n = 2;
                                break block3;
                            }
                            if (xor >= 32768) break block5;
                            n = 3;
                            break block3;
                        }
                        if (xor >= 0x100000) break block6;
                        n = 4;
                        break block3;
                    }
                    if (xor >= 0x2000000) break block7;
                    n = 5;
                    break block3;
                }
                if (xor >= 0x40000000) break block8;
                n = 6;
            }
            return n;
        }
        throw new IllegalArgumentException();
    }

    private Vector<A> dropFront0(int cutIndex) {
        int blockIndex = cutIndex & ~31;
        int xor = cutIndex ^ this.endIndex() - 1;
        int d = this.requiredDepth(xor);
        int shift = cutIndex & ~((1 << 5 * d) - 1);
        Vector<A> s = new Vector<A>(cutIndex - shift, this.endIndex() - shift, blockIndex - shift);
        s.initFrom(this);
        s.dirty_$eq(this.dirty());
        super.gotoPosWritable(this.focus, blockIndex, this.focus ^ blockIndex);
        super.preClean(d);
        super.cleanLeftEdge(cutIndex - shift);
        return s;
    }

    private Vector<A> dropBack0(int cutIndex) {
        int blockIndex = cutIndex - 1 & ~31;
        int xor = this.startIndex() ^ cutIndex - 1;
        int d = this.requiredDepth(xor);
        int shift = this.startIndex() & ~((1 << 5 * d) - 1);
        Vector<A> s = new Vector<A>(this.startIndex() - shift, cutIndex - shift, blockIndex - shift);
        s.initFrom(this);
        s.dirty_$eq(this.dirty());
        super.gotoPosWritable(this.focus, blockIndex, this.focus ^ blockIndex);
        super.preClean(d);
        super.cleanRightEdge(cutIndex - shift);
        return s;
    }

    public Vector(int startIndex, int endIndex, int focus) {
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.focus = focus;
        GenTraversableOnce$class.$init$(this);
        TraversableOnce$class.$init$(this);
        Parallelizable$class.$init$(this);
        GenTraversableLike$class.$init$(this);
        TraversableLike$class.$init$(this);
        GenericTraversableTemplate$class.$init$(this);
        GenTraversable$class.$init$(this);
        Traversable$class.$init$(this);
        scala.collection.immutable.Traversable$class.$init$(this);
        GenIterableLike$class.$init$(this);
        GenIterable$class.$init$(this);
        IterableLike$class.$init$(this);
        Iterable$class.$init$(this);
        scala.collection.immutable.Iterable$class.$init$(this);
        Function1$class.$init$(this);
        PartialFunction$class.$init$(this);
        GenSeqLike$class.$init$(this);
        GenSeq$class.$init$(this);
        SeqLike$class.$init$(this);
        Seq$class.$init$(this);
        scala.collection.immutable.Seq$class.$init$(this);
        IndexedSeqLike$class.$init$(this);
        scala.collection.IndexedSeq$class.$init$(this);
        IndexedSeq$class.$init$(this);
        VectorPointer$class.$init$(this);
        CustomParallelizable$class.$init$(this);
        this.dirty = false;
    }
}

