/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.motionseries.model;

import edu.colorado.phet.motionseries.model.MotionSeriesObject;
import edu.colorado.phet.motionseries.model.MotionStrategyMemento;
import edu.colorado.phet.scalacommon.math.Vector2D;

public abstract class MotionStrategy {
    private final MotionSeriesObject motionSeriesObject;

    public MotionSeriesObject motionSeriesObject() {
        return this.motionSeriesObject;
    }

    public void updateAppliedForce() {
        this.motionSeriesObject().appliedForce().value_$eq(this.motionSeriesObject().rampUnitVector().$times(this.motionSeriesObject().parallelAppliedForce()));
    }

    public void updateForces() {
        this.updateAppliedForce();
        this.motionSeriesObject().wallForce().value_$eq(this.wallForce());
        this.motionSeriesObject().frictionForce().value_$eq(this.frictionForce(true));
        this.motionSeriesObject().normalForce().value_$eq(this.normalForce());
        this.motionSeriesObject().gravityForce().value_$eq(this.motionSeriesObject().gravityForce().value());
        this.motionSeriesObject().totalForce().value_$eq(this.motionSeriesObject().gravityForce().value().$plus(this.motionSeriesObject().normalForce().value()).$plus(this.motionSeriesObject().appliedForce().value()).$plus(this.motionSeriesObject().frictionForce().value()).$plus(this.motionSeriesObject().wallForce().value()));
    }

    public abstract boolean isCrashed();

    public abstract void stepInTime(double var1);

    public abstract double getAngle();

    public abstract MotionStrategyMemento getMemento();

    public Vector2D wallForce() {
        return new Vector2D();
    }

    public Vector2D frictionForce(boolean includeWallForce) {
        return new Vector2D();
    }

    public Vector2D normalForce() {
        return new Vector2D();
    }

    public Vector2D mapPosition() {
        return this.motionSeriesObject().positionMapper().apply(this.motionSeriesObject().position());
    }

    public MotionStrategy(MotionSeriesObject motionSeriesObject) {
        this.motionSeriesObject = motionSeriesObject;
    }
}

