/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.motionseries.graphics;

import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.motionseries.graphics.TickMarkSet$;
import edu.colorado.phet.motionseries.model.PositionMapper;
import edu.colorado.phet.scalacommon.math.Vector2D;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.runtime.BoxedUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TickMarkSet
extends PNode {
    private final ModelViewTransform2D transform;
    private final PositionMapper positionMapper;
    private final Function1<Function0<BoxedUnit>, BoxedUnit> addListener;
    private final IndexedSeq<PText> tickLabels;
    private final PText zeroLabel;
    private final PText metersReadout;
    private final PropertyChangeListener changeListener;

    public PText zeroLabel() {
        return this.zeroLabel;
    }

    public PText metersReadout() {
        return this.metersReadout;
    }

    public PropertyChangeListener changeListener() {
        return this.changeListener;
    }

    public PText addTickLabel(double x$1) {
        PhetPPath path$1 = new PhetPPath(Color.black);
        PText label$1 = new PText(this, x$1){
            {
                this.setFont(new PhetFont(18, true));
            }
        };
        this.addChild(path$1);
        this.addChild(label$1);
        this.addListener.apply((Function0<BoxedUnit>)((Object)new Serializable(this, x$1, path$1, label$1){
            public static final long serialVersionUID;
            private final TickMarkSet $outer;
            private final double x$1;
            private final PhetPPath path$1;
            private final PText label$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.update$1(this.x$1, this.path$1, this.label$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.x$1 = d;
                this.path$1 = phetPPath;
                this.label$1 = pText;
            }
        }));
        this.update$1(x$1, path$1, label$1);
        return label$1;
    }

    public final void update$1(double d, PhetPPath phetPPath, PText pText) {
        Vector2D vector = this.positionMapper.apply(d);
        Point d2 = this.transform.modelToView(vector.x(), vector.y());
        phetPPath.setPathTo(new Rectangle2D.Double(d2.x, d2.y, 2.0, 2.0));
        pText.setOffset(phetPPath.getFullBounds().getCenterX() - pText.getFullBounds().width / (double)2, phetPPath.getFullBounds().getMaxY());
    }

    public TickMarkSet(ModelViewTransform2D transform, PositionMapper positionMapper, Function1<Function0<BoxedUnit>, BoxedUnit> addListener) {
        this.transform = transform;
        this.positionMapper = positionMapper;
        this.addListener = addListener;
        this.tickLabels = Predef$.MODULE$.intWrapper(-10).to(10).by(2).withFilter(new $anonfun$1(this)).map(new $anonfun$2(this), IndexedSeq$.MODULE$.canBuildFrom());
        this.zeroLabel = this.addTickLabel(0.0);
        this.metersReadout = new $anon$2(this);
        this.addChild(this.metersReadout());
        this.changeListener = new $anon$3(this);
        this.zeroLabel().addPropertyChangeListener(PNode.PROPERTY_FULL_BOUNDS, this.changeListener());
        this.changeListener().propertyChange(null);
        this.setPickable(false);
        this.setChildrenPickable(false);
    }
}

