/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.motionseries.graphics;

import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.motionseries.MotionSeriesResources$;
import edu.colorado.phet.motionseries.graphics.Struts;
import edu.colorado.phet.motionseries.sims.rampforcesandmotion.robotmovingcompany.RobotMovingCompanyGameModel;
import edu.colorado.phet.scalacommon.math.Vector2D;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.Point;
import scala.Function0;
import scala.Serializable;
import scala.runtime.BoxedUnit;

public class RobotGraphics
extends PNode {
    private final ModelViewTransform2D transform;
    private final RobotMovingCompanyGameModel gameModel;
    private final Struts struts;
    private final PImage truckWheels;
    private final PImage truckTop;

    public Struts struts() {
        return this.struts;
    }

    public PImage truckWheels() {
        return this.truckWheels;
    }

    public PImage truckTop() {
        return this.truckTop;
    }

    public void update() {
        Vector2D rampTopLeft = this.gameModel.model().positionMapper().apply(-10.0);
        Point rampTopLeftView = this.transform.modelToView(rampTopLeft.x(), rampTopLeft.y());
        this.truckTop().setOffset((double)rampTopLeftView.x - this.truckTop().getFullBounds().getWidth() * 0.65, (double)rampTopLeftView.y - this.truckTop().getFullBounds().getHeight());
        this.truckWheels().setOffset(this.truckTop().getFullBounds().getCenterX() - this.truckWheels().getFullBounds().getWidth() / (double)2, (double)this.transform.modelToView((double)0.0, (double)0.0).y - this.truckWheels().getFullBounds().getHeight());
        this.struts().update(this.truckWheels().getFullBounds(), this.truckTop().getFullBounds());
    }

    public RobotGraphics(ModelViewTransform2D transform, RobotMovingCompanyGameModel gameModel) {
        this.transform = transform;
        this.gameModel = gameModel;
        this.struts = new Struts();
        this.addChild(this.struts());
        this.truckWheels = new PImage(MotionSeriesResources$.MODULE$.getImage(MotionSeriesResources$.MODULE$.toMyRichString("robotmovingcompany/truck_wheels.gif").literal()));
        this.addChild(this.truckWheels());
        this.truckTop = new PImage(MotionSeriesResources$.MODULE$.getImage(MotionSeriesResources$.MODULE$.toMyRichString("robotmovingcompany/truck_top.gif").literal()));
        this.addChild(this.truckTop());
        gameModel.model().leftRampSegment().addListener((Function0<BoxedUnit>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final RobotGraphics $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.update();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        this.update();
    }
}

