/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.charts;

import edu.colorado.phet.common.motion.charts.ChartCursor;
import edu.colorado.phet.common.motion.charts.CursorNode;
import edu.colorado.phet.common.motion.charts.MutableDimension;
import edu.colorado.phet.common.motion.charts.MutableRectangle;
import edu.colorado.phet.common.motion.charts.TemporalDataSeries;
import edu.colorado.phet.common.motion.model.TimeData;
import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.TransformListener;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.nodes.PClip;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;

public class TemporalChart
extends PNode {
    private static final Stroke DOMAIN_TICK_MARK_STROKE = new BasicStroke(1.5f);
    private static final Paint DOMAIN_TICK_MARK_COLOR = Color.black;
    private MutableRectangle dataModelBounds;
    private MutableRectangle minimumZoomableDataModelBounds;
    private MutableRectangle maximumZoomableDataModelBounds;
    private MutableDimension viewDimension;
    private PNode chartContents;
    private ModelViewTransform2D modelViewTransform2D;
    private TickMarkAndGridLineNode tickMarksAndGridLines;
    public static String SEC_TEXT = "sec";
    public static String TIME_LABEL_PATTERN = "{0} {1}";
    private ArrayList<LineSeriesNode> lineSeriesNodes = new ArrayList();
    double verticalScaleFactor = 1.2;

    public TemporalChart(Rectangle2D.Double double_, Rectangle2D.Double double_2, Rectangle2D.Double double_3, ChartCursor chartCursor) {
        this(double_, double_2, double_3, 100.0, 100.0, chartCursor);
    }

    public TemporalChart(Rectangle2D.Double double_, Rectangle2D.Double double_2, Rectangle2D.Double double_3, double d, double d2, ChartCursor chartCursor) {
        this.dataModelBounds = new MutableRectangle(double_);
        this.minimumZoomableDataModelBounds = new MutableRectangle(double_2);
        this.maximumZoomableDataModelBounds = new MutableRectangle(double_3);
        this.viewDimension = new MutableDimension(d, d2);
        this.chartContents = new PNode();
        this.addChild(this.chartContents);
        final PhetPPath phetPPath = new PhetPPath(Color.white, (Stroke)new BasicStroke(1.0f), (Paint)Color.black);
        SimpleObserver simpleObserver = new SimpleObserver(){

            public void update() {
                phetPPath.setPathTo(new Rectangle2D.Double(0.0, 0.0, TemporalChart.this.viewDimension.getWidth(), TemporalChart.this.viewDimension.getHeight()));
            }
        };
        simpleObserver.update();
        this.viewDimension.addObserver(simpleObserver);
        this.addChartChild(phetPPath);
        this.tickMarksAndGridLines = new TickMarkAndGridLineNode();
        this.tickMarksAndGridLines.setPickable(false);
        this.tickMarksAndGridLines.setChildrenPickable(false);
        this.addChartChild(this.tickMarksAndGridLines);
        this.modelViewTransform2D = new ModelViewTransform2D(double_, new Rectangle2D.Double(0.0, 0.0, d, d2));
        SimpleObserver simpleObserver2 = new SimpleObserver(){

            public void update() {
                if (TemporalChart.this.viewDimension.getWidth() > 0.0 && TemporalChart.this.viewDimension.getHeight() > 0.0) {
                    TemporalChart.this.modelViewTransform2D.setViewBounds(new Rectangle2D.Double(0.0, 0.0, TemporalChart.this.viewDimension.getWidth(), TemporalChart.this.viewDimension.getHeight()));
                }
            }
        };
        simpleObserver2.update();
        this.viewDimension.addObserver(simpleObserver2);
        SimpleObserver simpleObserver3 = new SimpleObserver(){

            public void update() {
                TemporalChart.this.modelViewTransform2D.setModelBounds(TemporalChart.this.dataModelBounds.toRectangle2D());
            }
        };
        simpleObserver3.update();
        this.dataModelBounds.addObserver(simpleObserver3);
        this.modelViewTransform2D.addTransformListener(new TransformListener(){

            public void transformChanged(ModelViewTransform2D modelViewTransform2D) {
                TemporalChart.this.updateTickMarksAndGridLines();
            }
        });
        this.updateTickMarksAndGridLines();
        this.addChartChild(new CursorNode(chartCursor, this));
    }

    private void updateTickMarksAndGridLines() {
        Object object;
        PNode pNode;
        this.tickMarksAndGridLines.removeAllChildren();
        int n = 10;
        Function.LinearFunction linearFunction = new Function.LinearFunction(0.0, n, this.dataModelBounds.getX(), this.dataModelBounds.getMaxX());
        PNode pNode2 = new PNode();
        for (int i = 0; i < n + 1; ++i) {
            final double d = linearFunction.evaluate(i);
            final DomainTickMark domainTickMark = new DomainTickMark(d);
            pNode2.addChild(domainTickMark);
            SimpleObserver simpleObserver = new SimpleObserver(){

                public void update() {
                    Point2D point2D = TemporalChart.this.modelToView(new TimeData(0.0, d));
                    domainTickMark.setOffset(point2D.getX(), TemporalChart.this.viewDimension.getHeight());
                }
            };
            simpleObserver.update();
            this.viewDimension.addObserver(simpleObserver);
            DomainGridLine domainGridLine = new DomainGridLine(d, this);
            this.tickMarksAndGridLines.addChild(domainGridLine);
            pNode = new PhetPPath(new Line2D.Double(0.0, 0.0, 0.0, 4.0), DOMAIN_TICK_MARK_STROKE, DOMAIN_TICK_MARK_COLOR);
            this.tickMarksAndGridLines.addChild(pNode);
            object = new SimpleObserver((PhetPPath)pNode){
                final /* synthetic */ PhetPPath val$axisTickMark;
                {
                    this.val$axisTickMark = phetPPath;
                }

                public void update() {
                    Point2D point2D = TemporalChart.this.modelToView(new TimeData(0.0, d));
                    this.val$axisTickMark.setOffset(point2D.getX(), point2D.getY());
                }
            };
            object.update();
            this.viewDimension.addObserver((SimpleObserver)object);
        }
        this.tickMarksAndGridLines.setDomainTickMarks(pNode2);
        DomainTickMark domainTickMark = (DomainTickMark)pNode2.getChild(pNode2.getChildrenCount() - 1);
        domainTickMark.setTickText(MessageFormat.format(TIME_LABEL_PATTERN, domainTickMark.getTickText(), SEC_TEXT));
        int n2 = 4;
        Function.LinearFunction linearFunction2 = new Function.LinearFunction(0.0, n2, this.dataModelBounds.getY(), this.dataModelBounds.getMaxY());
        for (int i = 0; i < n2 + 1; ++i) {
            final double d = linearFunction2.evaluate(i);
            pNode = new RangeTickMark(d);
            this.tickMarksAndGridLines.addRangeTickMark((RangeTickMark)pNode);
            object = new RangeGridLine(d, this);
            this.tickMarksAndGridLines.addChild((PNode)object);
            SimpleObserver simpleObserver = new SimpleObserver((RangeTickMark)pNode){
                final /* synthetic */ RangeTickMark val$tickMark;
                {
                    this.val$tickMark = rangeTickMark;
                }

                public void update() {
                    Point2D point2D = TemporalChart.this.modelToView(new TimeData(d, 0.0));
                    this.val$tickMark.setOffset(0.0, point2D.getY());
                }
            };
            simpleObserver.update();
            this.viewDimension.addObserver(simpleObserver);
            this.dataModelBounds.addObserver(simpleObserver);
        }
    }

    public double getMaxRangeValue() {
        return this.dataModelBounds.getMaxY();
    }

    public double getMinRangeValue() {
        return this.dataModelBounds.getMinY();
    }

    public MutableDimension getViewDimension() {
        return this.viewDimension;
    }

    public double viewToModel(double d) {
        return this.modelViewTransform2D.viewToModelDifferentialX(d);
    }

    public void addChartChild(PNode pNode) {
        this.chartContents.addChild(pNode);
    }

    public double getDomainLabelHeight() {
        return 20.0;
    }

    public void setDomainAxisLabelsVisible(boolean bl) {
        this.tickMarksAndGridLines.setDomainTickMarksVisible(bl);
    }

    public void reset() {
        this.dataModelBounds.reset();
        this.clear();
    }

    public double getMaxRangeAxisLabelWidth() {
        return this.tickMarksAndGridLines.getMaxRangeAxisLabelWidth();
    }

    public void clear() {
        for (LineSeriesNode lineSeriesNode : this.lineSeriesNodes) {
            lineSeriesNode.reset();
        }
    }

    public double getMinimumDomainRange() {
        return this.minimumZoomableDataModelBounds.getWidth();
    }

    public double getMinimumRangeRange() {
        return this.minimumZoomableDataModelBounds.getHeight();
    }

    public double getMaximumRangeRange() {
        return this.maximumZoomableDataModelBounds.getHeight();
    }

    public double getMaximumDomainRange() {
        return this.maximumZoomableDataModelBounds.getWidth();
    }

    public void addDataSeries(TemporalDataSeries temporalDataSeries, Color color) {
        LineSeriesNode lineSeriesNode = new LineSeriesNode(temporalDataSeries, color);
        this.lineSeriesNodes.add(lineSeriesNode);
        this.chartContents.addChild(lineSeriesNode);
    }

    public Point2D modelToView(TimeData timeData) {
        return this.modelViewTransform2D.modelToViewDouble(timeData.getTime(), timeData.getValue());
    }

    public MutableRectangle getDataModelBounds() {
        return this.dataModelBounds;
    }

    public void zoomInHorizontal() {
        this.dataModelBounds.setHorizontalRange(this.dataModelBounds.getMinX(), this.dataModelBounds.getMaxX() - 2.0);
    }

    public void zoomOutHorizontal() {
        this.dataModelBounds.setHorizontalRange(this.dataModelBounds.getMinX(), this.dataModelBounds.getMaxX() + 2.0);
    }

    public void zoomOutVertical() {
        this.dataModelBounds.setVerticalRange(this.dataModelBounds.getMinY() * this.verticalScaleFactor, this.dataModelBounds.getMaxY() * this.verticalScaleFactor);
    }

    public void zoomInVertical() {
        this.dataModelBounds.setVerticalRange(this.dataModelBounds.getMinY() / this.verticalScaleFactor, this.dataModelBounds.getMaxY() / this.verticalScaleFactor);
    }

    private class TickMarkAndGridLineNode
    extends PNode {
        private PNode domainTickMarks;
        private PNode rangeTickMarks = new PNode();
        private boolean domainTickMarksVisible;

        private TickMarkAndGridLineNode() {
            this.addChild(this.rangeTickMarks);
        }

        public void setDomainTickMarks(PNode pNode) {
            if (pNode != null) {
                this.removeChild(pNode);
            }
            this.domainTickMarks = pNode;
            this.addChild(pNode);
            this.domainTickMarks.setVisible(this.domainTickMarksVisible);
        }

        public void removeAllChildren() {
            super.removeAllChildren();
            this.rangeTickMarks.removeAllChildren();
            this.addChild(this.rangeTickMarks);
        }

        public void setDomainTickMarksVisible(boolean bl) {
            this.domainTickMarksVisible = bl;
            if (this.domainTickMarks != null) {
                this.domainTickMarks.setVisible(bl);
            }
        }

        public void addRangeTickMark(RangeTickMark rangeTickMark) {
            this.rangeTickMarks.addChild(rangeTickMark);
        }

        public double getMaxRangeAxisLabelWidth() {
            double d = 0.0;
            for (int i = 0; i < this.rangeTickMarks.getChildrenCount(); ++i) {
                if (!(this.rangeTickMarks.getFullBounds().getWidth() > d)) continue;
                d = this.rangeTickMarks.getFullBounds().getWidth();
            }
            return d;
        }
    }

    private class LineSeriesNode
    extends PNode {
        private TemporalDataSeries dataSeries;

        public LineSeriesNode(final TemporalDataSeries temporalDataSeries, Color color) {
            this.dataSeries = temporalDataSeries;
            TemporalDataSeries.Adapter adapter = new TemporalDataSeries.Adapter(){

                public void visibilityChanged() {
                    LineSeriesNode.this.setVisible(temporalDataSeries.isVisible());
                }
            };
            temporalDataSeries.addListener(adapter);
            adapter.visibilityChanged();
            this.setPickable(false);
            this.setChildrenPickable(false);
            final PClip pClip = new PClip();
            SimpleObserver simpleObserver = new SimpleObserver(){

                public void update() {
                    pClip.setPathTo(new Rectangle2D.Double(0.0, 0.0, TemporalChart.this.viewDimension.getWidth(), TemporalChart.this.viewDimension.getHeight()));
                }
            };
            TemporalChart.this.viewDimension.addObserver(simpleObserver);
            simpleObserver.update();
            final PhetPPath phetPPath = new PhetPPath(new GeneralPath(), new BasicStroke(3.0f), color){

                public Rectangle2D getPathBoundsWithStroke() {
                    return new Rectangle2D.Double(0.0, 0.0, TemporalChart.this.viewDimension.getWidth(), TemporalChart.this.viewDimension.getHeight());
                }
            };
            pClip.addChild(phetPPath);
            this.addChild(pClip);
            final TemporalDataSeries.Adapter adapter2 = new TemporalDataSeries.Adapter(){

                public void entireSeriesChanged() {
                    TimeData[] timeDataArray = temporalDataSeries.getData();
                    DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath();
                    for (int i = 0; i < timeDataArray.length; ++i) {
                        Point2D point2D = TemporalChart.this.modelToView(timeDataArray[i]);
                        if (i == 0) {
                            doubleGeneralPath.moveTo(point2D);
                            continue;
                        }
                        doubleGeneralPath.lineTo(point2D);
                    }
                    phetPPath.setPathTo(doubleGeneralPath.getGeneralPath());
                }

                public void dataPointAdded(TimeData timeData) {
                    GeneralPath generalPath = phetPPath.getPathReference();
                    Point2D point2D = TemporalChart.this.modelToView(timeData);
                    float f = (float)point2D.getX();
                    float f2 = (float)point2D.getY();
                    if (generalPath.getCurrentPoint() == null) {
                        generalPath.moveTo(f, f2);
                    } else {
                        generalPath.lineTo(f, f2);
                    }
                    phetPPath.updateBoundsFromPath();
                    phetPPath.invalidatePaint();
                }
            };
            temporalDataSeries.addListener(adapter2);
            TransformListener transformListener = new TransformListener(){

                public void transformChanged(ModelViewTransform2D modelViewTransform2D) {
                    adapter2.entireSeriesChanged();
                }
            };
            TemporalChart.this.modelViewTransform2D.addTransformListener(transformListener);
            transformListener.transformChanged(null);
        }

        public void reset() {
            this.dataSeries.clear();
        }
    }

    private static class RangeGridLine
    extends PNode {
        private RangeGridLine(final double d, final TemporalChart temporalChart) {
            final PhetPPath phetPPath = new PhetPPath(new BasicStroke(d == 0.0 ? 1.25f : 1.0f, 0, 1, 0.0f, new float[]{10.0f, 3.0f}, 0.0f), (Paint)(d == 0.0 ? Color.black : Color.lightGray));
            this.addChild(phetPPath);
            SimpleObserver simpleObserver = new SimpleObserver(){

                public void update() {
                    double d2 = temporalChart.modelToView(new TimeData(d, 0.0)).getY();
                    phetPPath.setPathTo(new Line2D.Double(0.0, d2, temporalChart.viewDimension.getWidth(), d2));
                }
            };
            simpleObserver.update();
        }
    }

    private static class DomainGridLine
    extends PNode {
        private DomainGridLine(final double d, final TemporalChart temporalChart) {
            final PhetPPath phetPPath = new PhetPPath(new BasicStroke(1.0f, 0, 1, 0.0f, new float[]{10.0f, 3.0f}, 0.0f), (Paint)Color.lightGray);
            SimpleObserver simpleObserver = new SimpleObserver(){

                public void update() {
                    double d2 = temporalChart.modelToView(new TimeData(0.0, d)).getX();
                    phetPPath.setPathTo(new Line2D.Double(d2, temporalChart.viewDimension.getHeight(), d2, 0.0));
                }
            };
            simpleObserver.update();
            this.addChild(phetPPath);
        }
    }

    private static class RangeTickMark
    extends PNode {
        private RangeTickMark(double d) {
            PhetPPath phetPPath = new PhetPPath(new Line2D.Double(0.0, 0.0, -4.0, 0.0), DOMAIN_TICK_MARK_STROKE, DOMAIN_TICK_MARK_COLOR);
            this.addChild(phetPPath);
            PText pText = new PText(new DecimalFormat("0.0").format(d));
            pText.setFont(new PhetFont(14, true));
            this.addChild(pText);
            double d2 = 7.0;
            pText.setOffset(phetPPath.getFullBounds().getMinX() - pText.getFullBounds().getWidth() - d2, phetPPath.getFullBounds().getCenterY() - pText.getFullBounds().getHeight() / 2.0);
        }
    }

    public static class DomainTickMark
    extends PNode {
        private PText text;

        public DomainTickMark(double d) {
            PhetPPath phetPPath = new PhetPPath(new Line2D.Double(0.0, 0.0, 0.0, 4.0), DOMAIN_TICK_MARK_STROKE, DOMAIN_TICK_MARK_COLOR);
            this.addChild(phetPPath);
            String string = new DecimalFormat("0.0").format(d);
            if (string.endsWith(".0")) {
                string = string.substring(0, string.indexOf(".0"));
            }
            this.text = new PText(string);
            this.text.setFont(new PhetFont(14, true));
            this.addChild(this.text);
            this.text.setOffset(phetPPath.getFullBounds().getCenterX() - this.text.getFullBounds().getWidth() / 2.0, phetPPath.getFullBounds().getHeight());
        }

        public String getTickText() {
            return this.text.getText();
        }

        public void setTickText(String string) {
            this.text.setText(string);
        }
    }
}

