/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculesandlight.view;

import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetcommon.view.util.SpectrumImageFactory;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.ArrowNode;
import edu.colorado.phet.common.piccolophet.nodes.ButtonNode;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.moleculesandlight.MoleculesAndLightResources;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JFrame;

public class SpectrumWindow
extends JFrame {
    public SpectrumWindow() {
        super(MoleculesAndLightResources.getString("SpectrumWindow.title"));
        this.setToDefaultSizeAndPosition();
        this.setDefaultCloseOperation(1);
        PhetPCanvas phetPCanvas = new PhetPCanvas();
        phetPCanvas.setBackground(new Color(233, 236, 174));
        phetPCanvas.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
        phetPCanvas.setWorldTransformStrategy(new PhetPCanvas.CenteredStage(phetPCanvas, new PDimension(SpectrumDiagram.OVERALL_DIMENSIONS.getWidth(), SpectrumDiagram.OVERALL_DIMENSIONS.getHeight() + 40.0)));
        SpectrumDiagram spectrumDiagram = new SpectrumDiagram();
        phetPCanvas.addWorldChild(spectrumDiagram);
        ButtonNode buttonNode = new ButtonNode(MoleculesAndLightResources.getCommonString("Common.choice.close"), Color.ORANGE);
        buttonNode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WindowEvent windowEvent = new WindowEvent(SpectrumWindow.this, 201);
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(windowEvent);
            }
        });
        buttonNode.centerFullBoundsOnPoint(spectrumDiagram.getFullBoundsReference().getCenterX(), spectrumDiagram.getFullBoundsReference().getMaxY() + 30.0);
        phetPCanvas.addWorldChild(buttonNode);
        this.setContentPane(phetPCanvas);
    }

    public void setToDefaultSizeAndPosition() {
        this.setSize(800, 600);
        SwingUtils.centerWindowOnScreen(this);
    }

    private static class ChirpNode
    extends PNode {
        public ChirpNode(double d) {
            double d2 = d * 0.1;
            PhetPPath phetPPath = new PhetPPath(new Rectangle2D.Double(0.0, 0.0, d, d * 0.1), new Color(237, 243, 246), new BasicStroke(2.0f), Color.black);
            this.addChild(phetPPath);
            DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath(0.0, 0.0);
            int n = 2000;
            for (int i = 0; i < n; ++i) {
                double d3;
                double d4 = (double)i * (d / (double)(n - 1));
                double d5 = d4 / d;
                double d6 = 1.0;
                double d7 = 2.0;
                double d8 = d3 = Math.sin(Math.PI * 2 * d6 * (Math.pow(d7, d5 * 4.5) - 1.0) / Math.log(d7));
                double d9 = d8 * d2 * 0.4 + d2 / 2.0;
                doubleGeneralPath.lineTo(d4, d9);
            }
            PhetPPath phetPPath2 = new PhetPPath(doubleGeneralPath.getGeneralPath(), (Stroke)new BasicStroke(2.0f, 0, 1), (Paint)Color.BLACK);
            this.addChild(phetPPath2);
        }
    }

    private static class LabeledArrow
    extends PNode {
        public static double ARROW_HEAD_HEIGHT = 40.0;
        private static double ARROW_HEAD_WIDTH = 40.0;
        private static double ARROW_TAIL_WIDTH = 25.0;
        private static Font LABEL_FONT = new PhetFont(16);
        private static Stroke STROKE = new BasicStroke(2.0f);

        public LabeledArrow(double d, Orientation orientation, String string, Color color, Color color2) {
            ArrowNode arrowNode;
            GradientPaint gradientPaint = new GradientPaint(0.0f, (float)(-ARROW_HEAD_HEIGHT) / 2.0f, color, 0.0f, (float)ARROW_HEAD_HEIGHT / 2.0f, color2);
            if (orientation == Orientation.POINTING_RIGHT) {
                arrowNode = new ArrowNode(new Point2D.Double(0.0, 0.0), new Point2D.Double(d, 0.0), ARROW_HEAD_HEIGHT, ARROW_HEAD_WIDTH, ARROW_TAIL_WIDTH);
            } else {
                assert (orientation == Orientation.POINTING_LEFT);
                arrowNode = new ArrowNode(new Point2D.Double(d, 0.0), new Point2D.Double(0.0, 0.0), ARROW_HEAD_HEIGHT, ARROW_HEAD_WIDTH, ARROW_TAIL_WIDTH);
            }
            arrowNode.setPaint(gradientPaint);
            arrowNode.setStroke(STROKE);
            arrowNode.setOffset(0.0, ARROW_HEAD_HEIGHT / 2.0);
            this.addChild(arrowNode);
            PText pText = new PText(string);
            pText.setFont(LABEL_FONT);
            pText.centerFullBoundsOnPoint(arrowNode.getFullBoundsReference().getCenterX(), arrowNode.getFullBoundsReference().getCenterY());
            this.addChild(pText);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class Orientation
        extends Enum<Orientation> {
            public static final /* enum */ Orientation POINTING_LEFT = new Orientation();
            public static final /* enum */ Orientation POINTING_RIGHT = new Orientation();
            private static final /* synthetic */ Orientation[] $VALUES;

            public static Orientation[] values() {
                return (Orientation[])$VALUES.clone();
            }

            static {
                $VALUES = new Orientation[]{POINTING_LEFT, POINTING_RIGHT};
            }
        }
    }

    private static class LabeledSpectrumNode
    extends PNode {
        private static final Stroke TICK_MARK_STROKE = new BasicStroke(2.0f);
        private static final Font TICK_MARK_FONT = new PhetFont(12);
        private static final Stroke BAND_DIVIDER_STROKE = new BasicStroke(2.0f, 0, 2, 0.0f, new float[]{4.0f, 4.0f}, 0.0f);
        private static final Font LABEL_FONT = new PhetFont(16);
        private final double stripWidth;
        private final PNode spectrumRootNode;

        public LabeledSpectrumNode(double d) {
            boolean bl;
            int n;
            this.stripWidth = d;
            this.spectrumRootNode = new PNode();
            this.addChild(this.spectrumRootNode);
            PhetPPath phetPPath = new PhetPPath(new Rectangle2D.Double(0.0, 0.0, d, 65.0), new Color(237, 243, 246), new BasicStroke(2.0f), Color.BLACK);
            this.spectrumRootNode.addChild(phetPPath);
            for (n = 4; n <= 20; ++n) {
                bl = n % 2 == 0;
                this.addFrequencyTickMark(Math.pow(10.0, n), bl);
            }
            for (n = -12; n <= 4; ++n) {
                bl = n % 2 == 0;
                this.addWavelengthTickMark(Math.pow(10.0, n), bl);
            }
            this.addBandLabel(1000.0, 1.0E9, MoleculesAndLightResources.getString("SpectrumWindow.radioBandLabel"));
            this.addBandDivider(1.0E9);
            this.addBandLabel(1.0E9, 3.0E11, MoleculesAndLightResources.getString("SpectrumWindow.microwaveBandLabel"));
            this.addBandDivider(3.0E11);
            this.addBandLabel(3.0E11, 6.0E14, MoleculesAndLightResources.getString("SpectrumWindow.infraredBandLabel"));
            this.addBandLabel(1.0E15, 8.0E15, MoleculesAndLightResources.getString("SpectrumWindow.ultravioletBandLabel"));
            this.addBandDivider(1.0E16);
            this.addBandLabel(1.0E16, 1.0E19, MoleculesAndLightResources.getString("SpectrumWindow.xrayBandLabel"));
            this.addBandDivider(1.0E19);
            this.addBandLabel(1.0E19, 1.0E21, MoleculesAndLightResources.getString("SpectrumWindow.gammaRayBandLabel"));
            n = (int)Math.round(this.getOffsetFromFrequency(7.9E14) - this.getOffsetFromFrequency(4.0E14));
            Image image = new SpectrumImageFactory.ExponentialGrowthSpectrumImageFactory().createHorizontalSpectrum(n, 65);
            BufferedImage bufferedImage = BufferedImageUtils.flipX(BufferedImageUtils.toBufferedImage(image));
            PImage pImage = new PImage(bufferedImage);
            pImage.setOffset(this.getOffsetFromFrequency(4.0E14), 0.0);
            this.spectrumRootNode.addChild(pImage);
            PText pText = new PText(MoleculesAndLightResources.getString("SpectrumWindow.visibleBandLabel"));
            pText.setFont(LABEL_FONT);
            double d2 = pImage.getFullBounds().getCenterX();
            pText.setOffset(d2 - pText.getFullBoundsReference().width / 2.0, -50.0);
            this.spectrumRootNode.addChild(pText);
            ArrowNode arrowNode = new ArrowNode(new Point2D.Double(d2, pText.getFullBoundsReference().getMaxY()), new Point2D.Double(d2, 0.0), 7.0, 7.0, 2.0);
            arrowNode.setPaint(Color.BLACK);
            this.spectrumRootNode.addChild(arrowNode);
            PText pText2 = new PText(MoleculesAndLightResources.getString("SpectrumWindow.cyclesPerSecondUnits"));
            pText2.setFont(LABEL_FONT);
            pText2.setOffset(this.stripWidth, -8.0 - pText2.getFullBoundsReference().getHeight());
            this.spectrumRootNode.addChild(pText2);
            PText pText3 = new PText(MoleculesAndLightResources.getString("SpectrumWindow.metersUnits"));
            pText3.setFont(LABEL_FONT);
            pText3.setOffset(this.stripWidth, 78.0);
            this.spectrumRootNode.addChild(pText3);
            this.spectrumRootNode.setOffset(Math.max(-this.spectrumRootNode.getFullBoundsReference().getMinX(), 0.0), Math.max(-this.spectrumRootNode.getFullBoundsReference().getMinY(), 0.0));
        }

        private double getOffsetFromFrequency(double d) {
            assert (d >= 1000.0 && d <= 1.0E21);
            double d2 = Math.log10(1.0E21) - Math.log10(1000.0);
            double d3 = Math.log10(d);
            return (d3 - Math.log10(1000.0)) / d2 * this.stripWidth;
        }

        private double getOffsetFromWavelength(double d) {
            return this.getOffsetFromFrequency(2.99792458E8 / d);
        }

        private void addFrequencyTickMark(double d, boolean bl) {
            DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath();
            doubleGeneralPath.moveTo(0.0, 0.0);
            doubleGeneralPath.lineTo(0.0, -8.0);
            PhetPPath phetPPath = new PhetPPath(doubleGeneralPath.getGeneralPath(), TICK_MARK_STROKE, (Paint)Color.BLACK);
            phetPPath.setOffset(this.getOffsetFromFrequency(d), 0.0);
            this.spectrumRootNode.addChild(phetPPath);
            if (bl) {
                PNode pNode = this.createExponentialLabel(d);
                pNode.setOffset(phetPPath.getFullBoundsReference().getCenterX() - pNode.getFullBoundsReference().width / 2.0, phetPPath.getFullBoundsReference().getMinY() - pNode.getFullBoundsReference().height);
                this.spectrumRootNode.addChild(pNode);
            }
        }

        private void addWavelengthTickMark(double d, boolean bl) {
            DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath();
            doubleGeneralPath.moveTo(0.0, 0.0);
            doubleGeneralPath.lineTo(0.0, 8.0);
            PhetPPath phetPPath = new PhetPPath(doubleGeneralPath.getGeneralPath(), TICK_MARK_STROKE, (Paint)Color.BLACK);
            phetPPath.setOffset(this.getOffsetFromWavelength(d), 65.0);
            this.spectrumRootNode.addChild(phetPPath);
            if (bl) {
                PNode pNode = this.createExponentialLabel(d);
                pNode.setOffset(phetPPath.getFullBoundsReference().getCenterX() - pNode.getFullBoundsReference().width / 2.0, phetPPath.getFullBoundsReference().getMaxY());
                this.spectrumRootNode.addChild(pNode);
            }
        }

        private PNode createExponentialLabel(double d) {
            int n = (int)Math.round(Math.log10(d));
            HTMLNode hTMLNode = new HTMLNode("<html>10<sup>" + n + "</sup></html>");
            hTMLNode.setFont(TICK_MARK_FONT);
            return hTMLNode;
        }

        private void addBandDivider(double d) {
            DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath();
            doubleGeneralPath.moveTo(0.0, 0.0);
            doubleGeneralPath.lineTo(0.0, 65.0);
            PhetPPath phetPPath = new PhetPPath(doubleGeneralPath.getGeneralPath(), BAND_DIVIDER_STROKE, (Paint)Color.BLACK);
            phetPPath.setOffset(this.getOffsetFromFrequency(d), 0.0);
            this.spectrumRootNode.addChild(phetPPath);
        }

        private void addBandLabel(double d, double d2, String string) {
            assert (d2 >= d);
            double d3 = this.getOffsetFromFrequency(d);
            double d4 = this.getOffsetFromFrequency(d2);
            double d5 = d4 - d3;
            double d6 = d3 + d5 / 2.0;
            HTMLNode hTMLNode = new HTMLNode(string);
            hTMLNode.setFont(LABEL_FONT);
            if (hTMLNode.getFullBoundsReference().width > d5) {
                hTMLNode.setScale(d5 / hTMLNode.getFullBoundsReference().width);
            }
            hTMLNode.setOffset(d6 - hTMLNode.getFullBoundsReference().width / 2.0, 32.5 - hTMLNode.getFullBoundsReference().height / 2.0);
            this.spectrumRootNode.addChild(hTMLNode);
        }
    }

    private static class SpectrumDiagram
    extends PNode {
        private static final Dimension OVERALL_DIMENSIONS = new Dimension(690, 440);

        public SpectrumDiagram() {
            PText pText = new PText(MoleculesAndLightResources.getString("SpectrumWindow.title"));
            pText.setFont(new PhetFont(30));
            pText.setOffset(OVERALL_DIMENSIONS.getWidth() / 2.0 - pText.getFullBoundsReference().width / 2.0, 10.0);
            this.addChild(pText);
            LabeledArrow labeledArrow = new LabeledArrow(OVERALL_DIMENSIONS.getWidth() - 60.0, LabeledArrow.Orientation.POINTING_RIGHT, MoleculesAndLightResources.getString("SpectrumWindow.frequencyArrowLabel"), new Color(225, 142, 255), Color.WHITE);
            labeledArrow.setOffset(30.0, pText.getFullBoundsReference().getMaxY() + 25.0);
            this.addChild(labeledArrow);
            LabeledSpectrumNode labeledSpectrumNode = new LabeledSpectrumNode((double)SpectrumDiagram.OVERALL_DIMENSIONS.width - 60.0);
            labeledSpectrumNode.setOffset(30.0, labeledArrow.getFullBoundsReference().getMaxY() + 10.0);
            this.addChild(labeledSpectrumNode);
            LabeledArrow labeledArrow2 = new LabeledArrow(OVERALL_DIMENSIONS.getWidth() - 60.0, LabeledArrow.Orientation.POINTING_LEFT, MoleculesAndLightResources.getString("SpectrumWindow.wavelengthArrowLabel"), Color.WHITE, new Color(235, 129, 98));
            labeledArrow2.setOffset(30.0, labeledSpectrumNode.getFullBoundsReference().getMaxY() + 15.0);
            this.addChild(labeledArrow2);
            ChirpNode chirpNode = new ChirpNode((double)SpectrumDiagram.OVERALL_DIMENSIONS.width - 60.0);
            chirpNode.setOffset(30.0, labeledArrow2.getFullBoundsReference().getMaxY() + 20.0);
            this.addChild(chirpNode);
        }
    }
}

