/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculesandlight.view;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.photonabsorption.model.PhotonAbsorptionModel;
import edu.colorado.phet.common.photonabsorption.view.PhotonNode;
import edu.colorado.phet.common.piccolophet.nodes.ArrowNode;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.moleculesandlight.MoleculesAndLightResources;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;

public class QuadEmissionFrequencyControlPanel
extends PNode {
    private static final Color BACKGROUND_COLOR = new Color(185, 178, 95);
    private static final Dimension PANEL_SIZE = new Dimension(850, 150);

    public QuadEmissionFrequencyControlPanel(PhotonAbsorptionModel photonAbsorptionModel) {
        final PhetPPath phetPPath = new PhetPPath((Shape)new RoundRectangle2D.Double(0.0, 0.0, PANEL_SIZE.getWidth(), PANEL_SIZE.getHeight(), 20.0, 20.0), (Paint)BACKGROUND_COLOR);
        WavelengthSelectButtonNode wavelengthSelectButtonNode = new WavelengthSelectButtonNode(MoleculesAndLightResources.getString("QuadWavelengthSelector.Microwave"), photonAbsorptionModel, 20.0);
        WavelengthSelectButtonNode wavelengthSelectButtonNode2 = new WavelengthSelectButtonNode(MoleculesAndLightResources.getString("QuadWavelengthSelector.Infrared"), photonAbsorptionModel, 8.5E-7);
        WavelengthSelectButtonNode wavelengthSelectButtonNode3 = new WavelengthSelectButtonNode(MoleculesAndLightResources.getString("QuadWavelengthSelector.Visible"), photonAbsorptionModel, 5.8E-7);
        WavelengthSelectButtonNode wavelengthSelectButtonNode4 = new WavelengthSelectButtonNode(MoleculesAndLightResources.getString("QuadWavelengthSelector.Ultraviolet"), photonAbsorptionModel, 1.0E-7);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(wavelengthSelectButtonNode.getButton());
        buttonGroup.add(wavelengthSelectButtonNode2.getButton());
        buttonGroup.add(wavelengthSelectButtonNode3.getButton());
        buttonGroup.add(wavelengthSelectButtonNode4.getButton());
        PNode pNode = new PNode();
        double d = (PANEL_SIZE.getWidth() - wavelengthSelectButtonNode.getFullBoundsReference().width - wavelengthSelectButtonNode2.getFullBoundsReference().width - wavelengthSelectButtonNode3.getFullBoundsReference().width - wavelengthSelectButtonNode4.getFullBoundsReference().width) / 5.0;
        d = Math.max(d, 0.0);
        wavelengthSelectButtonNode.setOffset(d, 0.0);
        pNode.addChild(wavelengthSelectButtonNode);
        wavelengthSelectButtonNode2.setOffset(wavelengthSelectButtonNode.getFullBoundsReference().getMaxX() + d, 0.0);
        pNode.addChild(wavelengthSelectButtonNode2);
        wavelengthSelectButtonNode3.setOffset(wavelengthSelectButtonNode2.getFullBoundsReference().getMaxX() + d, 0.0);
        pNode.addChild(wavelengthSelectButtonNode3);
        wavelengthSelectButtonNode4.setOffset(wavelengthSelectButtonNode3.getFullBoundsReference().getMaxX() + d, 0.0);
        pNode.addChild(wavelengthSelectButtonNode4);
        pNode.setOffset(0.0, 10.0);
        EnergyArrow energyArrow = new EnergyArrow(MoleculesAndLightResources.getString("QuadWavelengthSelector.HigherEnergy"), photonAbsorptionModel){
            {
                super(string, photonAbsorptionModel);
                this.centerFullBoundsOnPoint(phetPPath.getFullBoundsReference().getCenterX(), PANEL_SIZE.getHeight() - this.getFullBoundsReference().height / 2.0 - 10.0);
            }
        };
        phetPPath.addChild(energyArrow);
        this.addChild(phetPPath);
        phetPPath.addChild(pNode);
    }

    private static class EnergyArrow
    extends PNode {
        private static final Paint ARROW_COLOR = Color.BLACK;

        public EnergyArrow(String string, PhotonAbsorptionModel photonAbsorptionModel) {
            Point2D.Double double_ = new Point2D.Double(250.0, 0.0);
            Point2D.Double double_2 = new Point2D.Double(0.0, 0.0);
            ArrowNode arrowNode = new ArrowNode(double_2, double_, 15.0, 15.0, 2.0){
                {
                    this.setPaint(ARROW_COLOR);
                    this.setStroke(new BasicStroke(3.0f));
                }
            };
            this.addChild(arrowNode);
            HTMLNode hTMLNode = new HTMLNode(string);
            hTMLNode.setFont(new PhetFont(20, true));
            hTMLNode.setOffset(arrowNode.getFullBoundsReference().getCenterX() - hTMLNode.getFullBoundsReference().width / 2.0, arrowNode.getFullBoundsReference().getMaxY());
            this.addChild(hTMLNode);
        }
    }

    private static class WavelengthSelectButtonNode
    extends PNode {
        private static final Font LABEL_FONT = new PhetFont(16);
        JRadioButton button;

        public WavelengthSelectButtonNode(final String string, final PhotonAbsorptionModel photonAbsorptionModel, final double d) {
            this.button = new JRadioButton(){
                {
                    this.setFont(LABEL_FONT);
                    this.setText(string);
                    this.setBackground(BACKGROUND_COLOR);
                    this.setOpaque(false);
                    this.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            photonAbsorptionModel.setEmittedPhotonWavelength(d);
                        }
                    });
                    photonAbsorptionModel.addListener(new PhotonAbsorptionModel.Adapter(){

                        public void emittedPhotonWavelengthChanged() {
                            this.setSelected(photonAbsorptionModel.getEmittedPhotonWavelength() == d);
                        }
                    });
                    this.setSelected(photonAbsorptionModel.getEmittedPhotonWavelength() == d);
                }
            };
            PSwing pSwing = new PSwing(this.button){
                {
                    this.setScale(1.5);
                }
            };
            this.addChild(pSwing);
            PhotonNode photonNode = new PhotonNode(d);
            photonNode.addInputEventListener(new PBasicInputEventHandler(){

                public void mouseClicked(PInputEvent pInputEvent) {
                    photonAbsorptionModel.setEmittedPhotonWavelength(d);
                }
            });
            this.addChild(photonNode);
            photonNode.setOffset(pSwing.getFullBoundsReference().width / 2.0, photonNode.getFullBoundsReference().height / 2.0);
            pSwing.setOffset(0.0, photonNode.getFullBoundsReference().height * 0.6);
        }

        public JRadioButton getButton() {
            return this.button;
        }
    }
}

