/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.photonabsorption.model;

import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.photonabsorption.model.Molecule;
import edu.colorado.phet.common.photonabsorption.model.Photon;
import java.util.Random;

public abstract class PhotonAbsorptionStrategy {
    private static final Random RAND = new Random();
    public static final Property<Double> photonAbsorptionProbability = new Property<Double>(0.5);
    private final Molecule molecule;
    protected Photon absorbedPhoton;
    protected boolean isPhotonAbsorbed = false;
    protected double photonHoldCountdownTime = 0.0;

    public PhotonAbsorptionStrategy(Molecule molecule) {
        this.molecule = molecule;
    }

    protected Molecule getMolecule() {
        return this.molecule;
    }

    public abstract void stepInTime(double var1);

    public void reset() {
        this.absorbedPhoton = null;
        this.isPhotonAbsorbed = false;
        this.photonHoldCountdownTime = 0.0;
    }

    public boolean queryAndAbsorbPhoton(Photon photon) {
        boolean bl;
        boolean bl2 = bl = !this.isPhotonAbsorbed && RAND.nextDouble() < photonAbsorptionProbability.getValue();
        if (bl) {
            this.isPhotonAbsorbed = true;
            this.photonHoldCountdownTime = 600.0 + RAND.nextDouble() * 600.0;
        }
        return bl;
    }

    public static class BreakApartStrategy
    extends PhotonAbsorptionStrategy {
        public BreakApartStrategy(Molecule molecule) {
            super(molecule);
        }

        public void stepInTime(double d) {
            this.getMolecule().breakApart();
            this.getMolecule().setActiveStrategy(new NullPhotonAbsorptionStrategy(this.getMolecule()));
        }
    }

    public static class ExcitationStrategy
    extends PhotonHoldStrategy {
        public ExcitationStrategy(Molecule molecule) {
            super(molecule);
        }

        protected void photonAbsorbed() {
            this.getMolecule().setHighElectronicEnergyState(true);
        }

        protected void reemitPhoton() {
            super.reemitPhoton();
            this.getMolecule().setHighElectronicEnergyState(false);
        }
    }

    public static class NullPhotonAbsorptionStrategy
    extends PhotonAbsorptionStrategy {
        public NullPhotonAbsorptionStrategy(Molecule molecule) {
            super(molecule);
        }

        public void stepInTime(double d) {
        }

        public boolean queryAndAbsorbPhoton(Photon photon) {
            return false;
        }
    }

    public static abstract class PhotonHoldStrategy
    extends PhotonAbsorptionStrategy {
        private double absorbedWavelength;

        public PhotonHoldStrategy(Molecule molecule) {
            super(molecule);
        }

        public void stepInTime(double d) {
            this.photonHoldCountdownTime -= d;
            if (this.photonHoldCountdownTime <= 0.0) {
                this.reemitPhoton();
            }
        }

        protected void reemitPhoton() {
            this.getMolecule().emitPhoton(this.absorbedWavelength);
            this.getMolecule().setActiveStrategy(new NullPhotonAbsorptionStrategy(this.getMolecule()));
            this.isPhotonAbsorbed = false;
        }

        public boolean queryAndAbsorbPhoton(Photon photon) {
            boolean bl = super.queryAndAbsorbPhoton(photon);
            if (bl) {
                this.absorbedWavelength = photon.getWavelength();
                this.photonAbsorbed();
            }
            return bl;
        }

        protected abstract void photonAbsorbed();
    }

    public static class RotationStrategy
    extends PhotonHoldStrategy {
        public RotationStrategy(Molecule molecule) {
            super(molecule);
        }

        protected void photonAbsorbed() {
            this.getMolecule().setRotationDirectionClockwise(RAND.nextBoolean());
            this.getMolecule().setRotating(true);
        }

        protected void reemitPhoton() {
            super.reemitPhoton();
            this.getMolecule().setRotating(false);
        }
    }

    public static class VibrationStrategy
    extends PhotonHoldStrategy {
        public VibrationStrategy(Molecule molecule) {
            super(molecule);
        }

        protected void photonAbsorbed() {
            this.getMolecule().setVibrating(true);
        }

        protected void reemitPhoton() {
            super.reemitPhoton();
            this.getMolecule().setVibrating(false);
            this.getMolecule().setVibration(0.0);
        }
    }
}

