/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.model.property;

import edu.colorado.phet.common.phetcommon.util.SimpleObservable;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction2;
import edu.colorado.phet.common.phetcommon.util.logging.LoggingUtils;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObservableProperty<T>
extends SimpleObservable {
    private static final Logger LOGGER = LoggingUtils.getLogger(ObservableProperty.class.getCanonicalName());
    private final ArrayList<VoidFunction1<T>> newValueObservers = new ArrayList();
    private final ArrayList<VoidFunction2<T, T>> newAndOldValueObservers = new ArrayList();

    public void addObserver(SimpleObserver simpleObserver, boolean bl) {
        super.addObserver(simpleObserver);
        if (bl) {
            simpleObserver.update();
        }
    }

    protected void notifyObservers(T t, T t2) {
        super.notifyObservers();
        this.notifyNewValueObservers(t);
        this.notifyNewAndOldValueObservers(t, t2);
    }

    private void notifyNewValueObservers(T t) {
        for (VoidFunction1<T> voidFunction1 : new ArrayList<VoidFunction1<T>>(this.newValueObservers)) {
            voidFunction1.apply(t);
        }
    }

    private void notifyNewAndOldValueObservers(T t, T t2) {
        for (VoidFunction2<T, T> voidFunction2 : new ArrayList<VoidFunction2<T, T>>(this.newAndOldValueObservers)) {
            voidFunction2.apply(t, t2);
        }
    }

    @Override
    public void addObserver(SimpleObserver simpleObserver) {
        this.addObserver(simpleObserver, true);
    }

    public abstract T getValue();

    @Override
    public String toString() {
        return this.getValue().toString();
    }

    static {
        LOGGER.setLevel(Level.INFO);
    }
}

