/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferUtils;

final class APIUtil {
    private static final ThreadLocal<char[]> arrayTL = new ThreadLocal<char[]>(){

        @Override
        protected char[] initialValue() {
            return new char[256];
        }
    };
    private static final ThreadLocal<ByteBuffer> bufferTL = new ThreadLocal<ByteBuffer>(){

        @Override
        protected ByteBuffer initialValue() {
            return BufferUtils.createByteBuffer(256);
        }
    };
    private static final ThreadLocal<IntBuffer> lengthsTL = new ThreadLocal<IntBuffer>(){

        @Override
        protected IntBuffer initialValue() {
            return BufferUtils.createIntBuffer(4);
        }
    };
    private static final ThreadLocal<Buffers> buffersTL = new ThreadLocal<Buffers>(){

        @Override
        protected Buffers initialValue() {
            return new Buffers();
        }
    };

    static ByteBuffer getBufferByte(int size) {
        ByteBuffer buffer = bufferTL.get();
        if (buffer.capacity() < size) {
            for (int sizeNew = buffer.capacity() << 1; sizeNew < size; sizeNew <<= 1) {
            }
            buffer = BufferUtils.createByteBuffer(size);
            bufferTL.set(buffer);
        } else {
            buffer.clear();
        }
        return buffer;
    }

    static IntBuffer getBufferInt() {
        return APIUtil.buffersTL.get().ints;
    }

    static FloatBuffer getBufferFloat() {
        return APIUtil.buffersTL.get().floats;
    }

    static DoubleBuffer getBufferDouble() {
        return APIUtil.buffersTL.get().doubles;
    }

    private static class Buffers {
        final ShortBuffer shorts = BufferUtils.createShortBuffer(32);
        final IntBuffer ints = BufferUtils.createIntBuffer(32);
        final LongBuffer longs = BufferUtils.createLongBuffer(32);
        final FloatBuffer floats = BufferUtils.createFloatBuffer(32);
        final DoubleBuffer doubles = BufferUtils.createDoubleBuffer(32);

        Buffers() {
        }
    }
}

