/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculeshapes.view;

import edu.colorado.phet.common.phetcommon.math.Matrix3F;
import edu.colorado.phet.common.phetcommon.math.Matrix4F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3D;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.lwjglphet.GLOptions;
import edu.colorado.phet.lwjglphet.materials.GLMaterial;
import edu.colorado.phet.lwjglphet.nodes.GLNode;
import edu.colorado.phet.lwjglphet.shapes.ObjMesh;
import edu.colorado.phet.lwjglphet.utils.LWJGLUtils;
import edu.colorado.phet.moleculeshapes.MoleculeShapesColor;
import edu.colorado.phet.moleculeshapes.MoleculeShapesResources;
import edu.colorado.phet.moleculeshapes.model.PairGroup;
import java.io.IOException;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.Sphere;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LonePairNode
extends GLNode {
    public final PairGroup pair;
    public final Property<Vector3D> position;
    private static ObjMesh lonePairGeometry;

    public LonePairNode(PairGroup pairGroup, final PairGroup pairGroup2, final Property<Boolean> property) {
        this.pair = pairGroup;
        this.position = pairGroup.position;
        this.setRenderPass(GLOptions.RenderPass.TRANSPARENCY);
        this.requireEnabled(3042);
        this.requireEnabled(2903);
        this.requireEnabled(2884);
        this.requireEnabled(2896);
        property.addObserver(new SimpleObserver(){

            public void update() {
                LonePairNode.this.setVisible((Boolean)property.get());
            }
        });
        this.addChild(new ElectronDotNode(new Vector3F(0.3f, 0.0f, 0.0f)));
        this.addChild(new ElectronDotNode(new Vector3F(-0.3f, 0.0f, 0.0f)));
        GLNode gLNode = LonePairNode.getGeometry();
        gLNode.setRenderPass(GLOptions.RenderPass.TRANSPARENCY);
        this.addChild(gLNode);
        gLNode.setMaterial(new GLMaterial(){

            public void before(GLOptions gLOptions) {
                super.before(gLOptions);
                GL11.glColorMaterial(1028, 4609);
                LWJGLUtils.color4f(MoleculeShapesColor.LONE_PAIR_SHELL.get());
            }
        });
        this.position.addObserver(new SimpleObserver(){

            public void update() {
                Vector3D vector3D = Vector3D.Y_UNIT;
                Vector3D vector3D2 = LonePairNode.this.position.get().minus(pairGroup2.position.get());
                Vector3D vector3D3 = vector3D2.normalized();
                Matrix3F matrix3F = Matrix3F.rotateAToB(vector3D.to3F(), vector3D3.to3F());
                Vector3F vector3F = vector3D2.magnitude() > 7.0 ? LonePairNode.this.position.get().minus(vector3D3.times(7.0)).to3F() : pairGroup2.position.get().to3F();
                LonePairNode.this.transform.set(Matrix4F.translation(vector3F).times(Matrix4F.fromMatrix3f(matrix3F)).times(Matrix4F.scaling(2.5f)));
            }
        });
    }

    @Override
    protected void preRender(GLOptions gLOptions) {
        super.preRender(gLOptions);
        GL11.glPushAttrib(2930);
        GL11.glDepthMask(false);
    }

    @Override
    protected void postRender(GLOptions gLOptions) {
        GL11.glPopAttrib();
        super.postRender(gLOptions);
    }

    public static ObjMesh getMesh() {
        LonePairNode.ensureMeshInitialized();
        return lonePairGeometry;
    }

    public static GLNode getGeometry() {
        LonePairNode.ensureMeshInitialized();
        return new GLNode(){
            {
                this.setRenderPass(GLOptions.RenderPass.TRANSPARENCY);
                this.requireEnabled(2977);
            }

            public void renderSelf(GLOptions gLOptions) {
                super.renderSelf(gLOptions);
                lonePairGeometry.draw();
            }
        };
    }

    private static void ensureMeshInitialized() {
        if (lonePairGeometry == null) {
            try {
                lonePairGeometry = new ObjMesh(MoleculeShapesResources.RESOURCES.getResourceAsStream("models/balloon2.obj"));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private class ElectronDotNode
    extends GLNode {
        public ElectronDotNode(Vector3F vector3F) {
            this.translate(vector3F.plus(Vector3F.Y_UNIT.times(2.0f)));
            this.setRenderPass(GLOptions.RenderPass.TRANSPARENCY);
            this.requireEnabled(2977);
        }

        public void renderSelf(GLOptions gLOptions) {
            super.renderSelf(gLOptions);
            GL11.glColorMaterial(1028, 4609);
            LWJGLUtils.color4f(MoleculeShapesColor.LONE_PAIR_ELECTRON.get());
            new Sphere().draw(0.1f, 10, 10);
        }
    }
}

