/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculeshapes.tabs;

import edu.colorado.phet.common.phetcommon.math.Matrix4F;
import edu.colorado.phet.common.phetcommon.math.PlaneF;
import edu.colorado.phet.common.phetcommon.math.QuaternionF;
import edu.colorado.phet.common.phetcommon.math.Ray3F;
import edu.colorado.phet.common.phetcommon.math.SphereF;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector4F;
import edu.colorado.phet.common.phetcommon.model.event.UpdateListener;
import edu.colorado.phet.common.phetcommon.model.event.VoidNotifier;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserActions;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction2;
import edu.colorado.phet.lwjglphet.CanvasTransform;
import edu.colorado.phet.lwjglphet.GLOptions;
import edu.colorado.phet.lwjglphet.LWJGLCanvas;
import edu.colorado.phet.lwjglphet.LWJGLTab;
import edu.colorado.phet.lwjglphet.math.LWJGLTransform;
import edu.colorado.phet.lwjglphet.nodes.GLNode;
import edu.colorado.phet.lwjglphet.nodes.GuiNode;
import edu.colorado.phet.lwjglphet.nodes.OrthoSwingNode;
import edu.colorado.phet.lwjglphet.utils.LWJGLUtils;
import edu.colorado.phet.moleculeshapes.MoleculeShapesColor;
import edu.colorado.phet.moleculeshapes.MoleculeShapesConstants;
import edu.colorado.phet.moleculeshapes.MoleculeShapesProperties;
import edu.colorado.phet.moleculeshapes.MoleculeShapesSimSharing;
import edu.colorado.phet.moleculeshapes.model.Molecule;
import edu.colorado.phet.moleculeshapes.model.PairGroup;
import edu.colorado.phet.moleculeshapes.view.AtomNode;
import edu.colorado.phet.moleculeshapes.view.LonePairNode;
import edu.colorado.phet.moleculeshapes.view.MoleculeModelNode;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MoleculeViewTab
extends LWJGLTab {
    private Property<Molecule> molecule = new Property<Object>(null);
    protected final List<OrthoSwingNode> guiNodes = new ArrayList<OrthoSwingNode>();
    public final Property<Boolean> showBondAngles = new Property<Boolean>(false);
    public final Property<Boolean> showLonePairs = new Property<Boolean>(true);
    public final Property<Boolean> showAllLonePairs = new Property<Boolean>(false);
    public final VoidNotifier mouseEventNotifier = new VoidNotifier();
    public final VoidNotifier keyboardEventNotifier = new VoidNotifier();
    public final VoidNotifier beforeFrameRender = new VoidNotifier();
    public final VoidNotifier timeChangeNotifier = new VoidNotifier();
    public final LWJGLTransform sceneProjectionTransform = new LWJGLTransform();
    public final LWJGLTransform sceneModelViewTransform = new LWJGLTransform();
    private boolean showWireframe = false;
    private Dimension stageSize;
    protected CanvasTransform canvasTransform;
    private boolean initialized = false;
    private long lastSeenTime;
    private float timeElapsed;
    public final Property<Double> framesPerSecond = new Property<Double>(0.0);
    private final LinkedList<Long> timeQueue = new LinkedList();
    public final GLNode rootNode = new GLNode();
    protected GLNode sceneLayer;
    protected GLNode readoutLayer;
    protected GLNode guiLayer;
    protected GLNode overlayLayer;
    protected MoleculeModelNode moleculeNode;
    protected volatile boolean dragging = false;
    protected volatile DragMode dragMode = DragMode.MODEL_ROTATE;
    protected volatile PairGroup draggedParticle = null;
    protected volatile boolean globalLeftMouseDown = false;
    protected volatile boolean resizeDirty = false;
    protected Property<QuaternionF> rotation = new Property<QuaternionF>(new QuaternionF());
    private FloatBuffer specular = LWJGLUtils.floatBuffer(new float[]{0.0f, 0.0f, 0.0f, 0.0f});
    private FloatBuffer shininess = LWJGLUtils.floatBuffer(new float[]{50.0f});
    private FloatBuffer sunDirection = LWJGLUtils.floatBuffer(new float[]{-1.0f, 0.5f, 2.0f, 0.0f});
    private FloatBuffer moonDirection = LWJGLUtils.floatBuffer(new float[]{2.0f, -1.0f, 1.0f, 0.0f});
    private FloatBuffer blackColor = LWJGLUtils.floatBuffer(new float[]{0.0f, 0.0f, 0.0f, 0.0f});
    private FloatBuffer sunColor = LWJGLUtils.floatBuffer(MoleculeShapesColor.SUN.get().getColorComponents(new float[4]));
    private FloatBuffer moonColor = LWJGLUtils.floatBuffer(MoleculeShapesColor.MOON.get().getColorComponents(new float[4]));
    boolean lastDragging = false;

    public MoleculeViewTab(LWJGLCanvas lWJGLCanvas, String string) {
        super(lWJGLCanvas, string);
    }

    protected void initialize() {
        if (this.initialCanvasSize == null) {
            this.initialCanvasSize = this.getCanvas().getSize();
        }
        this.stageSize = this.initialCanvasSize;
        if (Math.abs(this.stageSize.getWidth() - 1008.0) > 20.0 || Math.abs(this.stageSize.getHeight() - 676.0) > 20.0) {
            this.stageSize = new Dimension(1008, 676);
        }
        this.canvasTransform = new CanvasTransform.StageCenteringCanvasTransform(this.canvasSize, this.stageSize);
        GL11.glPolygonMode(1028, 6914);
        GL11.glPolygonMode(1029, 6914);
        GL11.glBlendFunc(770, 771);
        this.sceneLayer = new GLNode(){
            {
                this.requireEnabled(2929);
            }

            protected void preRender(GLOptions gLOptions) {
                super.preRender(gLOptions);
                MoleculeViewTab.this.loadCameraMatrices();
                MoleculeViewTab.this.loadLighting();
            }
        };
        this.readoutLayer = new GuiNode(this, false);
        this.guiLayer = new GuiNode(this);
        this.overlayLayer = new GuiNode(this);
        this.rootNode.addChild(this.sceneLayer);
        this.rootNode.addChild(this.readoutLayer);
        this.rootNode.addChild(this.guiLayer);
        this.rootNode.addChild(this.overlayLayer);
        this.keyboardEventNotifier.addUpdateListener(new UpdateListener(){

            public void update() {
                if (Keyboard.getEventKey() == 33) {
                    MoleculeViewTab.this.showWireframe = Keyboard.getEventKeyState();
                }
            }
        }, false);
        this.mouseEventNotifier.addUpdateListener(new UpdateListener(){

            public void update() {
                if (Mouse.getEventButton() == 0) {
                    if (Mouse.isButtonDown(0)) {
                        MoleculeViewTab.this.onLeftMouseDown();
                    } else {
                        MoleculeViewTab.this.onLeftMouseUp();
                    }
                } else if (MoleculeViewTab.this.allowMiddleMouseClickModifications() && Mouse.getEventButton() == 2) {
                    if (Mouse.isButtonDown(2)) {
                        PairGroup pairGroup = MoleculeViewTab.this.getElectronPairUnderPointer();
                        if (pairGroup != null && pairGroup != MoleculeViewTab.this.getMolecule().getCentralAtom()) {
                            MoleculeViewTab.this.getMolecule().removeGroup(pairGroup);
                        }
                        SimSharingManager.sendUserMessage(MoleculeShapesSimSharing.UserComponents.mouseMiddleButton, UserComponentTypes.unknown, UserActions.pressed, ParameterSet.parameterSet((IParameterKey)MoleculeShapesSimSharing.ParamKeys.removedPair, pairGroup != null));
                    }
                } else if (Mouse.getEventButton() == -1) {
                    MoleculeViewTab.this.updateCursor();
                    if (MoleculeViewTab.this.dragging) {
                        VoidFunction2<Property<QuaternionF>, Float> voidFunction2 = new VoidFunction2<Property<QuaternionF>, Float>(){

                            @Override
                            public void apply(Property<QuaternionF> property, Float f) {
                                float f2 = f.floatValue() / MoleculeViewTab.this.getApproximateScale();
                                property.set(QuaternionF.fromEulerAngles(-((float)Mouse.getEventDY() * f2), (float)Mouse.getEventDX() * f2, 0.0f).times(property.get()));
                            }
                        };
                        switch (MoleculeViewTab.this.dragMode) {
                            case MODEL_ROTATE: {
                                voidFunction2.apply(MoleculeViewTab.this.rotation, Float.valueOf(0.005f));
                                break;
                            }
                            case PAIR_FRESH_PLANAR: {
                                MoleculeViewTab.this.draggedParticle.dragToPosition(MoleculeViewTab.this.getPlanarMoleculeCursorPosition().to3D());
                                break;
                            }
                            case PAIR_EXISTING_SPHERICAL: {
                                MoleculeViewTab.this.draggedParticle.dragToPosition(MoleculeViewTab.this.getSphericalMoleculeCursorPosition(MoleculeViewTab.this.draggedParticle.position.get().to3F()).to3D());
                            }
                        }
                    }
                }
            }
        }, false);
    }

    @Override
    public void start() {
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
        this.lastSeenTime = System.currentTimeMillis();
    }

    @Override
    public void loop() {
        long l;
        Display.sync(MoleculeShapesConstants.FRAMES_PER_SECOND_LIMIT.get());
        int n = 10;
        long l2 = System.currentTimeMillis();
        this.timeQueue.add(l2);
        if (this.timeQueue.size() == n + 1) {
            l = this.timeQueue.poll();
            this.framesPerSecond.set(Double.valueOf(1000.0f * (float)n / (float)(l2 - l)));
        }
        l = System.currentTimeMillis();
        this.timeElapsed = Math.min(1000.0f / (float)MoleculeShapesConstants.FRAMES_PER_SECOND_LIMIT.get().intValue(), (float)(l - this.lastSeenTime) / 1000.0f);
        this.lastSeenTime = l;
        this.timeChangeNotifier.updateListeners();
        while (Mouse.next()) {
            this.mouseEventNotifier.updateListeners();
        }
        while (Keyboard.next()) {
            this.keyboardEventNotifier.updateListeners();
        }
        this.updateState(this.timeElapsed);
        this.loadCameraMatrices();
        this.beforeFrameRender.updateListeners();
        LWJGLUtils.clearColor(MoleculeShapesColor.handler.get(MoleculeShapesColor.BACKGROUND));
        GL11.glClear(16640);
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
        GLOptions gLOptions = new GLOptions();
        if (this.showWireframe) {
            gLOptions.forWireframe = true;
            GL11.glPolygonMode(1032, 6913);
        } else {
            GL11.glPolygonMode(1032, 6914);
        }
        GL11.glViewport(0, 0, this.getCanvasWidth(), this.getCanvasHeight());
        this.setupGuiTransformations();
        gLOptions.renderPass = GLOptions.RenderPass.REGULAR;
        this.rootNode.render(gLOptions);
        gLOptions.renderPass = GLOptions.RenderPass.TRANSPARENCY;
        this.rootNode.render(gLOptions);
        Display.update();
    }

    public abstract void updateState(float var1);

    @Override
    public void stop() {
    }

    public Vector2D getScale() {
        return new Vector2D(this.getCanvasSize().getWidth() / this.getStageSize().getWidth(), this.getCanvasSize().getHeight() / this.getStageSize().getHeight());
    }

    public float getApproximateScale() {
        Vector2D vector2D = this.getScale();
        return (float)((vector2D.getX() + vector2D.getY()) / 2.0);
    }

    public Molecule getMolecule() {
        return this.molecule.get();
    }

    public void setMolecule(Molecule molecule) {
        this.molecule.set(molecule);
    }

    public Property<Molecule> getMoleculeProperty() {
        return this.molecule;
    }

    public Dimension getStageSize() {
        return this.stageSize;
    }

    public void loadCameraMatrices() {
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        this.sceneProjectionTransform.set(this.getSceneProjectionMatrix());
        this.sceneProjectionTransform.apply();
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
        this.sceneModelViewTransform.set(this.getSceneModelViewMatrix());
        this.sceneModelViewTransform.apply();
    }

    public Matrix4F getGluPerspective(float f, float f2, float f3, float f4) {
        float f5 = (float)Math.cos(f) / (float)Math.sin(f);
        return Matrix4F.rowMajor(f5 / f2, 0.0f, 0.0f, 0.0f, 0.0f, f5, 0.0f, 0.0f, 0.0f, 0.0f, (f4 + f3) / (f3 - f4), 2.0f * f4 * f3 / (f3 - f4), 0.0f, 0.0f, -1.0f, 0.0f);
    }

    public Matrix4F getSceneProjectionMatrix() {
        float f = 0.38397244f;
        float f2 = (float)Math.atan((double)this.canvasTransform.getFieldOfViewYFactor() * Math.tan(f));
        Matrix4F matrix4F = this.getGluPerspective(f2, (float)((Dimension)this.canvasSize.get()).width / (float)((Dimension)this.canvasSize.get()).height, 1.0f, 1000.0f);
        return matrix4F;
    }

    public Matrix4F getSceneModelViewMatrix() {
        return Matrix4F.translation(0.0f, 0.0f, -40.0f);
    }

    protected void onLeftMouseDown() {
        boolean bl;
        boolean bl2 = bl = this.getGuiUnder(Mouse.getEventX(), Mouse.getEventY()) != null;
        if (!bl) {
            this.dragging = true;
            PairGroup pairGroup = this.getElectronPairUnderPointer();
            if (pairGroup != null) {
                this.dragMode = DragMode.PAIR_EXISTING_SPHERICAL;
                this.draggedParticle = pairGroup;
                pairGroup.userControlled.set(true);
            } else {
                this.dragMode = DragMode.MODEL_ROTATE;
            }
            this.draggingChanged();
        }
    }

    protected void onLeftMouseUp() {
        this.dragging = false;
        if (this.dragMode == DragMode.PAIR_FRESH_PLANAR || this.dragMode == DragMode.PAIR_EXISTING_SPHERICAL) {
            this.draggedParticle.userControlled.set(false);
        }
        this.draggingChanged();
    }

    protected void loadLighting() {
        GL11.glMaterial(1028, 4610, this.specular);
        GL11.glLight(16384, 4611, this.sunDirection);
        GL11.glLight(16384, 4609, this.sunColor);
        GL11.glLight(16384, 4608, this.blackColor);
        GL11.glLight(16384, 4610, this.blackColor);
        GL11.glLight(16385, 4611, this.moonDirection);
        GL11.glLight(16385, 4609, this.moonColor);
        GL11.glLight(16385, 4608, this.blackColor);
        GL11.glLight(16385, 4610, this.blackColor);
        GL11.glLightModel(2899, this.blackColor);
        GL11.glEnable(16384);
        GL11.glEnable(16385);
    }

    public Ray3F getCameraRay(int n, int n2) {
        Vector3F vector3F = new Vector3F((float)(2 * n) / (float)this.getCanvasWidth() - 1.0f, (float)(2 * n2) / (float)this.getCanvasHeight() - 1.0f, 1.0f);
        Vector3F vector3F2 = this.sceneProjectionTransform.getInverse().times(vector3F);
        Vector3F vector3F3 = this.sceneModelViewTransform.getInverse().times(vector3F2);
        Vector3F vector3F4 = this.sceneModelViewTransform.getInverse().times(vector3F2.times(2.0f));
        return new Ray3F(vector3F3, vector3F4.minus(vector3F3));
    }

    public Vector2F getScreenCoordinatesFromViewPoint(Vector3F vector3F) {
        Vector4F vector4F = this.sceneProjectionTransform.getMatrix().times(this.sceneModelViewTransform.getMatrix().times(new Vector4F(vector3F)));
        float f = 1.0f / vector4F.w;
        float f2 = vector4F.x * f;
        float f3 = vector4F.y * f;
        float f4 = vector4F.z * f;
        return this.getScreenCoordinatesFromNormalizedDeviceCoordinates(new Vector3F(f2, f3, f4));
    }

    public Vector2F getScreenCoordinatesFromNormalizedDeviceCoordinates(Vector3F vector3F) {
        return new Vector2F((vector3F.x + 1.0f) * (float)this.getCanvasWidth() / 2.0f, (vector3F.y + 1.0f) * (float)this.getCanvasHeight() / 2.0f);
    }

    public Vector3F getPlanarMoleculeCursorPosition() {
        Ray3F ray3F = this.getCameraRay(Mouse.getEventX(), Mouse.getEventY());
        Vector3F vector3F = PlaneF.XY.intersectWithRay(ray3F);
        Vector3F vector3F2 = new Vector3F(vector3F.x, vector3F.y, 0.0f);
        return this.moleculeNode.transform.inverseDelta(vector3F2);
    }

    public Vector3F getSphericalMoleculeCursorPosition(Vector3F vector3F) {
        float f;
        boolean bl;
        boolean bl2 = bl = this.moleculeNode.transform.getInverse().times((Vector3F)vector3F).z >= 0.0f;
        if (!MoleculeShapesProperties.allowDraggingBehind.get().booleanValue()) {
            bl = true;
        }
        Ray3F ray3F = this.moleculeNode.transform.inverseRay(this.getCameraRay(Mouse.getEventX(), Mouse.getEventY()));
        Vector3F vector3F2 = ray3F.pos;
        Vector3F vector3F3 = ray3F.dir;
        float f2 = (float)this.getMolecule().getIdealDistanceFromCenter(this.draggedParticle);
        SphereF sphereF = new SphereF(Vector3F.ZERO, f2);
        List<SphereF.SphereIntersectionResult> list = sphereF.intersections(ray3F, f = 1.0E-6f);
        if (list.isEmpty()) {
            float f3 = vector3F2.distance(Vector3F.ZERO);
            float f4 = f3 / f2;
            float f5 = 1.0f / f4;
            float f6 = (float)(Math.sqrt(f4 * f4 - 1.0f) / (double)f4);
            Vector3F vector3F4 = vector3F2.normalized();
            float f7 = -vector3F2.magnitude() / vector3F4.dot(vector3F3);
            Vector3F vector3F5 = vector3F2.plus(vector3F3.times(f7)).normalized();
            Vector3F vector3F6 = vector3F5.times(f6).plus(vector3F4.times(f5));
            return vector3F6.times(f2);
        }
        return bl ? list.get(0).getHitPoint() : list.get(1).getHitPoint();
    }

    protected PairGroup getElectronPairForTarget(GLNode gLNode) {
        boolean bl = gLNode instanceof AtomNode;
        boolean bl2 = gLNode instanceof LonePairNode;
        if (bl) {
            return ((AtomNode)gLNode).pair;
        }
        if (bl2) {
            if (gLNode.isVisible()) {
                return ((LonePairNode)gLNode).pair;
            }
            return null;
        }
        if (gLNode.getParent() != null) {
            return this.getElectronPairForTarget(gLNode.getParent());
        }
        return null;
    }

    public PairGroup getElectronPairUnderPointer() {
        PairGroup pairGroup;
        GLNode gLNode = this.moleculeNode.intersect(this.getCameraRay(Mouse.getEventX(), Mouse.getEventY()));
        if (gLNode != null && (pairGroup = this.getElectronPairForTarget(gLNode)) != null) {
            if (!this.isRealTab()) {
                return pairGroup;
            }
            if (pairGroup != this.getMolecule().getCentralAtom() && !this.getMolecule().getDistantLonePairs().contains(pairGroup)) {
                return pairGroup;
            }
        }
        return null;
    }

    public OrthoSwingNode getGuiUnder(int n, int n2) {
        for (OrthoSwingNode orthoSwingNode : this.guiNodes) {
            if (!this.isGuiUnder(orthoSwingNode, n, n2)) continue;
            return orthoSwingNode;
        }
        return null;
    }

    public boolean isGuiUnder(OrthoSwingNode orthoSwingNode, int n, int n2) {
        Vector2F vector2F = new Vector2F(n, n2);
        if (orthoSwingNode.isReady()) {
            Vector2F vector2F2 = orthoSwingNode.screentoComponentCoordinates(vector2F);
            if (orthoSwingNode.getComponent().contains((int)vector2F2.x, (int)vector2F2.y)) {
                return true;
            }
        }
        return false;
    }

    protected void updateCursor() {
        final LWJGLCanvas lWJGLCanvas = this.getCanvas();
        PairGroup pairGroup = this.getElectronPairUnderPointer();
        final OrthoSwingNode orthoSwingNode = this.getGuiUnder(Mouse.getEventX(), Mouse.getEventY());
        final boolean bl = this.dragging && (this.dragMode == DragMode.MODEL_ROTATE || this.dragMode == DragMode.REAL_MOLECULE_ROTATE);
        final boolean bl2 = pairGroup != null || this.dragging;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Component component;
                Component component2 = component = orthoSwingNode == null ? null : orthoSwingNode.getComponentAt(Mouse.getX(), Mouse.getY());
                if (bl) {
                    lWJGLCanvas.setCursor(Cursor.getPredefinedCursor(MoleculeShapesProperties.useRotationCursor.get() != false ? 13 : 0));
                } else if (bl2) {
                    lWJGLCanvas.setCursor(Cursor.getPredefinedCursor(12));
                } else if (component != null) {
                    lWJGLCanvas.setCursor(component.getCursor());
                } else {
                    lWJGLCanvas.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
    }

    protected void draggingChanged() {
        if (this.lastDragging != this.dragging) {
            SimSharingManager.sendUserMessage(MoleculeShapesSimSharing.UserComponents.draggingState, UserComponentTypes.unknown, UserActions.changed, ParameterSet.parameterSet((IParameterKey)MoleculeShapesSimSharing.ParamKeys.dragging, this.dragging).with((IParameterKey)MoleculeShapesSimSharing.ParamKeys.dragMode, this.dragMode.toString()));
        }
        this.lastDragging = this.dragging;
    }

    public boolean allowTogglingLonePairs() {
        return true;
    }

    public boolean allowTogglingAllLonePairs() {
        return true;
    }

    public boolean allowMiddleMouseClickModifications() {
        return true;
    }

    public abstract boolean isRealTab();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DragMode
    extends Enum<DragMode> {
        public static final /* enum */ DragMode MODEL_ROTATE = new DragMode();
        public static final /* enum */ DragMode PAIR_FRESH_PLANAR = new DragMode();
        public static final /* enum */ DragMode PAIR_EXISTING_SPHERICAL = new DragMode();
        public static final /* enum */ DragMode REAL_MOLECULE_ROTATE = new DragMode();
        private static final /* synthetic */ DragMode[] $VALUES;

        public static DragMode[] values() {
            return (DragMode[])$VALUES.clone();
        }

        static {
            $VALUES = new DragMode[]{MODEL_ROTATE, PAIR_FRESH_PLANAR, PAIR_EXISTING_SPHERICAL, REAL_MOLECULE_ROTATE};
        }
    }
}

