/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculeshapes.model;

import edu.colorado.phet.chemistry.model.Atom;
import edu.colorado.phet.chemistry.model.Element;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3D;
import edu.colorado.phet.common.phetcommon.util.Option;
import edu.colorado.phet.moleculeshapes.model.Atom3D;
import edu.colorado.phet.moleculeshapes.model.AttractorModel;
import edu.colorado.phet.moleculeshapes.model.Bond;
import edu.colorado.phet.moleculeshapes.model.LocalShape;
import edu.colorado.phet.moleculeshapes.model.Molecule;
import edu.colorado.phet.moleculeshapes.model.PairGroup;
import edu.colorado.phet.moleculeshapes.model.RealMoleculeShape;
import edu.colorado.phet.moleculeshapes.model.RealPairGroup;
import edu.colorado.phet.moleculeshapes.model.VseprConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RealMolecule
extends Molecule {
    private final RealMoleculeShape realMolecule;
    private Set<Element> elementsUsed = new HashSet<Element>();
    private final Map<PairGroup, LocalShape> localShapeMap = new HashMap<PairGroup, LocalShape>();

    public RealMolecule(RealMoleculeShape realMoleculeShape) {
        Object object;
        this.realMolecule = realMoleculeShape;
        int n = realMoleculeShape.getCentralLonePairCount();
        int n2 = realMoleculeShape.getBonds().size();
        ArrayList<Vector3D> arrayList = new ArrayList<Vector3D>();
        ArrayList<PairGroup> arrayList2 = new ArrayList<PairGroup>();
        this.addCentralAtom(new RealPairGroup(new Vector3D(), false, realMoleculeShape.getCentralAtom().getElement()));
        for (Bond<Atom3D> object22 : realMoleculeShape.getBonds()) {
            object = object22.getOtherAtom(realMoleculeShape.getCentralAtom());
            Vector3D i = ((Atom3D)object).position.get().normalized();
            arrayList.add(i);
            double vector3D = ((Atom3D)object).position.get().magnitude();
            Vector3D vector3D2 = i.times(5.5 * vector3D);
            RealPairGroup realPairGroup = new RealPairGroup(vector3D2, false, ((Atom)object).getElement());
            arrayList2.add(realPairGroup);
            this.addGroup(realPairGroup, this.getCentralAtom(), object22.order, vector3D);
            this.elementsUsed.add(((Atom)object).getElement());
            this.addTerminalLonePairs(realPairGroup, ((Atom3D)object).lonePairCount);
        }
        VseprConfiguration vseprConfiguration = new VseprConfiguration(n2, n);
        List<Vector3D> list = vseprConfiguration.getAllUnitVectors();
        object = vseprConfiguration.getIdealBondRotationToPositions(LocalShape.sortedLonePairsFirst(this.getNeighboringAtoms(this.getCentralAtom())));
        for (int i = 0; i < n; ++i) {
            Vector3D pairGroup = ((AttractorModel.ResultMapping)object).rotateVector(list.get(i));
            arrayList.add(pairGroup);
            PairGroup pairGroup2 = new PairGroup(pairGroup.times(7.0), true, false);
            this.addGroup(pairGroup2, this.getCentralAtom(), 0, 1.2727272727272727);
            arrayList2.add(pairGroup2);
        }
        this.localShapeMap.put(this.getCentralAtom(), new LocalShape(LocalShape.realPermutations(arrayList2), this.getCentralAtom(), arrayList2, arrayList));
        for (PairGroup pairGroup : this.getRadialAtoms()) {
            this.localShapeMap.put(pairGroup, this.getLocalVSEPRShape(pairGroup));
        }
    }

    @Override
    public void update(float f) {
        super.update(f);
        for (PairGroup pairGroup : this.getAtoms()) {
            List<PairGroup> list = this.getNeighbors(pairGroup);
            if (list.size() <= 1) continue;
            LocalShape localShape = this.getLocalShape(pairGroup);
            localShape.applyAngleAttractionRepulsion(f);
        }
    }

    public LocalShape getLocalShape(PairGroup pairGroup) {
        return this.localShapeMap.get(pairGroup);
    }

    @Override
    public boolean isReal() {
        return true;
    }

    @Override
    public Option<Float> getMaximumBondLength() {
        return new Option.None<Float>();
    }
}

