/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculeshapes.model;

import edu.colorado.phet.common.phetcommon.math.vector.Vector3D;
import edu.colorado.phet.common.phetcommon.model.property.ChangeObserver;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.moleculeshapes.model.Bond;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PairGroup {
    public final Property<Vector3D> position;
    public final Property<Vector3D> velocity = new Property<Vector3D>(new Vector3D());
    public final boolean isLonePair;
    public final Property<Boolean> userControlled;

    public PairGroup(Vector3D vector3D, boolean bl, boolean bl2) {
        this.position = new Property<Vector3D>(vector3D);
        this.isLonePair = bl;
        this.userControlled = new Property<Boolean>(bl2);
        this.position.addObserver(new ChangeObserver<Vector3D>(){

            @Override
            public void update(Vector3D vector3D, Vector3D vector3D2) {
                if (Double.isNaN(vector3D.getX())) {
                    throw new RuntimeException("NaN detected in position!");
                }
                if (vector3D2.equals(new Vector3D())) {
                    throw new RuntimeException("central molecule position change?");
                }
            }
        });
        this.velocity.addObserver(new ChangeObserver<Vector3D>(){

            @Override
            public void update(Vector3D vector3D, Vector3D vector3D2) {
                if (Double.isNaN(vector3D.getX())) {
                    throw new RuntimeException("NaN detected in velocity!");
                }
            }
        });
    }

    public void attractToIdealDistance(double d, double d2, Bond<PairGroup> bond) {
        double d3;
        if (this.userControlled.get().booleanValue()) {
            return;
        }
        Vector3D vector3D = bond.getOtherAtom((PairGroup)this).position.get();
        boolean bl = !vector3D.equals(new Vector3D());
        double d4 = bond.length * 5.5;
        double d5 = Math.abs(this.position.get().minus(vector3D).magnitude() - d4);
        if (d5 > (d3 = Math.abs(d2 - d4))) {
            this.position.set(this.position.get().normalized().times(d2).plus(vector3D));
        }
        Vector3D vector3D2 = this.position.get().minus(vector3D);
        double d6 = vector3D2.magnitude();
        Vector3D vector3D3 = vector3D2.normalized();
        double d7 = d4 - d6;
        double d8 = Math.pow(0.1, 0.016 / d);
        if (bl) {
            d8 = 1.0;
        }
        this.position.set(this.position.get().plus(vector3D3.times(d8 * d7)));
    }

    private double interpolate(double d, double d2, double d3) {
        return d * (1.0 - d3) + d2 * d3;
    }

    public Vector3D getRepulsionImpulse(PairGroup pairGroup, double d, double d2) {
        double d3 = this.interpolate(10.0, this.position.get().magnitude(), d2);
        double d4 = this.interpolate(10.0, pairGroup.position.get().magnitude(), d2);
        Vector3D vector3D = this.position.get().normalized().times(d3);
        Vector3D vector3D2 = pairGroup.position.get().magnitude() == 0.0 ? new Vector3D() : pairGroup.position.get().normalized().times(d4);
        Vector3D vector3D3 = vector3D.minus(vector3D2);
        double d5 = 1.0;
        Vector3D vector3D4 = vector3D3.normalized().times(d * 30000.0 * d5 / (vector3D3.magnitude() * vector3D3.magnitude()));
        double d6 = PairGroup.getTimescaleImpulseFactor(d);
        return vector3D4.times(d6);
    }

    public static double getTimescaleImpulseFactor(double d) {
        return Math.sqrt(d > 0.017 ? 0.017 / d : 1.0);
    }

    public void repulseFrom(PairGroup pairGroup, double d, double d2) {
        this.addVelocity(this.getRepulsionImpulse(pairGroup, d, d2));
    }

    public void addPosition(Vector3D vector3D) {
        if (!this.userControlled.get().booleanValue() && !this.isCentralAtom()) {
            this.position.set(this.position.get().plus(vector3D));
        }
    }

    public void addVelocity(Vector3D vector3D) {
        if (!this.userControlled.get().booleanValue() && !this.isCentralAtom()) {
            this.velocity.set(this.velocity.get().plus(vector3D));
        }
    }

    public void stepForward(double d) {
        double d2 = this.velocity.get().dot(this.position.get().normalized());
        if (this.position.get().magnitude() > 0.0) {
            this.velocity.set(this.velocity.get().minus(this.position.get().normalized().times(d2)));
        }
        this.position.set(this.position.get().plus(this.velocity.get().times(d)));
        double d3 = 0.9;
        d3 = Math.pow(d3, d / 0.017);
        this.velocity.set(this.velocity.get().times(d3));
    }

    public void dragToPosition(Vector3D vector3D) {
        this.position.set(vector3D);
        this.velocity.set(new Vector3D());
    }

    public boolean isCentralAtom() {
        return !this.isLonePair && this.position.get().equals(new Vector3D());
    }
}

