/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculeshapes.dev;

import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.lwjglphet.utils.GLActionListener;
import edu.colorado.phet.lwjglphet.utils.LWJGLUtils;
import edu.colorado.phet.moleculeshapes.MoleculeShapesConstants;
import edu.colorado.phet.moleculeshapes.MoleculeShapesProperties;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PerformanceFrame
extends JFrame {
    public PerformanceFrame() throws HeadlessException {
        super("Performance");
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.setContentPane(jPanel);
        jPanel.add((Component)new JLabel("Target FPS"), new GridBagConstraints());
        jPanel.add((Component)new FrameRateButton(60), new GridBagConstraints());
        jPanel.add((Component)new FrameRateButton(20), new GridBagConstraints());
        jPanel.add((Component)new FrameRateButton(5), new GridBagConstraints());
        jPanel.add((Component)new JLabel(""){
            {
                MoleculeShapesProperties.sphereSamples.addObserver(new SimpleObserver(){

                    public void update() {
                        this.setText("Atom samples: " + MoleculeShapesProperties.sphereSamples.get());
                    }
                });
            }
        }, new GridBagConstraints(){
            {
                this.gridy = 2;
            }
        });
        jPanel.add((Component)new PropertyIntegerSlider(3, 50, MoleculeShapesProperties.sphereSamples), new GridBagConstraints(){
            {
                this.gridy = 2;
            }
        });
        jPanel.add((Component)new JLabel(""){
            {
                MoleculeShapesProperties.cylinderSamples.addObserver(new SimpleObserver(){

                    public void update() {
                        this.setText("Bond samples: " + MoleculeShapesProperties.cylinderSamples.get());
                    }
                });
            }
        }, new GridBagConstraints(){
            {
                this.gridy = 3;
            }
        });
        jPanel.add((Component)new PropertyIntegerSlider(3, 50, MoleculeShapesProperties.cylinderSamples), new GridBagConstraints(){
            {
                this.gridy = 3;
            }
        });
        this.pack();
        this.setVisible(true);
    }

    private class FrameRateButton
    extends JButton {
        public FrameRateButton(final int n) {
            super(n + "");
            this.addActionListener(new GLActionListener(new Runnable(){

                public void run() {
                    MoleculeShapesConstants.FRAMES_PER_SECOND_LIMIT.set(n);
                }
            }));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PropertyIntegerSlider
    extends JSlider {
        public PropertyIntegerSlider(int n, int n2, final Property<Integer> property) {
            super(n, n2, property.get());
            this.setMajorTickSpacing(n2 - n);
            this.setPaintTicks(true);
            this.setPaintLabels(true);
            this.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    final int n = PropertyIntegerSlider.this.getValue();
                    LWJGLUtils.invoke(new Runnable(){

                        public void run() {
                            property.set(n);
                        }
                    });
                }
            });
            property.addObserver(new SimpleObserver(){

                public void update() {
                    PropertyIntegerSlider.this.setValue((Integer)property.get());
                }
            });
        }
    }
}

