/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes.layout;

import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.nodes.layout.PositionStrategy;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Box
extends PhetPNode {
    private final Function1<PBounds, Double> getMaxDimension;
    private final Function1<PBounds, Double> getNodeDimension;
    private PositionStrategy positionStrategy;
    private final double spacing;

    public Box(double d, Function1<PBounds, Double> function1, Function1<PBounds, Double> function12, PositionStrategy positionStrategy, PNode ... pNodeArray) {
        this.spacing = d;
        this.getMaxDimension = function1;
        this.getNodeDimension = function12;
        this.positionStrategy = positionStrategy;
        for (PNode pNode : pNodeArray) {
            this.addChild(pNode);
        }
    }

    @Override
    public void addChild(int n, PNode pNode) {
        super.addChild(n, pNode);
        this.updateLayout();
    }

    private void updateLayout() {
        PNode pNode = Collections.max(this.getChildren(), new Comparator<PNode>(){

            @Override
            public int compare(PNode pNode, PNode pNode2) {
                return Double.compare((Double)Box.this.getMaxDimension.apply(pNode.getFullBounds()), (Double)Box.this.getMaxDimension.apply(pNode2.getFullBounds()));
            }
        });
        double d = this.getMaxDimension.apply(pNode.getFullBounds());
        double d2 = 0.0;
        for (PNode pNode2 : this.getChildren()) {
            PBounds pBounds = pNode2.getFullBounds();
            double d3 = pBounds.getX() - pNode2.getOffset().getX();
            double d4 = pBounds.getY() - pNode2.getOffset().getY();
            Point2D point2D = this.positionStrategy.getRelativePosition(pNode2, d, d2);
            pNode2.setOffset(point2D.getX() - d3, point2D.getY() - d4);
            d2 += this.getNodeDimension.apply(pBounds) + this.spacing;
        }
    }
}

