/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.phetcommon.util.function.Function3;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.graphics.TriColorRoundGradientPaint;
import edu.colorado.phet.common.piccolophet.event.ButtonEventHandler;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.Spacer;
import edu.umd.cs.piccolo.PComponent;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.JComponent;

public class ArrowButtonNode
extends PNode {
    private Property<Boolean> enabledProperty = new Property<Boolean>(false);
    private final CursorHandler cursorHandler = new CursorHandler();
    private PComponent component;
    private final ArrayList<ActionListener> actionListeners = new ArrayList();

    public ArrowButtonNode(Orientation orientation, ColorScheme colorScheme) {
        this(orientation, 20.0, 2.0, colorScheme);
    }

    public ArrowButtonNode(Orientation orientation, final double d, final double d2, ColorScheme colorScheme) {
        double d3 = d * 0.2;
        final Point2D.Double double_ = new Point2D.Double(d * 0.35, d * 0.5);
        final Point2D.Double double_2 = new Point2D.Double(((Point2D)double_).getX() + d3, ((Point2D)double_).getY() - d3);
        final Point2D.Double double_3 = new Point2D.Double(((Point2D)double_).getX() + d3, ((Point2D)double_).getY() + d3);
        final double d4 = Math.sqrt(2.0 * d3 * d3);
        Ellipse2D.Double double_4 = new Ellipse2D.Double(0.0, 0.0, d, d);
        final Area area = new Area(){
            {
                Ellipse2D.Double double_4 = new Ellipse2D.Double(-d2, -d2, d2 * 2.0, d2 * 2.0);
                this.add(new Area(ArrowButtonNode.getTranslatedShape(double_4, double_)));
                this.add(new Area(ArrowButtonNode.getTranslatedShape(double_4, double_2)));
                this.add(new Area(ArrowButtonNode.getTranslatedShape(double_4, double_3)));
                Rectangle2D.Double double_22 = new Rectangle2D.Double(0.0, -d2, d4, d2 * 2.0);
                this.add(new Area(new AffineTransform(){
                    {
                        this.translate(double_.getX(), double_.getY());
                        this.rotate(0.7853981633974483);
                    }
                }.createTransformedShape(double_22)));
                this.add(new Area(new AffineTransform(){
                    {
                        this.translate(double_.getX(), double_.getY());
                        this.rotate(-0.7853981633974483);
                    }
                }.createTransformedShape(double_22)));
            }
        };
        Shape shape = new Function1<Orientation, Shape>(){

            @Override
            public Shape apply(Orientation orientation) {
                if (orientation == Orientation.LEFT) {
                    return area;
                }
                if (orientation == Orientation.RIGHT) {
                    return new AffineTransform(-1.0, 0.0, 0.0, 1.0, d, 0.0).createTransformedShape(area);
                }
                if (orientation == Orientation.UP) {
                    return new AffineTransform(0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f).createTransformedShape(area);
                }
                if (orientation == Orientation.DOWN) {
                    return new AffineTransform(0.0, -1.0, 1.0, 0.0, 0.0, d).createTransformedShape(area);
                }
                throw new RuntimeException("Bad Orientation: " + (Object)((Object)orientation));
            }
        }.apply(orientation);
        Function3<Color, Color, Color, TriColorRoundGradientPaint> function3 = new Function3<Color, Color, Color, TriColorRoundGradientPaint>(){

            @Override
            public TriColorRoundGradientPaint apply(Color color, Color color2, Color color3) {
                return new TriColorRoundGradientPaint(color, color2, color3, d / 2.0, d * 3.0 / 4.0, d / 2.5, d / 3.0);
            }
        };
        final TriColorRoundGradientPaint triColorRoundGradientPaint = (TriColorRoundGradientPaint)function3.apply(colorScheme.upInner, colorScheme.upMiddle, colorScheme.upOuter);
        final TriColorRoundGradientPaint triColorRoundGradientPaint2 = (TriColorRoundGradientPaint)function3.apply(colorScheme.overInner, colorScheme.overMiddle, colorScheme.overOuter);
        final TriColorRoundGradientPaint triColorRoundGradientPaint3 = (TriColorRoundGradientPaint)function3.apply(colorScheme.pressedInner, colorScheme.pressedMiddle, colorScheme.pressedOuter);
        final TriColorRoundGradientPaint triColorRoundGradientPaint4 = (TriColorRoundGradientPaint)function3.apply(colorScheme.disabledInner, colorScheme.disabledMiddle, colorScheme.disabledOuter);
        this.addChild(new Spacer(0.0, 0.0, d + 1.0, d + 1.0));
        final PhetPPath phetPPath = new PhetPPath(double_4){
            {
                super(shape);
                this.setPaint(triColorRoundGradientPaint);
                this.setStroke(new BasicStroke(1.0f));
                ArrowButtonNode.this.enabledProperty.addObserver(new VoidFunction1<Boolean>(){

                    @Override
                    public void apply(Boolean bl) {
                        this.setStrokePaint(bl != false ? Color.gray : Color.lightGray);
                    }
                });
            }
        };
        this.addChild(phetPPath);
        phetPPath.addChild(new PhetPPath(shape){
            {
                this.setStroke(null);
                ArrowButtonNode.this.enabledProperty.addObserver(new VoidFunction1<Boolean>(){

                    @Override
                    public void apply(Boolean bl) {
                        this.setPaint(bl != false ? new Color(60, 60, 60) : new Color(160, 160, 160));
                    }
                });
            }
        });
        phetPPath.addChild(new PhetPPath(ArrowButtonNode.getInternalShadow(shape, new Point2D.Double(0.0, d2))){
            {
                ArrowButtonNode.this.enabledProperty.addObserver(new VoidFunction1<Boolean>(){

                    @Override
                    public void apply(Boolean bl) {
                        this.setPaint(bl != false ? new Color(30, 30, 30) : new Color(130, 130, 130));
                    }
                });
                this.setStroke(null);
            }
        });
        phetPPath.addChild(new PhetPPath(ArrowButtonNode.getInternalShadow(shape, new Point2D.Double(0.0, d2 * 3.0 / 4.0))){
            {
                ArrowButtonNode.this.enabledProperty.addObserver(new VoidFunction1<Boolean>(){

                    @Override
                    public void apply(Boolean bl) {
                        this.setPaint(bl != false ? new Color(0, 0, 0) : new Color(100, 100, 100));
                    }
                });
                this.setStroke(null);
            }
        });
        this.addInputEventListener(this.cursorHandler);
        final Property<Boolean> property = new Property<Boolean>(false);
        final Property<Boolean> property2 = new Property<Boolean>(false);
        SimpleObserver simpleObserver = new SimpleObserver(){

            public void update() {
                phetPPath.setPaint((Boolean)ArrowButtonNode.this.enabledProperty.get() == false ? triColorRoundGradientPaint4 : ((Boolean)property2.get() != false ? triColorRoundGradientPaint3 : ((Boolean)property.get() != false ? triColorRoundGradientPaint2 : triColorRoundGradientPaint)));
                phetPPath.setOffset((Boolean)property2.get() != false ? new Point2D.Double(1.0, 1.0) : new Point2D.Double(0.0, 0.0));
                ArrowButtonNode.this.repaint();
            }
        };
        property.addObserver(simpleObserver, false);
        this.enabledProperty.addObserver(simpleObserver, false);
        property2.addObserver(simpleObserver);
        this.addInputEventListener(new ButtonEventHandler(){
            {
                this.addButtonEventListener(new ButtonEventHandler.ButtonEventListener(){

                    public void setFocus(boolean bl) {
                        property.set(bl);
                    }

                    public void setArmed(boolean bl) {
                        property2.set(bl);
                    }

                    public void fire() {
                        ArrowButtonNode.this.notifyActionPerformed();
                    }
                });
            }
        });
        this.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseMoved(PInputEvent pInputEvent) {
                ArrowButtonNode.this.component = pInputEvent.getComponent();
            }
        });
    }

    public void setEnabled(boolean bl) {
        this.enabledProperty.set(bl);
        this.setPickable(bl);
        this.setChildrenPickable(bl);
        if (this.component != null && !bl) {
            this.cursorHandler.mouseExited((JComponent)((Object)this.component));
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners.add(actionListener);
    }

    private void notifyActionPerformed() {
        ActionEvent actionEvent = new ActionEvent(this, 1001, "");
        for (ActionListener actionListener : new ArrayList<ActionListener>(this.actionListeners)) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    private static Shape getInternalShadow(final Shape shape, final Point2D point2D) {
        return new Area(){
            {
                this.add(new Area(shape));
                this.subtract(new Area(ArrowButtonNode.getTranslatedShape(shape, point2D)));
            }
        };
    }

    private static Shape getTranslatedShape(Shape shape, Point2D point2D) {
        return AffineTransform.getTranslateInstance(point2D.getX(), point2D.getY()).createTransformedShape(shape);
    }

    public static class ColorScheme {
        public final Color upInner;
        public final Color upMiddle;
        public final Color upOuter;
        public final Color overInner;
        public final Color overMiddle;
        public final Color overOuter;
        public final Color pressedInner;
        public final Color pressedMiddle;
        public final Color pressedOuter;
        public final Color disabledInner;
        public final Color disabledMiddle;
        public final Color disabledOuter;

        public ColorScheme(Color color) {
            this(ColorScheme.add(color, -20, -20, -20), color, ColorScheme.add(color, 35, 35, 35), ColorScheme.add(color, -20, 20, 20), ColorScheme.add(color, 0, 20, 20), ColorScheme.add(color, 35, 35, 35), ColorScheme.add(color, 35, 35, 35), ColorScheme.add(color, 0, -20, -20), ColorScheme.add(color, -20, -20, -20), Color.white, Color.lightGray, Color.white);
        }

        private static Color add(Color color, int n, int n2, int n3) {
            return new Color(MathUtil.clamp(0, color.getRed() + n, 255), MathUtil.clamp(0, color.getGreen() + n2, 255), MathUtil.clamp(0, color.getBlue() + n3, 255));
        }

        public ColorScheme() {
            this(new Color(220, 220, 220));
        }

        public ColorScheme(Color color, Color color2, Color color3, Color color4, Color color5, Color color6, Color color7, Color color8, Color color9, Color color10, Color color11, Color color12) {
            this.upInner = color;
            this.upMiddle = color2;
            this.upOuter = color3;
            this.overInner = color4;
            this.overMiddle = color5;
            this.overOuter = color6;
            this.pressedInner = color7;
            this.pressedMiddle = color8;
            this.pressedOuter = color9;
            this.disabledInner = color10;
            this.disabledMiddle = color11;
            this.disabledOuter = color12;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Orientation
    extends Enum<Orientation> {
        public static final /* enum */ Orientation LEFT = new Orientation();
        public static final /* enum */ Orientation RIGHT = new Orientation();
        public static final /* enum */ Orientation UP = new Orientation();
        public static final /* enum */ Orientation DOWN = new Orientation();
        private static final /* synthetic */ Orientation[] $VALUES;

        public static Orientation[] values() {
            return (Orientation[])$VALUES.clone();
        }

        static {
            $VALUES = new Orientation[]{LEFT, RIGHT, UP, DOWN};
        }
    }
}

