/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.math.vector;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3D;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import java.io.Serializable;

public abstract class AbstractVector3D
implements Serializable {
    public abstract double getX();

    public abstract double getY();

    public abstract double getZ();

    public double magnitude() {
        return Math.sqrt(this.magnitudeSquared());
    }

    public double magnitudeSquared() {
        return this.getX() * this.getX() + this.getY() * this.getY() + this.getZ() * this.getZ();
    }

    public double dot(AbstractVector3D abstractVector3D) {
        return this.getX() * abstractVector3D.getX() + this.getY() * abstractVector3D.getY() + this.getZ() * abstractVector3D.getZ();
    }

    public Vector3D cross(AbstractVector3D abstractVector3D) {
        return new Vector3D(this.getY() * abstractVector3D.getZ() - this.getZ() * abstractVector3D.getY(), this.getZ() * abstractVector3D.getX() - this.getX() * abstractVector3D.getZ(), this.getX() * abstractVector3D.getY() - this.getY() * abstractVector3D.getX());
    }

    public double angleBetween(AbstractVector3D abstractVector3D) {
        return Math.acos(MathUtil.clamp(-1.0, this.normalized().dot(abstractVector3D.normalized()), 1.0));
    }

    public double angleBetweenInDegrees(AbstractVector3D abstractVector3D) {
        return this.angleBetween(abstractVector3D) * 180.0 / Math.PI;
    }

    public Vector3D normalized() {
        double d = this.magnitude();
        if (d == 0.0) {
            throw new UnsupportedOperationException("Cannot normalize a zero-magnitude vector.");
        }
        return new Vector3D(this.getX() / d, this.getY() / d, this.getZ() / d);
    }

    public Vector3D times(double d) {
        return new Vector3D(this.getX() * d, this.getY() * d, this.getZ() * d);
    }

    public Vector3D plus(AbstractVector3D abstractVector3D) {
        return new Vector3D(this.getX() + abstractVector3D.getX(), this.getY() + abstractVector3D.getY(), this.getZ() + abstractVector3D.getZ());
    }

    public Vector3D minus(AbstractVector3D abstractVector3D) {
        return new Vector3D(this.getX() - abstractVector3D.getX(), this.getY() - abstractVector3D.getY(), this.getZ() - abstractVector3D.getZ());
    }

    public Vector3D negated() {
        return new Vector3D(-this.getX(), -this.getY(), -this.getZ());
    }

    public Vector3F to3F() {
        return new Vector3F(this.getX(), this.getY(), this.getZ());
    }
}

