/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.BoxInfo;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Measure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeshSurface {
    public boolean haveQuads;
    public short colix;
    public boolean isColorSolid = true;
    public int vertexCount;
    public Point3f[] vertices;
    public Point3f offset;
    public Tuple3f[] altVertices;
    public short[] vertexColixes;
    public int polygonCount;
    public int[][] polygonIndexes;
    public short[] polygonColixes;
    public Tuple3f[] normals;
    public BitSet bsPolygons;
    public Point3f ptOffset;
    public float scale3d;
    public float[] vertexValues;
    public BitSet[] surfaceSet;
    public int[] vertexSets;
    public int nSets = 0;
    public int checkCount = 2;
    private int lastColor;
    private short lastColix;
    protected int iA;
    protected int iB;
    protected int iC;

    public Tuple3f[] getVertices() {
        return this.altVertices == null ? this.vertices : this.altVertices;
    }

    public int addVertexCopy(Point3f point3f) {
        if (this.vertexCount == 0) {
            this.vertices = new Point3f[25];
        } else if (this.vertexCount == this.vertices.length) {
            this.vertices = (Point3f[])ArrayUtil.doubleLength(this.vertices);
        }
        this.vertices[this.vertexCount] = new Point3f(point3f);
        return this.vertexCount++;
    }

    protected int addPolygon(int[] nArray) {
        int n = this.polygonCount;
        if (this.polygonCount == 0) {
            this.polygonIndexes = new int[25][];
        } else if (this.polygonCount == this.polygonIndexes.length) {
            this.polygonIndexes = (int[][])ArrayUtil.doubleLength(this.polygonIndexes);
        }
        this.polygonIndexes[this.polygonCount++] = nArray;
        return n;
    }

    public int addVertexCopy(Point3f point3f, float f) {
        if (this.vertexCount == 0) {
            this.vertexValues = new float[25];
        } else if (this.vertexCount >= this.vertexValues.length) {
            this.vertexValues = ArrayUtil.doubleLength(this.vertexValues);
        }
        this.vertexValues[this.vertexCount] = f;
        return this.addVertexCopy(point3f);
    }

    public int addTriangleCheck(int n, int n2, int n3, int n4, int n5, int n6) {
        return this.vertices == null || this.vertexValues != null && (Float.isNaN(this.vertexValues[n]) || Float.isNaN(this.vertexValues[n2]) || Float.isNaN(this.vertexValues[n3])) || Float.isNaN(this.vertices[n].x) || Float.isNaN(this.vertices[n2].x) || Float.isNaN(this.vertices[n3].x) ? -1 : (this.checkCount == 2 ? this.addPolygon(new int[]{n, n2, n3, n4, n5}, n6) : this.addPolygon(new int[]{n, n2, n3, n4}));
    }

    private int addPolygon(int[] nArray, int n) {
        if (n != 0) {
            short s;
            if (this.polygonColixes == null || this.polygonCount == 0) {
                this.lastColor = 0;
            }
            if (n == this.lastColor) {
                s = this.lastColix;
            } else {
                this.lastColor = n;
                s = this.lastColix = Graphics3D.getColix(this.lastColor);
            }
            short s2 = s;
            this.setPolygonColix(this.polygonCount, s2);
        }
        return this.addPolygon(nArray);
    }

    private void setPolygonColix(int n, short s) {
        if (this.polygonColixes == null) {
            this.polygonColixes = new short[25];
        } else if (n == this.polygonColixes.length) {
            this.polygonColixes = ArrayUtil.doubleLength(this.polygonColixes);
        }
        this.polygonColixes[n] = s;
    }

    public void invalidatePolygons() {
        int n = this.polygonCount;
        while (--n >= 0) {
            if (this.setABC(n)) continue;
            this.polygonIndexes[n] = null;
        }
    }

    protected boolean setABC(int n) {
        int[] nArray = this.polygonIndexes[n];
        return nArray != null && !Float.isNaN(this.vertexValues[this.iA = nArray[0]]) && !Float.isNaN(this.vertexValues[this.iB = nArray[1]]) && !Float.isNaN(this.vertexValues[this.iC = nArray[2]]);
    }

    public void slabPolygons(Object object, boolean bl) {
        if (object instanceof Point4f) {
            this.getIntersection((Point4f)object, null, 0.0f, null, bl, false);
            return;
        }
        if (object instanceof Point3f[]) {
            Point4f[] point4fArray = BoxInfo.getFacesFromCriticalPoints((Point3f[])object);
            for (int i = 0; i < point4fArray.length; ++i) {
                this.getIntersection(point4fArray[i], null, 0.0f, null, bl, false);
            }
            return;
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            float f = ((Float)objectArray[0]).floatValue();
            Point3f point3f = (Point3f)objectArray[1];
            this.getIntersection(null, point3f, f, null, bl, false);
        }
    }

    public boolean getIntersection(Point4f point4f, Point3f point3f, float f, List<Point3f[]> list, boolean bl, boolean bl2) {
        int n;
        int n2;
        Object object;
        Object object2;
        int n3;
        int n4;
        boolean bl3;
        boolean bl4 = bl3 = list == null;
        if (point3f != null) {
            bl = false;
        }
        double d = Math.abs(f);
        ArrayList<int[]> arrayList = bl ? new ArrayList<int[]>() : null;
        int n5 = this.polygonIndexes.length;
        block16: while (--n5 >= 0) {
            float f2;
            float f3;
            float f4;
            if (!this.setABC(n5)) continue;
            n4 = this.polygonIndexes[n5][3];
            n3 = this.checkCount == 2 ? this.polygonIndexes[n5][4] : 0;
            object2 = this.vertices[this.iA];
            object = this.vertices[this.iB];
            Point3f point3f2 = this.vertices[this.iC];
            if (point3f == null) {
                f4 = Measure.distanceToPlane(point4f, (Point3f)object2);
                f3 = Measure.distanceToPlane(point4f, (Point3f)object);
                f2 = Measure.distanceToPlane(point4f, point3f2);
            } else if (f < 0.0f) {
                f4 = -((Point3f)object2).distance(point3f) - f;
                f3 = -((Point3f)object).distance(point3f) - f;
                f2 = -point3f2.distance(point3f) - f;
            } else {
                f4 = ((Point3f)object2).distance(point3f) - f;
                f3 = ((Point3f)object).distance(point3f) - f;
                f2 = point3f2.distance(point3f) - f;
            }
            int n6 = (f4 < 0.0f ? 1 : 0) + (f3 < 0.0f ? 2 : 0) + (f2 < 0.0f ? 4 : 0);
            int n7 = (f4 >= 0.0f ? 1 : 0) + (f3 >= 0.0f ? 2 : 0) + (f2 >= 0.0f ? 4 : 0);
            Point3f[] point3fArray = null;
            switch (n6) {
                case 0: 
                case 7: {
                    break;
                }
                case 1: 
                case 6: {
                    if (point3f == null) {
                        point3fArray = new Point3f[]{MeshSurface.interpolatePoint((Point3f)object2, (Point3f)object, -f4, f3), MeshSurface.interpolatePoint((Point3f)object2, point3f2, -f4, f2)};
                        break;
                    }
                    point3fArray = new Point3f[]{this.interpolateSphere((Point3f)object2, (Point3f)object, -f4, -f3, d), this.interpolateSphere((Point3f)object2, point3f2, -f4, -f2, d)};
                    break;
                }
                case 2: 
                case 5: {
                    if (point3f == null) {
                        point3fArray = new Point3f[]{MeshSurface.interpolatePoint((Point3f)object, (Point3f)object2, -f3, f4), MeshSurface.interpolatePoint((Point3f)object, point3f2, -f3, f2)};
                        break;
                    }
                    point3fArray = new Point3f[]{this.interpolateSphere((Point3f)object, (Point3f)object2, -f3, -f4, d), this.interpolateSphere((Point3f)object, point3f2, -f3, -f2, d)};
                    break;
                }
                case 3: 
                case 4: {
                    point3fArray = point3f == null ? new Point3f[]{MeshSurface.interpolatePoint(point3f2, (Point3f)object2, -f2, f4), MeshSurface.interpolatePoint(point3f2, (Point3f)object, -f2, f3)} : new Point3f[]{this.interpolateSphere(point3f2, (Point3f)object2, -f2, -f4, d), this.interpolateSphere(point3f2, (Point3f)object, -f2, -f3, d)};
                }
            }
            if (bl3) {
                n2 = -1;
                n = -1;
                switch (n7) {
                    case 0: {
                        continue block16;
                    }
                    case 7: {
                        break;
                    }
                    case 1: {
                        if (n2 < 0) {
                            n2 = this.addVertexCopy((Point3f)point3fArray[0], this.vertexValues[this.iA]);
                            this.addTriangleCheck(n2, this.iB, this.iC, n4 & 3, n3, 0);
                        }
                        if (n >= 0) break;
                        n = this.addVertexCopy((Point3f)point3fArray[1], this.vertexValues[this.iA]);
                        this.addTriangleCheck(n, n2, this.iC, n4 & 4 | 1, n3, 0);
                        break;
                    }
                    case 2: {
                        if (n < 0) {
                            n = this.addVertexCopy((Point3f)point3fArray[0], this.vertexValues[this.iB]);
                            this.addTriangleCheck(this.iA, n, this.iC, n4 & 5, n3, 0);
                        }
                        if (n2 >= 0) break;
                        n2 = this.addVertexCopy((Point3f)point3fArray[1], this.vertexValues[this.iB]);
                        this.addTriangleCheck(n, n2, this.iC, n4 & 2 | 1, n3, 0);
                        break;
                    }
                    case 3: {
                        n = this.addVertexCopy((Point3f)point3fArray[0], this.vertexValues[this.iA]);
                        n2 = this.addVertexCopy(point3fArray[1], this.vertexValues[this.iB]);
                        this.addTriangleCheck(n, n2, this.iC, n4 & 6 | 1, n3, 0);
                        break;
                    }
                    case 4: {
                        if (n2 < 0) {
                            n2 = this.addVertexCopy((Point3f)point3fArray[0], this.vertexValues[this.iC]);
                            this.addTriangleCheck(this.iA, this.iB, n2, n4 & 5, n3, 0);
                        }
                        if (n >= 0) break;
                        n = this.addVertexCopy((Point3f)point3fArray[1], this.vertexValues[this.iC]);
                        this.addTriangleCheck(n2, this.iB, n, n4 & 2 | 4, n3, 0);
                        break;
                    }
                    case 5: {
                        n = this.addVertexCopy((Point3f)point3fArray[1], this.vertexValues[this.iC]);
                        n2 = this.addVertexCopy(point3fArray[0], this.vertexValues[this.iA]);
                        this.addTriangleCheck(n2, this.iB, n, n4 & 3 | 4, n3, 0);
                        break;
                    }
                    case 6: {
                        if (bl2 && (point3fArray[0].distance((Point3f)object2) < 0.01f || point3fArray[1].distance((Point3f)object2) < 0.01f)) continue block16;
                        n = this.addVertexCopy((Point3f)point3fArray[0], this.vertexValues[this.iB]);
                        n2 = this.addVertexCopy(point3fArray[1], this.vertexValues[this.iC]);
                        this.addTriangleCheck(this.iA, n, n2, n4 & 5 | 2, n3, 0);
                    }
                }
                this.polygonIndexes[n5] = null;
                if (!bl || n <= 0) continue;
                arrayList.add(new int[]{n, n2});
                continue;
            }
            if (point3fArray == null) continue;
            list.add(point3fArray);
        }
        if (bl && arrayList.size() > 0) {
            Point3f point3f3 = new Point3f();
            n4 = arrayList.size();
            while (--n4 >= 0) {
                int[] nArray = (int[])arrayList.get(n4);
                point3f3.add(this.vertices[nArray[0]]);
                point3f3.add(this.vertices[nArray[1]]);
            }
            point3f3.scale(0.5f / (float)arrayList.size());
            n4 = this.addVertexCopy(point3f3);
            n3 = arrayList.size();
            while (--n3 >= 0) {
                object2 = (int[])arrayList.get(n3);
                n = this.addVertexCopy(this.vertices[object2[0]], this.vertexValues[object2[0]]);
                n2 = this.addVertexCopy(this.vertices[object2[1]], this.vertexValues[object2[1]]);
                this.addTriangleCheck(n, n4, n2, 0, 0, 0);
            }
        }
        if (!bl2) {
            return false;
        }
        BitSet bitSet = new BitSet();
        BitSet bitSet2 = new BitSet();
        for (n3 = 0; n3 < this.polygonCount; ++n3) {
            if (this.polygonIndexes[n3] == null) continue;
            bitSet2.set(n3);
            for (int i = 0; i < 3; ++i) {
                bitSet.set(this.polygonIndexes[n3][i]);
            }
        }
        n3 = 0;
        int n8 = bitSet2.cardinality();
        if (n8 != this.polygonCount) {
            object = new int[this.vertexCount];
            for (int i = 0; i < this.vertexCount; ++i) {
                if (!bitSet.get(i)) continue;
                object[i] = n3++;
            }
            Point3f[] point3fArray = new Point3f[n3];
            n3 = 0;
            for (int i = 0; i < this.vertexCount; ++i) {
                if (!bitSet.get(i)) continue;
                point3fArray[n3++] = this.vertices[i];
            }
            int[][] nArrayArray = new int[n8][];
            n8 = 0;
            for (int i = 0; i < this.polygonCount; ++i) {
                if (this.polygonIndexes[i] == null) continue;
                for (int j = 0; j < 3; ++j) {
                    this.polygonIndexes[i][j] = (int)object[this.polygonIndexes[i][j]];
                }
                nArrayArray[n8++] = this.polygonIndexes[i];
            }
            this.vertices = point3fArray;
            this.vertexCount = n3;
            this.polygonIndexes = nArrayArray;
            this.polygonCount = n8;
        }
        return false;
    }

    private Point3f interpolateSphere(Point3f point3f, Point3f point3f2, float f, float f2, double d) {
        return MeshSurface.interpolateFraction(point3f, point3f2, MeshSurface.getSphericalInterpolationFraction(d, f, f2, point3f.distance(point3f2)));
    }

    private static Point3f interpolatePoint(Point3f point3f, Point3f point3f2, float f, float f2) {
        return MeshSurface.interpolateFraction(point3f, point3f2, f / (f + f2));
    }

    private static Point3f interpolateFraction(Point3f point3f, Point3f point3f2, float f) {
        if ((double)f < 1.0E-4) {
            f = 0.0f;
        } else if ((double)f > 0.9999) {
            f = 1.0f;
        }
        return new Point3f(point3f.x + (point3f2.x - point3f.x) * f, point3f.y + (point3f2.y - point3f.y) * f, point3f.z + (point3f2.z - point3f.z) * f);
    }

    public static float getSphericalInterpolationFraction(double d, double d2, double d3, double d4) {
        double d5 = Math.abs(d + d2) / d4;
        double d6 = Math.abs(d + d3) / d4;
        double d7 = d5 * d5;
        double d8 = d7 - d6 * d6 + 1.0;
        double d9 = 4.0 * ((d /= d4) * d - d7);
        double d10 = d5 < d6 ? 1 : -1;
        return (float)((d8 + d10 * Math.sqrt(d8 * d8 + d9)) / 2.0);
    }
}

