/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import javax.vecmath.Point3f;
import org.jmol.api.JmolRendererInterface;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Viewer;

public abstract class Object2d {
    protected static final String[] hAlignNames = new String[]{"", "left", "center", "right", ""};
    protected static final String[] vAlignNames = new String[]{"xy", "top", "bottom", "middle"};
    protected boolean isLabelOrHover;
    protected Viewer viewer;
    protected JmolRendererInterface g3d;
    public Point3f xyz;
    String target;
    protected String script;
    protected short colix;
    protected short bgcolix;
    protected int pointer;
    protected int align;
    public int valign;
    protected int movableX;
    protected int movableY;
    protected int movableZ;
    protected int movableXPercent = Integer.MAX_VALUE;
    protected int movableYPercent = Integer.MAX_VALUE;
    protected int movableZPercent = Integer.MAX_VALUE;
    protected int offsetX;
    protected int offsetY;
    protected int z;
    protected int zSlab;
    protected int windowWidth;
    protected int windowHeight;
    protected boolean adjustForWindow;
    protected float boxWidth;
    protected float boxHeight;
    protected float boxX;
    protected float boxY;
    int modelIndex = -1;
    boolean visible = true;
    boolean hidden = false;
    protected final float[] boxXY = new float[2];
    protected float scalePixelsPerMicron;

    float getScalePixelsPerMicron() {
        return this.scalePixelsPerMicron;
    }

    public void setScalePixelsPerMicron(float f) {
        this.scalePixelsPerMicron = f;
    }

    protected abstract void recalc();

    protected Object2d() {
    }

    protected Object2d(Viewer viewer, Graphics3D graphics3D, String string, short s, int n, int n2, float f) {
        this.viewer = viewer;
        this.g3d = graphics3D;
        this.isLabelOrHover = false;
        this.target = string;
        if (string.equals("error")) {
            n = 1;
        }
        this.colix = s;
        this.align = n2;
        this.valign = n;
        this.z = 2;
        this.zSlab = Integer.MIN_VALUE;
        this.scalePixelsPerMicron = f;
    }

    void setModel(int n) {
        this.modelIndex = n;
    }

    public void setVisibility(boolean bl) {
        this.visible = bl;
    }

    public void setXYZ(Point3f point3f) {
        this.valign = point3f == null ? 0 : 4;
        this.xyz = point3f;
        this.setAdjustForWindow(point3f == null);
    }

    public void setAdjustForWindow(boolean bl) {
        this.adjustForWindow = bl;
    }

    void setColix(short s) {
        this.colix = s;
    }

    void setColix(Object object) {
        this.colix = Graphics3D.getColix(object);
    }

    void setTranslucent(float f, boolean bl) {
        if (bl) {
            if (this.bgcolix != 0) {
                this.bgcolix = Graphics3D.getColixTranslucent(this.bgcolix, !Float.isNaN(f), f);
            }
        } else {
            this.colix = Graphics3D.getColixTranslucent(this.colix, !Float.isNaN(f), f);
        }
    }

    void setBgColix(short s) {
        this.bgcolix = s;
    }

    void setBgColix(Object object) {
        this.bgcolix = object == null ? (short)0 : Graphics3D.getColix(object);
    }

    public void setMovableX(int n) {
        this.valign = this.valign == 4 ? 4 : 0;
        this.movableX = n;
        this.movableXPercent = Integer.MAX_VALUE;
    }

    public void setMovableY(int n) {
        this.valign = this.valign == 4 ? 4 : 0;
        this.movableY = n;
        this.movableYPercent = Integer.MAX_VALUE;
    }

    public void setMovableXPercent(int n) {
        this.valign = this.valign == 4 ? 4 : 0;
        this.movableX = Integer.MAX_VALUE;
        this.movableXPercent = n;
    }

    public void setMovableYPercent(int n) {
        this.valign = this.valign == 4 ? 4 : 0;
        this.movableY = Integer.MAX_VALUE;
        this.movableYPercent = n;
    }

    public void setMovableZPercent(int n) {
        if (this.valign != 4) {
            this.valign = 0;
        }
        this.movableZ = Integer.MAX_VALUE;
        this.movableZPercent = n;
    }

    void setXY(int n, int n2) {
        this.setMovableX(n);
        this.setMovableY(n2);
    }

    void setZs(int n, int n2) {
        this.z = n;
        this.zSlab = n2;
    }

    public void setXYZs(int n, int n2, int n3, int n4) {
        this.setMovableX(n);
        this.setMovableY(n2);
        this.setZs(n3, n4);
    }

    public void setScript(String string) {
        this.script = string == null || string.length() == 0 ? null : string;
    }

    public String getScript() {
        return this.script;
    }

    void setOffset(int n) {
        this.offsetX = Object2d.getXOffset(n);
        this.offsetY = Object2d.getYOffset(n);
        this.valign = 0;
    }

    static int getXOffset(int n) {
        switch (n) {
            case 0: {
                return 4;
            }
            case 32767: {
                return 0;
            }
        }
        return -(-((byte)(n >> 8 & 0xFF)));
    }

    static int getYOffset(int n) {
        switch (n) {
            case 0: {
                return -4;
            }
            case 32767: {
                return 0;
            }
        }
        return -((byte)(n & 0xFF));
    }

    boolean setAlignment(String string) {
        if ("left".equals(string)) {
            return this.setAlignment(1);
        }
        if ("center".equals(string)) {
            return this.setAlignment(2);
        }
        if ("right".equals(string)) {
            return this.setAlignment(3);
        }
        return false;
    }

    static String getAlignment(int n) {
        return hAlignNames[n & 3];
    }

    boolean setAlignment(int n) {
        if (this.align != n) {
            this.align = n;
            this.recalc();
        }
        return true;
    }

    void setPointer(int n) {
        this.pointer = n;
    }

    static String getPointer(int n) {
        return (n & 1) == 0 ? "" : ((n & 2) > 0 ? "background" : "on");
    }

    protected void drawPointer(JmolRendererInterface jmolRendererInterface) {
        if ((this.pointer & 1) != 0) {
            if (!jmolRendererInterface.setColix((this.pointer & 2) != 0 && this.bgcolix != 0 ? this.bgcolix : this.colix)) {
                return;
            }
            if (this.boxX > (float)this.movableX) {
                jmolRendererInterface.drawLine(this.movableX, this.movableY, this.zSlab, (int)this.boxX, (int)(this.boxY + this.boxHeight / 2.0f), this.zSlab);
            } else if (this.boxX + this.boxWidth < (float)this.movableX) {
                jmolRendererInterface.drawLine(this.movableX, this.movableY, this.zSlab, (int)(this.boxX + this.boxWidth), (int)(this.boxY + this.boxHeight / 2.0f), this.zSlab);
            }
        }
    }

    protected void setBoxOffsetsInWindow(float f, float f2, float f3) {
        float f4 = this.boxX;
        float f5 = this.boxWidth + f;
        if (f4 + f5 > (float)this.windowWidth) {
            f4 = (float)this.windowWidth - f5;
        }
        if (f4 < f) {
            f4 = f;
        }
        this.boxX = f4;
        float f6 = f3;
        float f7 = this.boxHeight;
        if (f6 + f7 > (float)this.windowHeight) {
            f6 = (float)this.windowHeight - f7;
        }
        if (f6 < f2) {
            f6 = f2;
        }
        this.boxY = f6;
    }

    protected void setWindow(JmolRendererInterface jmolRendererInterface, float f) {
        this.windowWidth = jmolRendererInterface.getRenderWidth();
        this.windowHeight = jmolRendererInterface.getRenderHeight();
        if (this.scalePixelsPerMicron < 0.0f && f != 0.0f) {
            this.scalePixelsPerMicron = f;
        }
    }

    public boolean checkObjectClicked(int n, int n2, BitSet bitSet) {
        if (this.modelIndex >= 0 && !bitSet.get(this.modelIndex) || this.hidden) {
            return false;
        }
        if (this.g3d.isAntialiased()) {
            n <<= 1;
            n2 <<= 1;
        }
        return this.script != null && (float)n >= this.boxX && (float)n <= this.boxX + this.boxWidth && (float)n2 >= this.boxY && (float)n2 <= this.boxY + this.boxHeight;
    }

    public static boolean setProperty(String string, Object object, Object2d object2d) {
        if ("script" == string) {
            if (object2d != null) {
                object2d.setScript((String)object);
            }
            return true;
        }
        if ("xpos" == string) {
            if (object2d != null) {
                object2d.setMovableX((Integer)object);
            }
            return true;
        }
        if ("ypos" == string) {
            if (object2d != null) {
                object2d.setMovableY((Integer)object);
            }
            return true;
        }
        if ("%xpos" == string) {
            if (object2d != null) {
                object2d.setMovableXPercent((Integer)object);
            }
            return true;
        }
        if ("%ypos" == string) {
            if (object2d != null) {
                object2d.setMovableYPercent((Integer)object);
            }
            return true;
        }
        if ("%zpos" == string) {
            if (object2d != null) {
                object2d.setMovableZPercent((Integer)object);
            }
            return true;
        }
        if ("xypos" == string) {
            if (object2d == null) {
                return true;
            }
            Point3f point3f = (Point3f)object;
            object2d.setXYZ(null);
            if (point3f.z == Float.MAX_VALUE) {
                object2d.setMovableX((int)point3f.x);
                object2d.setMovableY((int)point3f.y);
            } else {
                object2d.setMovableXPercent((int)point3f.x);
                object2d.setMovableYPercent((int)point3f.y);
            }
            return true;
        }
        if ("xyz" == string) {
            if (object2d != null) {
                object2d.setXYZ((Point3f)object);
            }
            return true;
        }
        return false;
    }

    public static int getOffset(int n, int n2) {
        n = Math.min(Math.max(n, -127), 127);
        n2 = Math.min(Math.max(n2, -127), 127);
        return (n & 0xFF) << 8 | n2 & 0xFF;
    }
}

