/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.quantum;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Map;
import javax.vecmath.Point3f;
import org.jmol.api.MepCalculationInterface;
import org.jmol.api.VolumeDataInterface;
import org.jmol.modelset.Atom;
import org.jmol.quantum.QuantumCalculation;
import org.jmol.util.Logger;
import org.jmol.util.Parser;

public class MepCalculation
extends QuantumCalculation
implements MepCalculationInterface {
    protected int distanceMode = 0;
    private float[] potentials;
    private Point3f[] atomCoordAngstroms;
    private BitSet bsSelected;
    protected Map<String, Object> htAtomicPotentials;

    public MepCalculation() {
        this.rangeBohrOrAngstroms = 8.0f;
        this.distanceMode = 0;
        this.unitFactor = 1.0f;
    }

    public void assignPotentials(Atom[] atomArray, float[] fArray, BitSet bitSet, BitSet bitSet2, BitSet bitSet3, String string) {
        this.getAtomicPotentials(string, null);
        for (int i = 0; i < atomArray.length; ++i) {
            float f;
            if (bitSet3 != null && bitSet3.get(i)) {
                f = Float.NaN;
            } else {
                f = this.getTabulatedPotential(atomArray[i]);
                if (Float.isNaN(f)) {
                    f = 0.0f;
                }
            }
            if (Logger.debugging) {
                Logger.info(atomArray[i].getInfo() + " " + f);
            }
            fArray[i] = f;
        }
    }

    public void setup(int n, float[] fArray, Point3f[] point3fArray, BitSet bitSet) {
        if (n >= 0) {
            this.distanceMode = n;
        }
        this.potentials = fArray;
        this.atomCoordAngstroms = point3fArray;
        this.bsSelected = bitSet;
    }

    public void calculate(VolumeDataInterface volumeDataInterface, BitSet bitSet, Point3f[] point3fArray, float[] fArray, int n) {
        this.setup(n, fArray, point3fArray, bitSet);
        this.voxelData = volumeDataInterface.getVoxelData();
        int[] nArray = volumeDataInterface.getVoxelCounts();
        this.initialize(nArray[0], nArray[1], nArray[2]);
        this.setupCoordinates(volumeDataInterface.getOriginFloat(), volumeDataInterface.getVolumetricVectorLengths(), bitSet, point3fArray);
        this.processMep();
    }

    private void processMep() {
        int n = this.qmAtoms.length;
        while (--n >= 0) {
            this.thisAtom = this.qmAtoms[n];
            if (this.thisAtom == null) continue;
            float f = this.potentials[n];
            if (Logger.debugging) {
                Logger.info("process map for atom " + n + this.thisAtom + "  charge=" + f);
            }
            this.thisAtom.setXYZ(true);
            int n2 = this.xMax;
            while (--n2 >= this.xMin) {
                float f2 = this.X2[n2];
                int n3 = this.yMax;
                while (--n3 >= this.yMin) {
                    float f3 = f2 + this.Y2[n3];
                    int n4 = this.zMax;
                    while (--n4 >= this.zMin) {
                        float[] fArray = this.voxelData[n2][n3];
                        int n5 = n4;
                        fArray[n5] = fArray[n5] + this.valueFor(f, f3 + this.Z2[n4], this.distanceMode);
                    }
                }
            }
        }
    }

    public float valueFor(float f, float f2, int n) {
        switch (n) {
            case 0: {
                return f2 == 0.0f ? f * Float.POSITIVE_INFINITY : f / (float)Math.sqrt(f2);
            }
            case 2: {
                return f / (1.0f + (float)Math.sqrt(f2));
            }
            case 1: {
                return f * (float)Math.exp(-Math.sqrt(f2) / 2.0);
            }
            case 3: {
                return f * (float)Math.exp(-Math.sqrt(f2));
            }
        }
        return f;
    }

    protected float getTabulatedPotential(Atom atom) {
        String string;
        Object object;
        String string2 = atom.getAtomType();
        String string3 = atom.getGroup1('\u0000');
        String string4 = atom.getGroupType();
        if (string3.length() == 0 && (string3 = atom.getGroup3(true)) == null) {
            string3 = "";
        }
        if ((object = this.htAtomicPotentials.get(string = string3 + string2)) == null && string4.length() > 0) {
            object = this.htAtomicPotentials.get("_" + string4.charAt(0) + string2);
        }
        return object instanceof Float ? ((Float)object).floatValue() : Float.NaN;
    }

    protected void getAtomicPotentials(String string, String string2) {
        BufferedReader bufferedReader = null;
        this.htAtomicPotentials = new Hashtable<String, Object>();
        try {
            InputStream inputStream;
            Object object;
            if (string == null) {
                object = null;
                object = this.getClass().getResource(string2);
                if (object == null) {
                    Logger.error("Couldn't find file: " + string2);
                    return;
                }
                inputStream = (InputStream)((URL)object).getContent();
            } else {
                inputStream = new ByteArrayInputStream(string.getBytes());
            }
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((object = bufferedReader.readLine()) != null) {
                String[] stringArray;
                if (((String)object).startsWith("#") || (stringArray = Parser.getTokens((String)object)).length < 2) continue;
                if (Logger.debugging) {
                    Logger.info((String)object);
                }
                this.htAtomicPotentials.put(stringArray[0], new Float(Parser.parseFloat(stringArray[1])));
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            Logger.error("Exception " + exception.getMessage() + " in getResource " + string2);
            try {
                bufferedReader.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }
}

